/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.query;

import com.humuson.tms.adaptor.jdbc.DBType;
import com.humuson.tms.adaptor.jdbc.DBTypeDetector;
import com.humuson.tms.adaptor.jdbc.mybatis.DefaultDatabaseConfig;
import com.humuson.tms.config.ClassDispatcher;
import com.humuson.tms.trans.module.query.DB2QueryOptimizer;
import com.humuson.tms.trans.module.query.MssqlQueryOptimizer;
import com.humuson.tms.trans.module.query.MysqlQueryOptimizer;
import com.humuson.tms.trans.module.query.OracleQueryOptimizer;
import com.humuson.tms.trans.module.query.QueryOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public abstract class QueryOptimizerFactory {
    private static final Logger log = LoggerFactory.getLogger(QueryOptimizerFactory.class);
    private static final String MYSQL = "MYSQL";
    private static final String MARIA = "MARIA";
    private static final String ORACLE = "ORACLE";
    private static final String MSSQL = "MSSQL";
    private static final String DB2 = "DB2";
    @Value(value="${spring.datasource.driver-class-name}")
    String datasourceDriverClassName;
    @Autowired
    DefaultDatabaseConfig defaultDatabaseConfig;
    protected QueryOptimizer defaultOptimizer = null;

    public void setDefaultOptimizer() {
        DBType dbType = this.defaultDatabaseConfig.getDbType();
        this.setOptimizer(dbType);
    }

    private void setOptimizer(DBType dbType) {
        this.defaultOptimizer = this.optimizerDetect(dbType);
    }

    public QueryOptimizer getDefaultOptimizer() {
        this.setDefaultOptimizer();
        return this.defaultOptimizer;
    }

    public QueryOptimizer getQueryOptimizer(String dbTypeTxt) {
        DBType dbType = DBTypeDetector.databaseType((String)dbTypeTxt);
        return this.optimizerDetect(dbType);
    }

    private QueryOptimizer optimizerDetect(DBType dbType) {
        if (dbType.name().equals(MYSQL) || dbType.name().equals(MARIA)) {
            return (QueryOptimizer)ClassDispatcher.getApplicationContext().getBean(MysqlQueryOptimizer.class);
        }
        if (dbType.name().equals(ORACLE)) {
            return (QueryOptimizer)ClassDispatcher.getApplicationContext().getBean(OracleQueryOptimizer.class);
        }
        if (dbType.name().equals(MSSQL)) {
            return (QueryOptimizer)ClassDispatcher.getApplicationContext().getBean(MssqlQueryOptimizer.class);
        }
        if (dbType.name().equals(DB2)) {
            return (QueryOptimizer)ClassDispatcher.getApplicationContext().getBean(DB2QueryOptimizer.class);
        }
        log.error("DS5001|not matching[MYSQL||MARIADB||ORACLE] default datasource=[{}] confirm property:[spring.datasource.driver-class-name]. so return null", (Object)this.datasourceDriverClassName);
        return null;
    }
}

