/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.event;

import com.humuson.tms.config.Constants;
import com.humuson.tms.monitor.Observer;
import com.humuson.tms.monitor.command.MonitorCommand;
import com.humuson.tms.trans.module.TmsBatchTargetInfoFactory;
import com.humuson.tms.trans.module.TmsSchdInfoFactory;
import com.humuson.tms.trans.module.batch.TmsBatchTargetInfo;
import com.humuson.tms.trans.module.event.PushBlockTimeException;
import com.humuson.tms.trans.module.event.TargetEvent;
import com.humuson.tms.trans.module.event.TypeTargetEvent;
import com.humuson.tms.trans.repository.dao.SchdInfoDao;
import com.humuson.tms.trans.repository.dao.SendInfoDao;
import com.humuson.tms.trans.repository.model.TmsAppInfo;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class TargetEventListener
implements Observer<MonitorCommand> {
    private static final Logger log = LoggerFactory.getLogger(TargetEventListener.class);
    @Autowired
    SendInfoDao sendInfoDao;
    @Autowired
    SchdInfoDao schdInfoDao;
    @Autowired
    TmsBatchTargetInfoFactory batchTargetInfoFactory;
    @Autowired
    TmsSchdInfoFactory tmsSchdInfoFactory;
    @Value(value="${tms.target-limit.query}")
    public long maxQueryCount;
    @Value(value="${tms.target-limit.file}")
    public long maxFileLine;
    boolean isOracle;

    @EventListener
    public void targetEventListener(TargetEvent<List<TmsSendInfo>> event) {
        Constants.TriggerMethod triggerMethod = null;
        if (event instanceof TypeTargetEvent) {
            triggerMethod = ((TypeTargetEvent)event).getType();
        }
        List<TmsSendInfo> tmsSendInfos = event.getTargetEvent();
        for (TmsSendInfo tmsSendInfo : tmsSendInfos) {
            try {
                if (this.blockTimeCheckIfPush(tmsSendInfo)) {
                    log.error("DS0115|send info[id={}] push channel is blocking time. failed targeting throw PushBlockTimeExceptionsendInfo[{}]", (Object)tmsSendInfo.getSEND_ID(), (Object)tmsSendInfo);
                    throw new PushBlockTimeException(tmsSendInfo.getSEND_ID());
                }
                TmsBatchTargetInfo tmsBatchTargetInfo = this.batchTargetInfoFactory.createBatchTargetInfo(tmsSendInfo);
                MoveCauseComment comment = this.createComment();
                long countToTarget = tmsBatchTargetInfo.getREAD_TARGET_INFO().getTARGET_COUNT();
                boolean isZero = false;
                if (this.targetCountIsZero(countToTarget)) {
                    log.info("target count is zero. tracking day past[1900-01-01] fix send-id={}", (Object)tmsSendInfo.getSEND_ID());
                    isZero = true;
                }
                this.updateSendInfoJobStatus(tmsSendInfo.getSEND_ID(), "20");
                if (!log.isInfoEnabled()) continue;
                log.info("send_info[id={}] channel[{}] target count[{}]. cause[{}] moving updated jobstatus(20)", new Object[]{tmsSendInfo.getSEND_ID(), tmsSendInfo.getCHANNEL_TYPE(), tmsBatchTargetInfo.getREAD_TARGET_INFO().getTARGET_COUNT(), comment.getComment()});
            }
            catch (TooManyResultsException te) {
                log.error("DS0111|trigger method[{}] send_id[{}] target_id[{}] target selecting(10) over than one. so update job-status[41]", new Object[]{triggerMethod.name(), tmsSendInfo.getSEND_ID(), tmsSendInfo.getTARGET_ID(), tmsSendInfo, te});
                this.updateSendInfoJobStatus(tmsSendInfo.getSEND_ID(), "41");
            }
            catch (FileNotFoundException fe) {
                log.error("DS0112|trigger method[{}] send_id[{}] target file not found. update job-status[41]", new Object[]{triggerMethod.name(), tmsSendInfo.getSEND_ID(), tmsSendInfo, fe});
                this.updateSendInfoJobStatus(tmsSendInfo.getSEND_ID(), "41");
            }
            catch (Exception e) {
                log.error("DS0113|trigger method[{}] send_id[{}] targeting setting error send_info[{}] update job-status[41]", new Object[]{triggerMethod.name(), tmsSendInfo.getSEND_ID(), tmsSendInfo, e});
                this.updateSendInfoJobStatus(tmsSendInfo.getSEND_ID(), "41");
            }
        }
    }

    private void whereToTarget(TmsSendInfo tmsSendInfo, TmsBatchTargetInfo tmsBatchTargetInfo, MoveCauseComment comment, boolean isZero) throws Exception {
        if (this.isNecessaryToMoveTarget(tmsBatchTargetInfo, comment)) {
            this.updateSendInfoJobStatus(tmsSendInfo.getSEND_ID(), "20");
            if (log.isInfoEnabled()) {
                log.info("send_info[id={}] channel[{}] target count[{}]. cause[{}] moving updated jobstatus(20)", new Object[]{tmsSendInfo.getSEND_ID(), tmsSendInfo.getCHANNEL_TYPE(), tmsBatchTargetInfo.getREAD_TARGET_INFO().getTARGET_COUNT(), comment.getComment()});
            }
        } else {
            if (this.isDuplicateTargetOnlyO1(tmsSendInfo.getSEND_ID())) {
                return;
            }
            this.tmsSchdInfoFactory.createAndInsertSchdInfo(tmsSendInfo, false, isZero);
            this.updateSendInfoJobStatus(tmsSendInfo.getSEND_ID(), "30");
            if (log.isInfoEnabled()) {
                log.info("send_info[id={}] channel[{}] target count[{}] Immediately updated jobstatus(30)", new Object[]{tmsSendInfo.getSEND_ID(), tmsSendInfo.getCHANNEL_TYPE(), tmsBatchTargetInfo.getREAD_TARGET_INFO().getTARGET_COUNT()});
            }
        }
    }

    private boolean isDuplicateTargetOnlyO1(long sendId) {
        boolean isDuplicate = false;
        List<TmsSchdInfo> schdInfos = this.schdInfoDao.selectSchdInfos(sendId, Constants.TriggerMethod.O1.name());
        if (!ObjectUtils.isEmpty(schdInfos)) {
            isDuplicate = true;
            StringBuffer sb = new StringBuffer();
            for (TmsSchdInfo schdInfo : schdInfos) {
                sb.append(schdInfo.getSCHD_ID());
                sb.append(",");
            }
            log.error("DS0114|Targeting was completed in the past. so don't target. completed schd-id[{}] of send-id[{}] ", (Object)sb.toString(), (Object)sendId);
        }
        return isDuplicate;
    }

    private boolean targetCountIsZero(long count) {
        return count == 0L;
    }

    private MoveCauseComment createComment() {
        return new MoveCauseComment(){
            private String comment = "";

            @Override
            public void setComment(String c) {
                this.comment = this.comment + "-" + c;
            }

            @Override
            public String getComment() {
                return this.comment;
            }
        };
    }

    private boolean blockTimeCheckIfPush(TmsSendInfo tmsSendInfo) throws ParseException {
        return this.isPush(tmsSendInfo.getCHANNEL_TYPE()) && this.isOtypeTriggerMethod(tmsSendInfo.getTRIGGER_METHOD()) && this.isBlockTime(tmsSendInfo.getSEND_ADD_ID(), tmsSendInfo.getREQ_DATE());
    }

    private boolean isOtypeTriggerMethod(String triggerMethod) {
        return Constants.TriggerMethod.O1.name().equals(triggerMethod) || Constants.TriggerMethod.O9.name().equals(triggerMethod);
    }

    private boolean isBlockTime(int sendAddId, String reqDate) throws ParseException {
        SimpleDateFormat dt = new SimpleDateFormat("yyyyy-mm-dd hh:mm:ss");
        Date date = dt.parse(reqDate);
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        int hour = calendar.get(11);
        TmsAppInfo appInfo = this.sendInfoDao.selectTmsAppInfo(sendAddId);
        int start24Hour = Integer.parseInt(appInfo.getAUTO_BLOCK_START());
        int end24Hour = Integer.parseInt(appInfo.getAUTO_BLOCK_END());
        return start24Hour <= hour && hour <= end24Hour;
    }

    private boolean isPush(String channelType) {
        return Constants.ChannelType.PU.name().equalsIgnoreCase(channelType);
    }

    private void updateSendInfoJobStatus(long sendId, String jobStatus) {
        this.sendInfoDao.updateSendInfoJobStatus(sendId, jobStatus);
    }

    private boolean isNecessaryToMoveTarget(TmsBatchTargetInfo batchTargetInfo, MoveCauseComment comment) {
        if (batchTargetInfo.isAB_YN()) {
            comment.setComment("AB-TEST");
            return true;
        }
        if (batchTargetInfo.isPUSH_CHANNEL()) {
            comment.setComment("PUSH-CHANNEL");
            return true;
        }
        if (this.isTotalSend(batchTargetInfo.getSEND_ID())) {
            comment.setComment("MULTI-CHANNEL");
            return true;
        }
        long targetCount = batchTargetInfo.getREAD_TARGET_INFO().getTARGET_COUNT();
        if (Constants.TargetType.FILE.name().equalsIgnoreCase(batchTargetInfo.getTARGET_TYPE())) {
            comment.setComment("FILE-LIMIT[" + this.maxFileLine + "]-OVER");
            return targetCount > this.maxFileLine;
        }
        if (Constants.TargetType.DB.name().equalsIgnoreCase(batchTargetInfo.getTARGET_TYPE())) {
            comment.setComment("DB-LIMIT[" + this.maxQueryCount + "]-OVER");
            return targetCount > this.maxQueryCount;
        }
        return false;
    }

    private boolean isTotalSend(long sendId) {
        return "T".equalsIgnoreCase(this.sendInfoDao.selectTmsCampInfo(sendId).getCAMP_TYPE());
    }

    public String whoami() {
        return "DS-TARGET-EVENTER";
    }

    public void update(MonitorCommand t) {
        try {
            if (t.isRunStatus()) {
                t.stop();
            } else {
                t.start();
            }
        }
        catch (Exception e) {
            log.error("print stack trace", (Throwable)e);
        }
    }

    static interface MoveCauseComment {
        public void setComment(String var1);

        public String getComment();
    }
}

