/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch.sec;

import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.crypto.HumusonEncryptor;
import com.humuson.tms.trans.module.batch.sec.TmsBatchEncryptor;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.ObjectUtils;

@TmsComponent
@ConfigurationProperties(prefix="tms.security.encrypt")
public class BasicTmsBatchEncryptor
implements TmsBatchEncryptor {
    private Set<String> keys = new HashSet<String>();
    private String encryptKey;
    @Autowired
    private TmsCommonConfig tmsConfig;

    @PostConstruct
    public void init() {
        this.keys.add("TMS_M_EMAIL");
        this.keys.add("TMS_M_PHONE");
        this.encryptKey = this.tmsConfig.getHumusonKey();
    }

    @Override
    public Set<String> secKey() {
        return this.keys;
    }

    @Override
    public <O> O encrypt(String key, O value) {
        if (this.keys.contains(key)) {
            if (ObjectUtils.isEmpty(value)) {
                return value;
            }
            return (O)HumusonEncryptor.encrypt((String)value.toString(), (String)this.encryptKey);
        }
        return value;
    }
}

