/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch.sec;

import com.humuson.tms.trans.module.batch.sec.TmsBatchDecryptor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public abstract class BasicTmsBatchDecryptor
implements TmsBatchDecryptor {
    @Value(value="${tms.security.encrypt.keys}")
    private String[] keyList;
    protected Set<String> keys;

    @PostConstruct
    public void init() {
        this.keys = new HashSet<String>(Arrays.asList(this.keyList));
    }

    @Override
    public Set<String> decryptKeys() {
        return this.keys;
    }

    @Override
    public <O> O decrypt(String key, O value) {
        if (ObjectUtils.isEmpty(value)) {
            return value;
        }
        if (this.keys.contains(key)) {
            return this.decrypting(key, value);
        }
        return value;
    }

    protected abstract <O> O decrypting(String var1, O var2);
}

