/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch.option;

import com.humuson.tms.trans.module.batch.option.GrpSeqOption;
import java.util.concurrent.atomic.AtomicInteger;

public class TmsDefaultGrpSeqOption
implements GrpSeqOption {
    private static final long serialVersionUID = 1L;
    private int divide_count;
    private boolean isNext = false;
    private AtomicInteger nowCount = new AtomicInteger();
    private AtomicInteger totalCount = new AtomicInteger();
    private AtomicInteger preGrpSeq = new AtomicInteger();
    private AtomicInteger nowGrpSeq = new AtomicInteger();

    @Override
    public void initGrpSeq(int DIVIDE_COUNT) {
        this.divide_count = DIVIDE_COUNT;
        this.preGrpSeq.set(0);
        this.nowGrpSeq.set(0);
        this.nowCount.set(0);
    }

    @Override
    public void initGrpSeq() {
        this.divide_count = 0;
        this.preGrpSeq.set(0);
        this.nowGrpSeq.set(0);
        this.nowCount.set(0);
    }

    @Override
    public void increment(int count) {
        this.nowGrpSeq.set(this.nowGrpSeq.get() + count);
    }

    @Override
    public void increment() {
        this.totalCount.incrementAndGet();
        if (this.nowCount.getAndIncrement() > this.divide_count) {
            this.next();
        }
    }

    private void next() {
        this.isNext = true;
        this.nowCount.set(0);
        this.preGrpSeq.set(this.nowGrpSeq.get());
        this.nowGrpSeq.getAndIncrement();
    }

    @Override
    public int getTotalCount() {
        return this.totalCount.get();
    }

    @Override
    public int getGrpSeq() {
        return this.nowGrpSeq.get();
    }

    @Override
    public int getPreGrpSeq() {
        return this.preGrpSeq.get();
    }

    @Override
    public boolean isNextChanged() {
        return this.isNext;
    }

    @Override
    public void initNext(boolean next) {
        this.isNext = next;
    }
}

