/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch.confing;

import com.humuson.tms.adaptor.jdbc.mybatis.DefaultDatabaseConfig;
import com.humuson.tms.trans.module.batch.confing.AsyncTaskPoolExecutorProperty;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@Configuration
@EnableBatchProcessing
@DependsOn(value={"defaultDatabaseConfig"})
public class TmsSimpleJobLauncherConfiguration
implements ImportBeanDefinitionRegistrar,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TmsSimpleJobLauncherConfiguration.class);
    @Autowired
    AsyncTaskPoolExecutorProperty asyncTaskPoolExecutorProperty;
    private Map<String, SimpleJobLauncher> launchers = new HashMap<String, SimpleJobLauncher>();
    @Autowired
    @Qualifier(value="tmsJobRepository")
    JobRepository jobRepository;
    @Autowired
    DefaultDatabaseConfig defaultDatabaseConfig;

    private String getName(String methodName) {
        return methodName.substring(0, 2).toUpperCase();
    }

    public SimpleJobLauncher getLauncher(String triggerMethod) throws Exception {
        if (this.launchers.containsKey(triggerMethod)) {
            return this.launchers.get(triggerMethod);
        }
        log.info("this job launcher[{}] not existed. so return default job launcher", (Object)triggerMethod);
        return this.dfJobLauncher();
    }

    @Bean
    public SimpleJobLauncher o1JobLauncher() throws Exception {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.createSimpleJobLauncher(this.getName(methodName));
    }

    @Bean
    public SimpleJobLauncher o8JobLauncher() throws Exception {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.createSimpleJobLauncher(this.getName(methodName));
    }

    @Bean
    public SimpleJobLauncher o9JobLauncher() throws Exception {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.createSimpleJobLauncher(this.getName(methodName));
    }

    @Bean
    public SimpleJobLauncher c1JobLauncher() throws Exception {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.createSimpleJobLauncher(this.getName(methodName));
    }

    @Bean
    public SimpleJobLauncher c2JobLauncher() throws Exception {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.createSimpleJobLauncher(this.getName(methodName));
    }

    @Bean
    public SimpleJobLauncher c3JobLauncher() throws Exception {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.createSimpleJobLauncher(this.getName(methodName));
    }

    @Bean
    public SimpleJobLauncher c4JobLauncher() throws Exception {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.createSimpleJobLauncher(this.getName(methodName));
    }

    @Bean
    public SimpleJobLauncher c5JobLauncher() throws Exception {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.createSimpleJobLauncher(this.getName(methodName));
    }

    @Bean
    public SimpleJobLauncher dfJobLauncher() throws Exception {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.createSimpleJobLauncher(this.getName(methodName), this.getAsyncTaskExecutor(this.getName(methodName)), true);
    }

    private ThreadPoolTaskExecutor defaultAsyncTaskPoolExecutor(String jobName) {
        return this.getAsyncTaskExecutor(jobName, null);
    }

    public SimpleJobLauncher getSimpleJobLauncher(String jobName) throws Exception {
        return this.createSimpleJobLauncher(jobName, this.getAsyncTaskExecutor(jobName), false);
    }

    public SimpleJobLauncher createSimpleJobLauncher(String jobName) throws Exception {
        Method method = this.getClass().getMethod(jobName.toLowerCase() + "TaskExecutor", new Class[0]);
        return this.createSimpleJobLauncher(jobName, (ThreadPoolTaskExecutor)method.invoke((Object)this, new Object[0]), true);
    }

    public SimpleJobLauncher createSimpleJobLauncher(String jobName, ThreadPoolTaskExecutor executor, boolean save) throws Exception {
        SimpleJobLauncher simpleJobLauncher = new SimpleJobLauncher();
        simpleJobLauncher.setJobRepository(this.jobRepository);
        simpleJobLauncher.setTaskExecutor((TaskExecutor)executor);
        simpleJobLauncher.afterPropertiesSet();
        if (save) {
            this.launchers.put(jobName, simpleJobLauncher);
        }
        return simpleJobLauncher;
    }

    @Bean(value={"O1.task.executor"})
    public ThreadPoolTaskExecutor o1TaskExecutor() {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.getAsyncTaskExecutor(this.getName(methodName));
    }

    @Bean(value={"O8.task.executor"})
    public ThreadPoolTaskExecutor o8TaskExecutor() {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.getAsyncTaskExecutor(this.getName(methodName));
    }

    @Bean(value={"O9.task.executor"})
    public ThreadPoolTaskExecutor o9TaskExecutor() {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.getAsyncTaskExecutor(this.getName(methodName));
    }

    @Bean(value={"C1.task.executor"})
    public ThreadPoolTaskExecutor c1TaskExecutor() {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.getAsyncTaskExecutor(this.getName(methodName));
    }

    @Bean(value={"C2.task.executor"})
    public ThreadPoolTaskExecutor c2TaskExecutor() {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.getAsyncTaskExecutor(this.getName(methodName));
    }

    @Bean(value={"C3.task.executor"})
    public ThreadPoolTaskExecutor c3TaskExecutor() {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.getAsyncTaskExecutor(this.getName(methodName));
    }

    @Bean(value={"C4.task.executor"})
    public ThreadPoolTaskExecutor c4TaskExecutor() {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.getAsyncTaskExecutor(this.getName(methodName));
    }

    @Bean(value={"C5.task.executor"})
    public ThreadPoolTaskExecutor c5TaskExecutor() {
        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
        return this.getAsyncTaskExecutor(this.getName(methodName));
    }

    public ThreadPoolTaskExecutor getAsyncTaskExecutor(String jobName) {
        List<AsyncTaskPoolExecutorProperty.AsyncTaskPoolExecutor> asyncTaskPoolExecutor = this.asyncTaskPoolExecutorProperty.getAsyncTaskPoolExecutor();
        for (AsyncTaskPoolExecutorProperty.AsyncTaskPoolExecutor executor : asyncTaskPoolExecutor) {
            if (!jobName.equals(executor.getName())) continue;
            return this.getAsyncTaskExecutor(jobName, executor);
        }
        return this.getAsyncTaskExecutor(jobName, null);
    }

    public ThreadPoolTaskExecutor getAsyncTaskExecutor(String jobName, AsyncTaskPoolExecutorProperty.AsyncTaskPoolExecutor executorConfig) {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        if (executorConfig == null) {
            taskExecutor.setCorePoolSize(this.asyncTaskPoolExecutorProperty.core_pool_size);
            taskExecutor.setMaxPoolSize(this.asyncTaskPoolExecutorProperty.max_pool_size);
            taskExecutor.setQueueCapacity(this.asyncTaskPoolExecutorProperty.capacity);
            taskExecutor.setThreadGroupName(jobName);
            taskExecutor.setThreadNamePrefix("DS-" + jobName + "-ASYNC-D-");
        } else {
            taskExecutor.setCorePoolSize(executorConfig.getCore_pool_size());
            taskExecutor.setMaxPoolSize(executorConfig.getMax_pool_size());
            taskExecutor.setQueueCapacity(executorConfig.getCapacity());
            taskExecutor.setThreadGroupName(jobName);
            taskExecutor.setThreadNamePrefix("DS-" + jobName + "-ASYNC-");
        }
        taskExecutor.initialize();
        log.info("async batch job[{}] / task executor[{}] launcher created", (Object)jobName, (Object)taskExecutor);
        return taskExecutor;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
    }

    private void register(BeanDefinitionRegistry registry, String jobName) {
        RootBeanDefinition bd = new RootBeanDefinition(SimpleJobLauncher.class);
        bd.getConstructorArgumentValues().addGenericArgumentValue((Object)jobName);
        registry.registerBeanDefinition(jobName, (BeanDefinition)bd);
    }

    public void afterPropertiesSet() throws Exception {
        List<AsyncTaskPoolExecutorProperty.AsyncTaskPoolExecutor> asyncTaskPoolExecutor = this.asyncTaskPoolExecutorProperty.getAsyncTaskPoolExecutor();
        log.info("async task pool job name [{}]", this.asyncTaskPoolExecutorProperty.getJobs());
    }
}

