/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch.confing;

import java.util.List;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@EnableBatchProcessing
public class DynamicBatchAssembly<I, O> {
    @Autowired
    public JobBuilderFactory jobBuilderFactory;
    @Autowired
    public StepBuilderFactory stepBuilderFactory;
    @Value(value="${adaptor.move.from.chunk-count:100}")
    private int chunkSize;

    public Step step(String stepName, ItemReader itemReader, ItemProcessor itemProcessor, ItemWriter itemWriter) {
        return this.stepBuilderFactory.get(stepName).chunk(this.chunkSize).reader(itemReader).processor(itemProcessor).writer(itemWriter).build();
    }

    public Step step(String stepName, ItemReader itemReader, ItemProcessor itemProcessor, ItemWriter itemWriter, int chunkSize) {
        return this.stepBuilderFactory.get(stepName).chunk(chunkSize).reader(itemReader).processor(itemProcessor).writer(itemWriter).build();
    }

    public Job oneStepJob(String jobName, Step step) {
        return this.jobBuilderFactory.get(jobName).start(step).build();
    }

    public Job multiStepJob(String jobName, List<Step> steps) {
        JobBuilder builder = this.jobBuilderFactory.get(jobName);
        SimpleJobBuilder simpleBuilder = builder.start(steps.get(0));
        for (int i = 1; i < steps.size(); ++i) {
            simpleBuilder.next(steps.get(i));
        }
        return simpleBuilder.build();
    }
}

