/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch.confing;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class BatchTaskExecutorMonitor {
    private static final Logger log = LoggerFactory.getLogger(BatchTaskExecutorMonitor.class);
    Function<ThreadPoolTaskExecutor, Integer> taskExecutorStatusFunction = taskExecutor -> taskExecutor.getCorePoolSize() - taskExecutor.getActiveCount();
    @Autowired
    List<ThreadPoolTaskExecutor> threadPoolTaskExecutors;

    public synchronized boolean isAvailable(String triggerMethodName) {
        return this.taskActiveExecutor(triggerMethodName, this.taskExecutorStatusFunction, 100) > 0;
    }

    public synchronized int freePoolsize(String triggerMethodName, int defaultSize) {
        return this.taskActiveExecutor(triggerMethodName, this.taskExecutorStatusFunction, defaultSize);
    }

    private int taskActiveExecutor(String triggerMethodName, Function<ThreadPoolTaskExecutor, Integer> function, int defaultSize) {
        for (ThreadPoolTaskExecutor taskExecutor : this.threadPoolTaskExecutors) {
            if (taskExecutor.getThreadNamePrefix().indexOf(triggerMethodName) <= 0) continue;
            if (log.isDebugEnabled()) {
                log.debug("this trigger[{}] is pool size[{}] active count[{}]", new Object[]{triggerMethodName, taskExecutor.getCorePoolSize(), taskExecutor.getActiveCount()});
            }
            return function.apply(taskExecutor);
        }
        log.warn("this trigger method[{}] don't found so return default size[{}]", (Object)triggerMethodName, (Object)defaultSize);
        return defaultSize;
    }

    public static void main(String[] args) {
        Function<Integer, String> intToString = Objects::toString;
        Function<String, String> quote = s -> "'" + s + "'";
        Function<Integer, String> quoteIntToString = quote.compose(intToString);
        System.out.println(quoteIntToString.apply(5));
    }
}

