/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch.confing;

import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.BatchConfigurationException;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.support.JobRepositoryFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;

@Component
@Configuration
@EnableBatchProcessing
@DependsOn(value={"defaultDatabaseConfig"})
public class BatchJobConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BatchJobConfiguration.class);
    @Autowired
    @Qualifier(value="tmsDatasource")
    private DataSource dataSource;
    @Autowired
    PlatformTransactionManager transactionManager;

    @Bean
    @Primary
    @Qualifier(value="tmsJobRepository")
    public JobRepository createJobRepository() {
        JobRepositoryFactoryBean factoryBean = new JobRepositoryFactoryBean();
        factoryBean.setDataSource(this.dataSource);
        factoryBean.setTransactionManager(this.transactionManager);
        factoryBean.setIsolationLevelForCreate("ISOLATION_READ_COMMITTED");
        try {
            factoryBean.afterPropertiesSet();
            return factoryBean.getObject();
        }
        catch (Exception e) {
            log.error("1011|JobRepository bean could not be initialized");
            throw new BatchConfigurationException((Throwable)e);
        }
    }
}

