/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch;

import com.humuson.tms.adaptor.jdbc.DBType;
import com.humuson.tms.adaptor.jdbc.mybatis.DefaultDatabaseConfig;
import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.trans.module.TmsSchdInfoFactory;
import com.humuson.tms.trans.module.batch.BatchProcessor;
import com.humuson.tms.trans.module.batch.NotExistSchdInfoException;
import com.humuson.tms.trans.module.batch.option.TmsDefaultGrpSeqOption;
import com.humuson.tms.trans.module.util.EmailUtil;
import com.humuson.tms.trans.repository.dao.SendInfoDao;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import com.humuson.tms.trans.repository.model.TmsTargetTemp;
import com.humuson.tms.trans.repository.storage.EmDomainFilter;
import com.humuson.tms.util.JsonUtil;
import com.humuson.tms.util.convert.TransObjectUtil;
import com.humuson.tms.util.date.DateUtil;
import com.humuson.tms.util.seq.SequenceContext;
import com.humuson.tms.util.validator.TmsValidator;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.util.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
@StepScope
@Qualifier(value="tmsTargetTempProcessor")
public class TmsTargetTempProcessor
extends BatchProcessor<Map<String, Object>, TmsTargetTemp>
implements StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(TmsTargetTempProcessor.class);
    StepExecution stepExecution;
    @Value(value="${tms.ds-schd-unit}")
    int defaultSchdUnit;
    @Value(value="${tms.ds-etc-size:4000}")
    int etcLimitSize;
    @Value(value="${tms.ds-etc-path}")
    String etcFilePath;
    long groupDivisionUnit = 0L;
    JobParameters jobParameters;
    protected AtomicInteger groupSeq = new AtomicInteger();
    protected AtomicInteger targetCount = new AtomicInteger();
    protected long divideMinite = 0L;
    protected boolean isDivideMinite = false;
    protected TmsDefaultGrpSeqOption tmsGrpSeqOption;
    protected boolean IS_AB_TEST = false;
    @Autowired
    protected DefaultDatabaseConfig defaultDatabaseConfig;
    protected static final String TMS_ETC = "TMS_ETC";
    @Autowired
    protected SendInfoDao sendInfoDao;
    @Autowired
    WrapperRedisTemplate redisTemplate;
    @Autowired
    TmsSchdInfoFactory tmsSchdInfoFactory;
    protected boolean IS_ORACLE = false;
    private boolean IS_REALTIME;
    protected long isABLastSendId;
    private Function<TmsTargetTemp, TmsTargetTemp> filterFunction = s -> {
        String domain;
        if ("EM".equals(this.jobParameters.getString("CHANNEL_TYPE")) && EmDomainFilter.INS.isFilterDomain(domain = EmailUtil.getDomain(s.getTMS_M_EMAIL()))) {
            s.setErrCode("1001");
        }
        return s;
    };
    TmsValidator<TmsTargetTemp> validator;
    protected TmsSendInfo tmsSendInfo;
    private int accumulateDivisionMinite;
    private boolean encrypt;
    protected long schd_id;
    protected long send_id;
    boolean isExistSchdInfo;

    public void beforeStep(StepExecution stepExecution) {
        this.IS_ORACLE = DBType.ORACLE == this.defaultDatabaseConfig.getDbType();
        this.stepExecution = stepExecution;
        stepExecution.getExecutionContext().put("IS_NEXT_GROUP", (Object)false);
        this.jobParameters = this.stepExecution.getJobExecution().getJobParameters();
        this.setGroupDivide();
        this.targetCount.set(0);
        this.setDivideMinute();
        this.send_id = this.jobParameters.getLong("SEND_ID");
        this.tmsSendInfo = this.sendInfoDao.selectSendInfo(this.send_id);
        this.encrypt = this.jobParameters.getString("ENCRYPT").equals("true");
        this.IS_REALTIME = "C5".equals(this.tmsSendInfo.getTRIGGER_METHOD());
        boolean bl = this.isExistSchdInfo = this.IS_REALTIME || "O7".equals(this.jobParameters.getString("TRIGGER_METHOD")) || "O8".equals(this.jobParameters.getString("TRIGGER_METHOD")) || this.jobParameters.getString("MOVE").equals("false");
        if (this.isExistSchdInfo) {
            this.schd_id = this.jobParameters.getLong("SCHD_ID");
            this.stepExecution.getExecutionContext().putLong("SCHD_ID", this.schd_id);
        } else {
            this.createSchdInfo(stepExecution);
        }
        this.validator = new TmsValidator();
    }

    protected void setDivideMinute() {
        this.divideMinite = this.jobParameters.getLong("DIVIDE_MINUTE");
        this.isDivideMinite = this.divideMinite != 0L;
    }

    protected void createSchdInfo(StepExecution stepExecution) {
        try {
            this.createSchdInfo();
        }
        catch (Exception e) {
            log.error("error creating tms_schd_info of send_id={}", (Object)this.send_id, (Object)e);
            stepExecution.setStatus(BatchStatus.FAILED);
        }
    }

    private void setGroupDivide() {
        this.groupDivisionUnit = this.jobParameters.getLong("GROUP_DIVISION_UNIT");
        this.setInitGrpSeq();
    }

    private void setInitGrpSeq() {
        int initGrpseq = this.sendInfoDao.selectTmsTargetTmpMaxGrpSeq((int)this.jobParameters.getLong("SEND_ID").longValue());
        this.groupSeq.set(initGrpseq);
        this.stepExecution.getExecutionContext().putInt("GRP_SEQ", this.groupSeq.get());
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return null;
    }

    public TmsTargetTemp process(Map<String, Object> items) throws Exception {
        this.targetCount.getAndIncrement();
        this.preProcess(items);
        this.setTmsTargetTempSeq(items);
        items.put("SCHD_ID", this.schd_id);
        TmsTargetTemp temp = (TmsTargetTemp)TransObjectUtil.mapToBean(TmsTargetTemp.class, items);
        return this.filterFunction.apply(temp);
    }

    protected void addJsonInfoETC(Map<String, Object> items) throws Exception {
        if (items.containsKey(TMS_ETC)) {
            return;
        }
        String etc = JsonUtil.convertMapToJsonString(items);
        if (etc.getBytes().length >= this.etcLimitSize) {
            this.createEtcFile(items, etc);
        } else {
            items.put(TMS_ETC, etc);
        }
    }

    private void createEtcFile(Map<String, Object> items, String etc) {
        String fileName = this.etcFilePath + items.get("SEND_ID").toString();
        try {
            boolean isCreateFile = FileUtils.createNewFile((File)new File(fileName));
            if (isCreateFile) {
                items.put(TMS_ETC, fileName);
            } else {
                log.error("failed create etc file[{}]. so put org etc data[{}]", (Object)fileName, (Object)etc);
                items.put(TMS_ETC, etc);
            }
        }
        catch (Exception e) {
            log.error("create etc file[{}] error. put org etc data[{}]", (Object)fileName, (Object)e);
            items.put(TMS_ETC, etc);
        }
    }

    private void preProcess(Map<String, Object> items) throws Exception {
        items.put("TARGET_FLAG", "N");
        items.put("SEND_ID", this.jobParameters.getString("SEND_ID"));
        items.put("WORKDAY", this.jobParameters.getString("WORKDAY"));
        items.put("TARGET_ID", this.jobParameters.getString("TARGET_ID"));
        if (!items.containsKey(TMS_ETC)) {
            items.put(TMS_ETC, JsonUtil.convertMapToJsonStringAddNull(items));
        } else if (ObjectUtils.isEmpty((Object)items.get(TMS_ETC))) {
            items.put(TMS_ETC, JsonUtil.convertMapToJsonStringAddNull(items));
        }
        if (this.isExistSchdInfo) {
            if (!items.containsKey("GRP_SEQ")) {
                items.put("GRP_SEQ", this.groupSeq.get());
            }
        } else {
            this.setGroupSeq(items);
        }
    }

    protected void setTmsTargetTempSeq(Map<String, Object> items) {
        if (!items.containsKey("TARGET_TEMP_ID")) {
            items.put("TARGET_TEMP_ID", SequenceContext.TmsTargetTempSeq.seq());
        }
    }

    protected void setGroupSeq(Map<String, Object> items) throws Exception {
        try {
            if ((long)this.targetCount.get() > this.groupDivisionUnit) {
                if (this.isDivideMinite) {
                    this.setDivideMinite(items);
                }
                this.groupSeqIncrement();
            }
            items.put("GRP_SEQ", this.groupSeq.get());
        }
        catch (Exception e) {
            log.error("group seq division error");
            throw e;
        }
    }

    protected void groupSeqIncrement() {
        this.targetCount.set(1);
        this.groupSeq.getAndIncrement();
        this.stepExecution.getExecutionContext().put("IS_NEXT_GROUP", (Object)true);
        this.stepExecution.getExecutionContext().putInt("GRP_SEQ", this.groupSeq.get());
        try {
            this.createSchdInfo();
        }
        catch (Exception e) {
            log.error("error create tms_schd_info send_id[{}]", (Object)this.send_id, (Object)e);
        }
    }

    protected void setDivideMinite(Map<String, Object> items) throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.add(12, (int)this.divideMinite);
        this.divideMinite += this.jobParameters.getLong("DIVIDE_MINITE").longValue();
        items.put("REQ_DATE", DateUtil.getFullDate((String)"yyyy-MM-dd HH:mm:ss", (Date)cal.getTime()));
    }

    protected void createSchdInfo() throws Exception {
        TmsSchdInfo tmsSchdInfo = this.tmsSchdInfoFactory.createSchdInfo(this.tmsSendInfo);
        if (ObjectUtils.isEmpty((Object)tmsSchdInfo)) {
            throw new NotExistSchdInfoException("send_id =" + this.tmsSendInfo.getSEND_ID());
        }
        if (this.isDivideMinite) {
            String reqDate = this.delaySendReqDate();
            log.info("send_id=[{}] delay divide minute req_date=[{}]", (Object)tmsSchdInfo.getSEND_ID(), (Object)reqDate);
            tmsSchdInfo.setREQ_DATE(reqDate);
        }
        tmsSchdInfo.setENCRYPT_YN(this.encrypt ? "Y" : "N");
        if (this.IS_AB_TEST && this.isABLastSendId == this.tmsSendInfo.getSEND_ID()) {
            tmsSchdInfo.setJOB_STATUS("00");
        }
        this.tmsSchdInfoFactory.insertSchdInfo(tmsSchdInfo);
        log.info("created schd_id[{}]/send_id[{}] GRP_SEQ[{}]", new Object[]{tmsSchdInfo.getSCHD_ID(), this.tmsSendInfo.getSEND_ID(), this.groupSeq});
        this.schd_id = tmsSchdInfo.getSCHD_ID();
        this.stepExecution.getExecutionContext().putLong("SCHD_ID", this.schd_id);
    }

    private String delaySendReqDate() {
        Calendar cal = Calendar.getInstance();
        cal.add(12, this.accumulateDivisionMinite);
        this.accumulateDivisionMinite += (int)this.divideMinite;
        return DateUtil.getFullDate((String)"yyyy-MM-dd HH:mm:ss", (Date)cal.getTime());
    }
}

