/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch;

import com.humuson.tms.adaptor.jdbc.DBType;
import com.humuson.tms.trans.module.batch.TmsTargetTempProcessor;
import com.humuson.tms.trans.repository.model.TmsTargetTemp;
import com.humuson.tms.util.convert.TransObjectUtil;
import com.humuson.tms.util.validator.TmsValidator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@StepScope
@Qualifier(value="tmsTargetTempDelayProcessor")
public class TmsTargetTempDelayProcessor
extends TmsTargetTempProcessor {
    private static final Logger log = LoggerFactory.getLogger(TmsTargetTempDelayProcessor.class);

    @Override
    public void beforeStep(StepExecution stepExecution) {
        this.IS_ORACLE = DBType.ORACLE == this.defaultDatabaseConfig.getDbType();
        this.stepExecution = stepExecution;
        stepExecution.getExecutionContext().put("IS_NEXT_GROUP", (Object)false);
        this.jobParameters = this.stepExecution.getJobExecution().getJobParameters();
        this.targetCount.set(0);
        this.groupSeq.set(-1);
        this.send_id = this.jobParameters.getLong("SEND_ID");
        this.tmsSendInfo = this.sendInfoDao.selectSendInfo(this.send_id);
        this.schd_id = this.jobParameters.getLong("SCHD_ID");
        this.stepExecution.getExecutionContext().putLong("SCHD_ID", this.schd_id);
        this.validator = new TmsValidator();
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        return null;
    }

    @Override
    public TmsTargetTemp process(Map<String, Object> items) throws Exception {
        this.targetCount.getAndIncrement();
        TmsTargetTemp temp = (TmsTargetTemp)TransObjectUtil.mapToBean(TmsTargetTemp.class, items);
        return temp;
    }

    private void setNextGroupSeq(Map<String, Object> items) {
        int nowGroupSeq = (Integer)items.get("GRP_SEQ");
        if (this.groupSeq.get() == -1) {
            this.groupSeq.set(nowGroupSeq);
        } else if (this.groupSeq.get() != nowGroupSeq) {
            this.groupSeq.set(nowGroupSeq);
            this.stepExecution.getExecutionContext().put("IS_NEXT_GROUP", (Object)true);
        }
    }
}

