/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch;

import com.humuson.tms.adaptor.jdbc.DBType;
import com.humuson.tms.trans.module.batch.TmsTargetTempProcessor;
import com.humuson.tms.trans.repository.model.TmsABInfo;
import com.humuson.tms.trans.repository.model.TmsTargetTemp;
import com.humuson.tms.util.JsonUtil;
import com.humuson.tms.util.convert.TransObjectUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@StepScope
@Qualifier(value="tmsTargetTempABProcessor")
public class TmsTargetTempABProcessor
extends TmsTargetTempProcessor {
    private static final Logger log = LoggerFactory.getLogger(TmsTargetTempABProcessor.class);
    List<TmsABInfo> tmsABTestInfos;
    TmsABInfo nowTmsABTestInfo = new TmsABInfo();
    protected AtomicInteger totalTargetCount = new AtomicInteger();

    @Override
    public void beforeStep(StepExecution stepExecution) {
        this.IS_ORACLE = DBType.ORACLE == this.defaultDatabaseConfig.getDbType();
        this.IS_AB_TEST = true;
        this.stepExecution = stepExecution;
        stepExecution.getExecutionContext().put("IS_NEXT_GROUP", (Object)false);
        stepExecution.getExecutionContext().put("ETC-CLOB", (Object)false);
        this.jobParameters = this.stepExecution.getJobExecution().getJobParameters();
        List<TmsABInfo> tmsABInfoTemps = this.sendInfoDao.selectAbTestInfo((int)this.jobParameters.getLong("SEND_ID").longValue());
        this.isABLastSendId = this.jobParameters.getLong("SEND_ID");
        this.tmsABTestInfos = new ArrayList<TmsABInfo>();
        Map abJobParameters = this.jobParameters.getParameters();
        for (TmsABInfo tmsABInfo : tmsABInfoTemps) {
            this.tmsABTestInfos.add((TmsABInfo)((JobParameter)abJobParameters.get(tmsABInfo.getSEND_ID() + tmsABInfo.getTYPE())).getValue());
        }
        this.nowTmsABTestInfo = this.tmsABTestInfos.get(0);
        this.setDivideMinute();
        this.targetCount.set(0);
        this.totalTargetCount.set(0);
        this.groupDivisionUnit = this.jobParameters.getLong("GROUP_DIVISION_UNIT");
        this.registSendId();
        this.createSchdInfo(stepExecution);
    }

    private void registSendId() {
        this.stepExecution.getExecutionContext().putInt("SEND_ID", this.nowTmsABTestInfo.getSEND_ID());
        this.tmsSendInfo = this.sendInfoDao.selectSendInfoEmptyTargetId(this.nowTmsABTestInfo.getSEND_ID());
    }

    private void isCountOverThenChangeABTestInfo() throws Exception {
        if (this.totalTargetCount.get() <= this.nowTmsABTestInfo.getEND_COUNT()) {
            return;
        }
        this.changeNextNowTmsABTestInfo();
        this.registSendId();
        this.groupSeqIncrement();
    }

    private void changeNextNowTmsABTestInfo() throws IllegalAccessException, InvocationTargetException {
        Iterator<TmsABInfo> it = this.tmsABTestInfos.iterator();
        while (it.hasNext()) {
            TmsABInfo value = it.next();
            if (value.getSEND_ID() != this.nowTmsABTestInfo.getSEND_ID()) continue;
            this.nowTmsABTestInfo = new TmsABInfo();
            it.remove();
            if (this.tmsABTestInfos.size() == 0) {
                this.nowTmsABTestInfo.setSEND_ID((int)this.jobParameters.getLong("SEND_ID").longValue());
                this.nowTmsABTestInfo.setEND_COUNT(Integer.MAX_VALUE);
                this.nowTmsABTestInfo.setCONTENT_ID(-1);
                break;
            }
            BeanUtils.copyProperties((Object)this.nowTmsABTestInfo, (Object)this.tmsABTestInfos.get(0));
            break;
        }
    }

    @Override
    public TmsTargetTemp process(Map<String, Object> items) throws Exception {
        this.targetCount.getAndIncrement();
        this.totalTargetCount.getAndIncrement();
        this.setTmsTargetTempSeq(items);
        this.preProcess(items);
        items.put("SCHD_ID", this.schd_id);
        TmsTargetTemp temp = (TmsTargetTemp)TransObjectUtil.mapToBean(TmsTargetTemp.class, items);
        return temp;
    }

    private void preProcess(Map<String, Object> items) throws Exception {
        this.isCountOverThenChangeABTestInfo();
        this.getSendId(items);
        items.put("TARGET_FLAG", "N");
        items.put("WORKDAY", this.jobParameters.getString("WORKDAY"));
        items.put("TARGET_ID", this.jobParameters.getString("TARGET_ID"));
        items.put("TMS_ETC", JsonUtil.convertMapToJsonStringAddNull(items));
        this.setGroupSeq(items);
    }

    private void getSendId(Map<String, Object> items) {
        items.put("SEND_ID", this.nowTmsABTestInfo.getSEND_ID());
    }
}

