/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch;

import com.humuson.tms.adaptor.activemq.ActiveMQSender;
import com.humuson.tms.adaptor.jdbc.TmsBatchDataSourceManager;
import com.humuson.tms.adaptor.jdbc.mybatis.DefaultDatabaseConfig;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsJdbcError;
import com.humuson.tms.adaptor.jdbc.mybatis.TmsJdbcTemplate;
import com.humuson.tms.config.ClassDispatcher;
import com.humuson.tms.config.Constants;
import com.humuson.tms.trans.module.AllTlistUploadException;
import com.humuson.tms.trans.module.TmsRedisPinfoProvider;
import com.humuson.tms.trans.module.TmsRedisSprocProvider;
import com.humuson.tms.trans.module.TmsRedisTlistProvider;
import com.humuson.tms.trans.module.TmsSchdInfoFactory;
import com.humuson.tms.trans.module.batch.BatchDbTargetInfo;
import com.humuson.tms.trans.module.batch.BatchFileTargetInfo;
import com.humuson.tms.trans.module.batch.TargetCounter;
import com.humuson.tms.trans.module.batch.TmsBatchTargetInfo;
import com.humuson.tms.trans.module.batch.TmsLocalItemWriter;
import com.humuson.tms.trans.repository.dao.SendInfoDao;
import com.humuson.tms.trans.repository.model.TmsABInfo;
import com.humuson.tms.trans.repository.model.TmsBatchStepExecution;
import com.humuson.tms.trans.repository.model.TmsEmTargetTemp;
import com.humuson.tms.trans.repository.model.TmsPuTargetTemp;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import com.humuson.tms.trans.repository.model.TmsTargetTemp;
import com.humuson.tms.trans.repository.model.redis.PinfoVo;
import com.humuson.tms.trans.repository.model.redis.SprocVo;
import com.humuson.tms.trans.repository.model.redis.TlistVo;
import com.humuson.tms.util.JsonUtil;
import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.SQL;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnWriteError;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Component
@DependsOn(value={"tmsRedisSprocProvider"})
public class TmsLocalItemWriter<O> {
    private static final Logger log = LoggerFactory.getLogger(TmsLocalItemWriter.class);
    private static final String SUCCESS_CODE = "0000";
    private final DefaultDatabaseConfig defaultDatabaseConfig;
    final TmsSchdInfoFactory tmsSchdInfoFactory;
    final SendInfoDao sendInfoDao;
    final TmsRedisPinfoProvider tmsRedisPinfoProvider;
    final TmsRedisSprocProvider tmsRedisSprocProvider;
    final TmsRedisTlistProvider tmsRedisTlistProvider;
    @Autowired
    @Qualifier(value="activemq-sender")
    ActiveMQSender mqSender;

    @Bean
    @Primary
    @Scope(value="prototype")
    public TargetingItemWriter targetingItemWriter() {
        return new TargetingItemWriter();
    }

    public TmsLocalItemWriter(DefaultDatabaseConfig defaultDatabaseConfig, TmsSchdInfoFactory tmsSchdInfoFactory, SendInfoDao sendInfoDao, TmsRedisPinfoProvider tmsRedisPinfoProvider, TmsRedisSprocProvider tmsRedisSprocProvider, TmsRedisTlistProvider tmsRedisTlistProvider) {
        this.defaultDatabaseConfig = defaultDatabaseConfig;
        this.tmsSchdInfoFactory = tmsSchdInfoFactory;
        this.sendInfoDao = sendInfoDao;
        this.tmsRedisPinfoProvider = tmsRedisPinfoProvider;
        this.tmsRedisSprocProvider = tmsRedisSprocProvider;
        this.tmsRedisTlistProvider = tmsRedisTlistProvider;
    }

    @Service
    @Scope(value="prototype")
    public class TargetingItemWriter
    implements ItemWriter<O> {
        private static final String AUTO_MAPPER_QUEUE = "auto.mapper.queue";
        private static final String MASS_MAPPER_QUEUE = "mass.mapper.queue";
        public static final String SUCCESS_CODE = "0000";
        @Autowired
        TmsJdbcTemplate insertJdbcTemplate;
        Map<Integer, TmsJdbcTemplate> updateJdbcTemplates;
        List<Map<Integer, String>> updateQuerys;
        private StepExecution stepExecution;
        private TmsBatchTargetInfo targetInfo;
        private BatchDbTargetInfo dbTargetInfo;
        private List<Long> sendIds = new ArrayList<Long>();
        private boolean useUpdateQuery;
        private boolean isUpdatedError;
        private boolean isPushChannel;
        private boolean isAbTest;
        private boolean isLastABTest;
        private boolean isRealtime = false;
        private boolean isCancel = false;
        private boolean isDelaySending = false;
        private boolean isSecondTarget = false;
        private boolean isMove;
        private TmsSendInfo tmsSendInfo;
        private List<TmsABInfo> tmsABInfos;
        private String grpId;
        Map<String, List<O>> targetABTemps = new HashMap();
        private DataSource readDataSource = null;
        List<? extends O> successTargetTemp;
        private PinfoVo basicPinfoVo;
        private TlistVo basicTlistVo;
        List<? extends O> pureTargetRemoved;
        private int insertedCountToTempTable;
        private String progressStatus = "0000";
        private com.humuson.tms.trans.module.batch.TmsLocalItemWriter$TargetingItemWriter.TargetTempBySchd nowTargetTempBySchd;
        private long ABMainSendId;

        public void setReadDataSource(DataSource dataSource) {
            this.readDataSource = dataSource;
        }

        public void setDelayTargetInfo(TmsBatchTargetInfo targetInfo) throws Exception {
            this.defaultSetOption(targetInfo);
            this.isSecondTarget = true;
            this.tmsSendInfo = TmsLocalItemWriter.this.sendInfoDao.selectSendInfoEmptyTargetId(this.targetInfo.getSEND_ID());
            if (targetInfo.isAB_YN() && this.tmsSendInfo.getTARGET_ID() == 0L) {
                this.tmsSendInfo.setTARGET_ID(TmsLocalItemWriter.this.sendInfoDao.selectTargetIdOfAB(this.tmsSendInfo.getSEND_ADD_ID()));
            }
            this.setDefaultRedisVo(targetInfo);
        }

        public void setTargetInfo(TmsBatchTargetInfo targetInfo) throws Exception {
            this.defaultSetOption(targetInfo);
            if (this.isAbTest) {
                log.info("A/B Test main send_id={}", (Object)targetInfo.getSEND_ID());
                this.tmsABInfos = targetInfo.getTMS_AB_TARGETS();
                this.tmsSendInfo = TmsLocalItemWriter.this.sendInfoDao.selectSendInfoEmptyTargetId(this.tmsABInfos.get(0).getSEND_ID());
                this.sendIds.add(this.tmsSendInfo.getSEND_ID());
                this.tmsSendInfo.setTARGET_ID(targetInfo.getTARGET_ID());
                this.ABMainSendId = targetInfo.getSEND_ID();
            } else {
                this.tmsSendInfo = TmsLocalItemWriter.this.sendInfoDao.selectSendInfo(this.targetInfo.getSEND_ID());
            }
            if (Constants.TargetType.FILE.name().equals(targetInfo.getTARGET_TYPE())) {
                this.useUpdateQuery = false;
                this.dbTargetInfo = new BatchDbTargetInfo();
                BatchFileTargetInfo target = (BatchFileTargetInfo)targetInfo.getREAD_TARGET_INFO();
                this.dbTargetInfo.setJOB_NAME(target.getJOB_NAME());
                this.tmsSendInfo.setTARGET_TYPE(Constants.TargetType.FILE.name());
            } else {
                this.dbTargetInfo = (BatchDbTargetInfo)targetInfo.getREAD_TARGET_INFO();
                this.useUpdateQuery(this.dbTargetInfo.getUPDATE_QUERY());
            }
            String[] grpIds = this.dbTargetInfo.getJOB_NAME().split(":");
            String systime = "" + System.currentTimeMillis();
            this.grpId = StringUtils.isEmpty((String)grpIds[grpIds.length - 1]) ? systime : grpIds[grpIds.length - 1];
            this.insertJdbcTemplate.db(TmsLocalItemWriter.this.defaultDatabaseConfig.directLocalDataSource());
            this.setDefaultRedisVo(targetInfo);
        }

        private void defaultSetOption(TmsBatchTargetInfo targetInfo) {
            this.targetInfo = targetInfo;
            this.isMove = targetInfo.isMOVE();
            this.isDelaySending = targetInfo.getDIVIDE_MINUTE() != 0 && this.isMove;
            this.isPushChannel = this.targetInfo.isPUSH_CHANNEL();
            this.isRealtime = Constants.TriggerMethod.C5.name().equals(targetInfo.getTRIGGER_METHOD());
            this.isAbTest = targetInfo.isAB_YN();
        }

        private void setDefaultRedisVo(TmsBatchTargetInfo targetInfo) throws Exception {
            this.basicPinfoVo = this.createBasicPinfo();
            this.basicPinfoVo.setTARGET_SEQ_MAX(0L);
            this.basicTlistVo = new TlistVo();
            this.basicTlistVo.setCamp_type(targetInfo.getTRIGGER_METHOD());
            this.basicTlistVo.setDomain(targetInfo.getTARGET_TYPE());
            this.basicTlistVo.setChannel_type(targetInfo.getCHANNEL_TYPE());
        }

        private PinfoVo createBasicPinfo() throws Exception {
            return TmsLocalItemWriter.this.tmsRedisPinfoProvider.createBasicPinfo(this.tmsSendInfo);
        }

        private void useUpdateQuery(List<Map<Integer, String>> updateQuerys) throws Exception {
            if (!ObjectUtils.isEmpty(updateQuerys)) {
                this.updateQuerys = updateQuerys;
                this.updateJdbcTemplates = new ConcurrentHashMap<Integer, TmsJdbcTemplate>();
                for (Map<Integer, String> updates : updateQuerys) {
                    Integer dbId = (Integer)updates.keySet().toArray()[0];
                    if (this.updateJdbcTemplates.containsKey(dbId)) continue;
                    TmsJdbcTemplate updateJdbcTemplate = (TmsJdbcTemplate)ClassDispatcher.getApplicationContext().getBean(TmsJdbcTemplate.class);
                    updateJdbcTemplate.db(TmsBatchDataSourceManager.INSTANCE.getDataSource(dbId.intValue()));
                    this.updateJdbcTemplates.put(dbId, updateJdbcTemplate);
                }
                this.useUpdateQuery = true;
            } else {
                this.useUpdateQuery = false;
            }
        }

        public void write(List<? extends O> targets) throws Exception {
            this.isCancelThenStop();
            if (this.necessaryGroupIncrement()) {
                this.separateTargeting(targets);
            } else {
                this.insertToTargetTemp(targets, this.firstThenCreateTargetTempBySchd(targets));
            }
        }

        private void separateTargeting(List<? extends O> targets) throws Exception {
            Map separatedTargetsBySchd = this.separateTargetsBySchd(targets);
            for (Long schdId : separatedTargetsBySchd.keySet()) {
                try {
                    this.firstThenCreateTargetTempBySchd(schdId);
                    if (this.nowSameTargetTempBySchd(schdId)) {
                        this.insertToTargetTemp(separatedTargetsBySchd.get(schdId), (TargetTempBySchd)this.nowTargetTempBySchd);
                        continue;
                    }
                    this.endJobBySchd((TargetTempBySchd)this.nowTargetTempBySchd);
                    this.nowTargetTempBySchd = new TargetTempBySchd(schdId);
                    this.insertToTargetTemp(separatedTargetsBySchd.get(schdId), (TargetTempBySchd)this.nowTargetTempBySchd);
                }
                catch (Exception e) {
                    log.error("insert to TMS_TARGET_TEMP error. schdId=[{}] ", (Object)schdId, (Object)e);
                    throw e;
                }
            }
        }

        private com.humuson.tms.trans.module.batch.TmsLocalItemWriter$TargetingItemWriter.TargetTempBySchd firstThenCreateTargetTempBySchd(List<? extends O> targets) {
            return this.firstThenCreateTargetTempBySchd(((TmsTargetTemp)targets.get(0)).getSCHD_ID());
        }

        private com.humuson.tms.trans.module.batch.TmsLocalItemWriter$TargetingItemWriter.TargetTempBySchd firstThenCreateTargetTempBySchd(long schd_id) {
            if (this.nowTargetTempBySchd == null) {
                this.nowTargetTempBySchd = new TargetTempBySchd(schd_id);
            }
            return this.nowTargetTempBySchd;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void endJobBySchd(TargetTempBySchd nowTargetTempBySchd) {
            try {
                if (this.isDelaySending || this.isLastABTest) {
                    return;
                }
                this.uploadSproc(nowTargetTempBySchd);
                String errCode = nowTargetTempBySchd.getErrCode();
                if (!"0000".equals(nowTargetTempBySchd.getErrCode())) {
                    log.error("upload {} failed redis, do not sending MQ schd_id={}", (Object)("1001".equals(errCode) ? "PINFO" : "SPROC"), (Object)nowTargetTempBySchd.getTmsSchdInfo().getSCHD_ID());
                    return;
                }
            }
            catch (Exception e) {
                log.error("this schd_id=[{}] update error code[{}]", new Object[]{nowTargetTempBySchd.getTmsSchdInfo().getSCHD_ID(), this.progressStatus, e});
            }
            finally {
                this.updateEndStatusOfSchdInfo(nowTargetTempBySchd);
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private SprocVo uploadSproc(TargetTempBySchd nowTargetTempBySchd) throws Exception {
            this.progressStatus = "1002";
            TargetCounter counter = nowTargetTempBySchd.getTargetCounter();
            SprocVo sprocVo = TmsLocalItemWriter.this.tmsRedisSprocProvider.createSproc(nowTargetTempBySchd.getTmsSchdInfo().getSCHD_ID(), "40", counter.getTargetCountOfSchdInfo().get(), counter.getSuccessCumulativeCountRedisBySchdInfo().get(), counter.failedCountOfSchdInfo());
            sprocVo.setTARGET_SEQ(counter.getTargetSeq().get());
            this.progressStatus = "1003";
            boolean isSuccess = TmsLocalItemWriter.this.tmsRedisSprocProvider.upload(sprocVo);
            nowTargetTempBySchd.setErrCode(isSuccess ? "0000" : this.progressStatus);
            return sprocVo;
        }

        private void uploadPinfo() {
            this.uploadPinfo((TargetTempBySchd)this.nowTargetTempBySchd);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void uploadPinfo(TargetTempBySchd nowTargetTempBySchd) {
            this.progressStatus = "1001";
            TargetCounter counter = nowTargetTempBySchd.getTargetCounter();
            this.basicPinfoVo.setTARGET_SEQ_MAX(counter.getTargetSeq().get());
            this.basicPinfoVo.setCOUNT_TARGET(counter.getSuccessCumulativeCountRedisBySchdInfo().get());
            this.basicPinfoVo.setFAILED_TARGET(counter.failedCountOfSchdInfo());
            log.info("schd_id[{}], upload pinfo target_seq_max[{}] count_target[{}], fail_target[{}]", new Object[]{nowTargetTempBySchd.getTmsSchdInfo().getSCHD_ID(), counter.getTargetSeq().get(), counter.getSuccessCumulativeCountRedisBySchdInfo().get(), counter.failedCountOfSchdInfo()});
            boolean isSuccess = TmsLocalItemWriter.this.tmsRedisPinfoProvider.upload(this.basicPinfoVo, nowTargetTempBySchd.getTmsSchdInfo());
            nowTargetTempBySchd.setErrCode(isSuccess ? "0000" : this.progressStatus);
        }

        private boolean nowSameTargetTempBySchd(Long schdId) {
            return this.nowTargetTempBySchd.getTmsSchdInfo().getSCHD_ID() == schdId.longValue();
        }

        private Map<Long, List<O>> separateTargetsBySchd(List<? extends O> targets) {
            return targets.stream().collect(Collectors.groupingBy(new Function<O, Long>(){

                @Override
                public Long apply(O targetTemp) {
                    return ((TmsTargetTemp)targetTemp).getSCHD_ID();
                }
            }));
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void insertToTargetTemp(List nextTargets, TargetTempBySchd targetTempBySchd) throws Exception {
            try {
                long send_id;
                if (this.isAbTest && this.isChangeABgroup(send_id = targetTempBySchd.getTmsSchdInfo().getSEND_ID())) {
                    this.nextChangeABTestTmsSendInfo(send_id);
                }
                this.isPushChannelThenIndexing(nextTargets, targetTempBySchd);
                this.writeTargetTemp(nextTargets);
            }
            catch (Exception e) {
                log.error("insert to TMS_TARGET_TEMP error schd_id=[{}]", (Object)targetTempBySchd.getTmsSchdInfo().getSCHD_ID(), (Object)e);
                throw e;
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void isPushChannelThenIndexing(List nextTargets, TargetTempBySchd targetTempBySchd) {
            if (this.isPushChannel) {
                long fId = ((TmsTargetTemp)nextTargets.get(0)).getTARGET_TEMP_ID();
                long eId = ((TmsTargetTemp)nextTargets.get(nextTargets.size() - 1)).getTARGET_TEMP_ID();
                targetTempBySchd.setFirstTargetTempId(fId);
                targetTempBySchd.setLastTargetTempId(eId);
            }
        }

        private void isCancelThenStop() throws Exception {
            if (this.isCancel(this.targetInfo.getSEND_ID())) {
                log.warn("batch targeting is canceled. send_id[{}] ", (Object)this.targetInfo.getSEND_ID());
                this.isCancel = true;
                this.readDataSourceClose();
                this.stepExecution.setStatus(BatchStatus.STOPPED);
                throw new Exception("UserCancleException");
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateEndStatusOfSchdInfo(TargetTempBySchd nowTargetTempBySchd) {
            String schdJobStatus = "";
            try {
                schdJobStatus = this.isRealtime ? "10" : (this.isDelaySending ? "22" : "40");
                schdJobStatus = this.isLastABTest ? "00" : schdJobStatus;
                TmsSchdInfo tmsSchdInfo = nowTargetTempBySchd.getTmsSchdInfo();
                TargetCounter counter = nowTargetTempBySchd.getTargetCounter();
                String errCode = nowTargetTempBySchd.getErrCode();
                String last_schd_job_status = "0000".equals(errCode) ? schdJobStatus : "42";
                int count = TmsLocalItemWriter.this.sendInfoDao.updateSchdInfoTargetCount(tmsSchdInfo.getSCHD_ID(), last_schd_job_status, counter.getTargetCountOfSchdInfo().get());
                if (count != 1) {
                    log.warn("is not updating batch targeting. target count={} update[schd_id.job_status={}] schd_id=[{}] / send_id=[{}]", new Object[]{counter.getTargetCountOfSchdInfo(), last_schd_job_status, tmsSchdInfo.getSCHD_ID(), this.tmsSendInfo.getSEND_ID()});
                }
            }
            catch (Exception e) {
                log.error("error update schd job_status[{}] error code=[{}], schd_id=[{}]/send_id=[{}]", new Object[]{schdJobStatus, nowTargetTempBySchd.getErrCode(), nowTargetTempBySchd.getTmsSchdInfo().getSCHD_ID(), this.tmsSendInfo.getSEND_ID(), e});
            }
            finally {
                nowTargetTempBySchd.getTargetCounter().clearOfSchdInfo();
            }
        }

        private void writeTargetTemp(List<? extends O> targets) throws Exception {
            this.nowTargetTempBySchd.getTargetCounter().setNowTargetCount(targets.size());
            if (this.useUpdateQuery) {
                for (Map<Integer, String> updates : this.updateQuerys) {
                    Integer dbId = (Integer)updates.keySet().toArray()[0];
                    if (this.isUpdatedError) {
                        this.process(this.getUpdateJdbcTemplate(dbId), updates.get(dbId), this.successTargetTemp, false);
                        continue;
                    }
                    this.process(this.getUpdateJdbcTemplate(dbId), updates.get(dbId), targets, false);
                }
            }
            if (this.isUpdatedError) {
                this.isUpdatedError = false;
                log.info("Only [{}] of the [{}] requested were stored to tms_target_temp in send_id[{}]", new Object[]{this.successTargetTemp.size(), targets.size(), this.tmsSendInfo.getSEND_ID()});
                this.process(this.insertJdbcTemplate, "batchInsertTmsTargetTemp", this.successTargetTemp, true);
            } else {
                this.process(this.insertJdbcTemplate, "batchInsertTmsTargetTemp", targets, true);
            }
        }

        private TmsJdbcTemplate getUpdateJdbcTemplate(Integer dbId) {
            return this.updateJdbcTemplates.get(dbId);
        }

        private boolean isChangeABgroup(long sendId) {
            return this.tmsSendInfo.getSEND_ID() != sendId;
        }

        private void transQueue(String message) throws InterruptedException {
            TmsLocalItemWriter.this.mqSender.send(this.getQueueName(), message);
            log.info("sent MQ={} / msg={}", (Object)this.getQueueName(), (Object)message);
        }

        private String getQueueName() {
            return this.isRealtime ? AUTO_MAPPER_QUEUE : MASS_MAPPER_QUEUE;
        }

        private String toMapperMessage(long send_ID, long schd_ID, long target_SEQ_MAX) {
            return send_ID + ":" + schd_ID + ":" + target_SEQ_MAX;
        }

        private void nextChangeABTestTmsSendInfo(long nextSendId) throws Exception {
            log.info("A/B Test changed org send_id={} next send_id={}", (Object)this.tmsSendInfo.getSEND_ID(), (Object)nextSendId);
            this.tmsSendInfo = TmsLocalItemWriter.this.sendInfoDao.selectSendInfoEmptyTargetId(nextSendId);
            this.tmsSendInfo.setTARGET_ID(this.targetInfo.getTARGET_ID());
            this.tmsSendInfo.setTARGET_TYPE(this.targetInfo.getTARGET_TYPE());
            this.sendIds.add(nextSendId);
            this.isLastABTest = this.ABMainSendId == nextSendId;
        }

        private boolean necessaryGroupIncrement() {
            boolean isNextGroup = this.isNextGroup();
            if (this.isNextGroup()) {
                this.stepExecution.getExecutionContext().put("IS_NEXT_GROUP", (Object)false);
            }
            return isNextGroup;
        }

        private boolean isNextGroup() {
            return (Boolean)this.stepExecution.getExecutionContext().get("IS_NEXT_GROUP");
        }

        private void process(TmsJdbcTemplate jdbcTemplate, String query, List<? extends O> targets, boolean IS_INSERT) throws Exception {
            TargetCounter counter = this.nowTargetTempBySchd.getTargetCounter();
            TmsSchdInfo tmsSchdInfo = this.nowTargetTempBySchd.getTmsSchdInfo();
            if (IS_INSERT) {
                if (this.isMove) {
                    counter.getTargetSeq().getAndIncrement();
                    jdbcTemplate.updateBatchDistribute(this.ifLocalTempInsertQuery(null), targets);
                    this.filteringErrorData(jdbcTemplate, targets, counter, tmsSchdInfo.getSCHD_ID());
                }
                if (this.isDelaySending || this.isLastABTest) {
                    return;
                }
                if (this.isPushChannel) {
                    List<TmsPuTargetTemp> tmsPuTargetTemps = TmsLocalItemWriter.this.sendInfoDao.selectPushTargetInfo(this.nowTargetTempBySchd.getFirstTargetTempId(), this.nowTargetTempBySchd.getLastTargetTempId(), this.targetInfo.getAPP_GRP_ID(), tmsSchdInfo.getSEND_ID(), tmsSchdInfo.getSCHD_ID(), tmsSchdInfo.getTARGET_ID(), tmsSchdInfo.getWORKDAY());
                    this.uploadTlist(tmsPuTargetTemps, counter, tmsSchdInfo.getSCHD_ID());
                } else {
                    this.uploadTlist(targets, counter, tmsSchdInfo.getSCHD_ID());
                }
            } else {
                int orgTargetSize = targets.size();
                jdbcTemplate.updateBatchDistribute(query, this.transMap(targets));
                List errorDatas = jdbcTemplate.getErrorDatas();
                if (ObjectUtils.isEmpty((Object)errorDatas)) {
                    log.info("update try count = [{}] in total count[{}] send_id[{}]", new Object[]{targets.size(), counter.getTotalTargetCountBySendInfo().get(), this.tmsSendInfo.getSEND_ID()});
                } else {
                    String queryType = "update";
                    this.isUpdatedError = true;
                    int deletedCount = this.removeTarget(targets, errorDatas, queryType);
                    this.validationErrorCount(orgTargetSize, this.successTargetTemp.size(), errorDatas.size(), deletedCount);
                    log.error("DS0103|update error removed({}). success[{}]/[{}] target of send_id[{}]", new Object[]{deletedCount, this.successTargetTemp.size(), orgTargetSize, this.targetInfo.getSEND_ID()});
                    jdbcTemplate.errClear();
                }
            }
        }

        private boolean filteringErrorData(TmsJdbcTemplate jdbcTemplate, List<? extends O> targets, TargetCounter counter, long schd_id) {
            List errorDatas = jdbcTemplate.getErrorDatas();
            boolean isInsertError = !ObjectUtils.isEmpty((Object)errorDatas);
            this.insertedCountToTempTable = targets.size() - (isInsertError ? errorDatas.size() : 0);
            counter.setSuccessCumulativeCountDbBySchdInfo(this.insertedCountToTempTable);
            log.info("DB inserted/try count = [{}/{}] in total count[{}] schd_id[{}]/send_id[{}]", new Object[]{this.insertedCountToTempTable, targets.size(), counter.getTotalTargetCountBySendInfo().get(), schd_id, this.tmsSendInfo.getSEND_ID()});
            if (!ObjectUtils.isEmpty(this.pureTargetRemoved)) {
                this.pureTargetRemoved.clear();
            }
            jdbcTemplate.errClear();
            return isInsertError;
        }

        private void uploadTlist(List<? extends O> targets, TargetCounter counter, long schd_id) throws Exception {
            try {
                this.basicTlistVo.setTarget_seq(counter.getTargetSeq().get());
                String key = TmsLocalItemWriter.this.tmsRedisTlistProvider.uploadTlistVos(this.basicPinfoVo, this.basicTlistVo, targets);
                int errSize = TmsLocalItemWriter.this.tmsRedisTlistProvider.getErrorList().size();
                counter.setFailedIntoRedisBySchdInfo(errSize);
                log.info("RD tlist[{}] inserted/try count = [{}/{}] in total count[{}] key= schd_id[{}]/send_id[{}]", new Object[]{key, targets.size() - errSize, targets.size(), counter.getTotalTargetCountBySendInfo().get(), schd_id, this.tmsSendInfo.getSEND_ID()});
                this.uploadPinfo();
                this.transQueue(this.toMapperMessage(this.tmsSendInfo.getSEND_ID(), schd_id, this.basicPinfoVo.getTARGET_SEQ_MAX()));
            }
            catch (AllTlistUploadException ae) {
                this.stepExecution.addFailureException((Throwable)ae);
                throw ae;
            }
            catch (Exception e) {
                log.error("failed upload tlist. target count[{}] this send info[id={}] target error.", new Object[]{targets.size(), this.tmsSendInfo.getSEND_ID(), e});
                this.stepExecution.addFailureException((Throwable)e);
                throw e;
            }
        }

        private List<? extends Object> transMap(List<? extends O> targets) {
            ArrayList<Map> tmsTargetTempMap = new ArrayList<Map>();
            for (Object tmsTargetTemp : targets) {
                tmsTargetTempMap.add(JsonUtil.getMapFromJson((String)((TmsTargetTemp)tmsTargetTemp).getTMS_ETC()));
            }
            return tmsTargetTempMap;
        }

        private void validationErrorCount(int orgTargetSize, int realTargetSize, int errorDataSize, int deletedCount) throws Exception {
            if (realTargetSize != orgTargetSize - errorDataSize || errorDataSize != deletedCount) {
                log.error("failed validation. update try target size[{}] / real update size[{}] / error size[{}] / deleted size[{}]", new Object[]{orgTargetSize, realTargetSize, errorDataSize, deletedCount});
                this.readDataSourceClose();
                this.stepExecution.setStatus(BatchStatus.STOPPED);
                throw new Exception("update error count validation check error");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int removeTarget(List<? extends O> targets, List<TmsJdbcError> errorDatas, String queryType) throws Exception {
            Iterator iter;
            int orgTargetSize = targets.size();
            int removedCount = 0;
            if (targets instanceof CopyOnWriteArrayList) {
                iter = targets.iterator();
            } else {
                if (!ObjectUtils.isEmpty(this.successTargetTemp)) {
                    this.successTargetTemp.clear();
                }
                this.successTargetTemp = new CopyOnWriteArrayList(targets);
                iter = this.successTargetTemp.iterator();
            }
            List list = this.successTargetTemp;
            synchronized (list) {
                while (iter.hasNext()) {
                    TmsTargetTemp tmsTargetTemp = (TmsTargetTemp)iter.next();
                    for (TmsJdbcError errorInfo : errorDatas) {
                        try {
                            Map error = errorInfo.getMappingInfo();
                            if (!error.containsKey("TMS_M_ID")) {
                                throw new Exception();
                            }
                            String tmsMid = error.get("TMS_M_ID").toString();
                            if (!tmsTargetTemp.getTMS_M_ID().equals(tmsMid)) continue;
                            ++removedCount;
                            this.successTargetTemp.remove(tmsTargetTemp);
                        }
                        catch (Exception e) {
                            log.error("DS014|{} target-errorinfo[{}] removing error ", new Object[]{queryType, errorInfo.getMappingInfo(), e});
                            throw e;
                        }
                    }
                }
            }
            log.info("org targets size[{}], real targets size[{}], remove target count[{}]", new Object[]{orgTargetSize, this.successTargetTemp.size(), removedCount});
            return removedCount;
        }

        private String ifLocalTempInsertQuery(String query) {
            if (StringUtils.isEmpty((String)query)) {
                return ((StringBuilder)new SQL(){
                    {
                        this.INSERT_INTO("TMS_TARGET_TEMP");
                        this.VALUES("TARGET_TEMP_ID", "#{TARGET_TEMP_ID}");
                        this.VALUES("GRP_SEQ", "#{GRP_SEQ}");
                        this.VALUES("WORKDAY", "#{WORKDAY}");
                        this.VALUES("SEND_ID", "#{SEND_ID}");
                        this.VALUES("SCHD_ID", "#{SCHD_ID}");
                        this.VALUES("TARGET_ID", "#{TARGET_ID}");
                        this.VALUES("TMS_M_ID", "#{TMS_M_ID}");
                        this.VALUES("TMS_M_NAME", "#{TMS_M_NAME}");
                        this.VALUES("TMS_M_EMAIL", "#{TMS_M_EMAIL}");
                        this.VALUES("TMS_M_PHONE", "#{TMS_M_PHONE}");
                        this.VALUES("TMS_M_TOKEN", "#{TMS_M_TOKEN}");
                        this.VALUES("DEVICE_ID", "#{DEVICE_ID}");
                        this.VALUES("DATA01", "#{DATA01}");
                        this.VALUES("DATA02", "#{DATA02}");
                        this.VALUES("DATA03", "#{DATA03}");
                        this.VALUES("ERR_CODE", "#{ErrCode}");
                        this.VALUES("ERR_MSG", "#{ErrMsg}");
                        this.VALUES("ETC", "#{TMS_ETC}");
                    }
                }.usingAppender((Appendable)new StringBuilder())).toString();
            }
            return query;
        }

        private boolean isCancel(long sendId) {
            TmsSendInfo sendInfo = TmsLocalItemWriter.this.sendInfoDao.selectOnlySendInfo(sendId);
            return ObjectUtils.isEmpty((Object)sendInfo) || "31".equals(sendInfo.getJOB_STATUS()) || "32".equals(sendInfo.getJOB_STATUS()) || "42".equals(sendInfo.getJOB_STATUS());
        }

        private boolean thisJobException() {
            List exceptions = this.stepExecution.getFailureExceptions();
            return !ObjectUtils.isEmpty((Object)exceptions);
        }

        @BeforeStep
        public void beforeStep(StepExecution stepExecution) throws Exception {
            this.stepExecution = stepExecution;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @AfterStep
        public ExitStatus afterStep(StepExecution stepExecution) {
            String jobStatusOfSendInfo = this.isRealtime ? "30" : "40";
            try {
                log.info("WRITER afterStep job id :{}, SEND_ID : {}", (Object)stepExecution.getJobExecution().getJobId(), (Object)this.targetInfo.getSEND_ID());
                if (this.isCancel) {
                    if (!this.isAbTest) {
                        log.warn("canceled[send_id={}] last create schedule.", (Object)this.targetInfo.getSEND_ID());
                    }
                    jobStatusOfSendInfo = "31";
                    ExitStatus exitStatus = ExitStatus.FAILED;
                    return exitStatus;
                }
                if (this.thisJobException()) {
                    jobStatusOfSendInfo = "31";
                    ExitStatus exitStatus = ExitStatus.FAILED;
                    return exitStatus;
                }
                if (stepExecution.getStatus() == BatchStatus.STOPPED) {
                    jobStatusOfSendInfo = "31";
                    ExitStatus exitStatus = ExitStatus.FAILED;
                    return exitStatus;
                }
                this.endJobBySchd((TargetTempBySchd)this.nowTargetTempBySchd);
                ExitStatus exitStatus = ExitStatus.COMPLETED;
                return exitStatus;
            }
            catch (Exception e) {
                log.error("DS015|this job[{}] send_id[{}] after step error so update 31", new Object[]{this.dbTargetInfo.getJOB_NAME(), this.targetInfo.getSEND_ID(), e});
                jobStatusOfSendInfo = "31";
                ExitStatus exitStatus = ExitStatus.FAILED;
                return exitStatus;
            }
            finally {
                try {
                    this.targetInfo.setNOW_TARGETING(false);
                    this.readDataSourceClose();
                    if (this.isCancel) {
                        if (this.isAbTest) {
                            log.info("this A/B target cancel completed. send_id[{}]", this.sendIds);
                        } else {
                            log.info("this target cancel completed. send_id[{}]", (Object)this.targetInfo.getSEND_ID());
                        }
                    }
                    if (this.isAbTest && !this.isSecondTarget) {
                        log.info("A/B Test update SEND_INFO.JOB_STATUS={} sendids[ids={}]", (Object)jobStatusOfSendInfo, this.sendIds);
                        TmsLocalItemWriter.this.sendInfoDao.updateSendInfosJobStatus(this.sendIds, jobStatusOfSendInfo);
                    } else {
                        TmsLocalItemWriter.this.sendInfoDao.updateSendInfoJobStatus(this.targetInfo.getSEND_ID(), jobStatusOfSendInfo);
                    }
                }
                catch (Exception e2) {
                    log.error("DS016|finally send_id[{}] target move error", (Object)this.targetInfo.getSEND_ID(), (Object)e2);
                }
                finally {
                    this.jdbcClose();
                }
            }
        }

        private TmsBatchStepExecution createBatchStepExecution() {
            TmsBatchStepExecution batchStepExection = new TmsBatchStepExecution();
            batchStepExection.setRETRY_COUNT(1);
            batchStepExection.setWRITE_COUNT(this.stepExecution.getWriteCount());
            batchStepExection.setJOB_EXECUTION_ID(this.stepExecution.getJobExecutionId());
            return batchStepExection;
        }

        private boolean isSessionCloseException() {
            List exceptions = this.stepExecution.getFailureExceptions();
            for (Throwable exception : exceptions) {
                if (!(exception instanceof UncategorizedSQLException)) continue;
                Exception ex = (Exception)exception;
                log.error(">>>>> EXCEPTION MSG >>>> [{}] ", (Object)ex.toString());
                if (Constants.TargetType.FILE.name().equals(this.targetInfo.getTARGET_TYPE())) continue;
                return true;
            }
            return false;
        }

        private void readDataSourceClose() {
            try {
                if (this.readDataSource != null) {
                    if (this.readDataSource instanceof SingleConnectionDataSource) {
                        ((SingleConnectionDataSource)this.readDataSource).destroy();
                    } else if (this.readDataSource instanceof DriverManagerDataSource) {
                        this.readDataSource.getConnection().close();
                    } else {
                        ((HikariDataSource)this.readDataSource).close();
                    }
                }
            }
            catch (Exception e) {
                log.error("DS017|error close reader datasource.. retry", (Throwable)e);
                try {
                    if (this.readDataSource instanceof SingleConnectionDataSource) {
                        ((SingleConnectionDataSource)this.readDataSource).destroy();
                    } else if (this.readDataSource instanceof DriverManagerDataSource) {
                        this.readDataSource.getConnection().close();
                    } else {
                        ((HikariDataSource)this.readDataSource).close();
                    }
                }
                catch (Exception e2) {
                    log.error("DS018|retry error close reader datasource. check database connection number", (Throwable)e);
                }
            }
        }

        private void jdbcClose() {
            try {
                if (!ObjectUtils.isEmpty(this.updateJdbcTemplates)) {
                    ArrayList<TmsJdbcTemplate> tmsJdbcTemplates = new ArrayList<TmsJdbcTemplate>(this.updateJdbcTemplates.values());
                    for (TmsJdbcTemplate jdbcTemplate : tmsJdbcTemplates) {
                        try {
                            jdbcTemplate.destroy();
                        }
                        catch (Exception e) {
                            log.error("DS019|this jdbcTemplate don't close", (Object)jdbcTemplate);
                        }
                    }
                }
                if (this.insertJdbcTemplate != null) {
                    this.insertJdbcTemplate.destroy();
                }
            }
            catch (Exception e) {
                log.error("DS0110|this job[{}] send_id[{}] failed jdbc connection close", new Object[]{this.dbTargetInfo.getJOB_NAME(), this.targetInfo.getSEND_ID(), e});
            }
        }

        @OnWriteError
        public void onWriteError(Exception e, List<? extends O> targets) {
            log.warn("onWriteError, size : {}, jobExecutionId : {} , SEND_ID : {}, exception:{}", new Object[]{targets.size(), this.stepExecution.getJobExecution().getJobId(), this.targetInfo.getSEND_ID(), e});
        }

        private void multiUpdateBugTest(List<? extends O> targets) {
            int count = 1;
            if (ObjectUtils.isEmpty(targets)) {
                return;
            }
            for (Object target : targets) {
                if (count % 100 == 0) {
                    ((TmsEmTargetTemp)target).setTMS_M_EMAIL("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------");
                }
                ++count;
            }
        }

        private class TargetTempBySchd {
            private TargetCounter targetCounter;
            private TmsSchdInfo tmsSchdInfo;
            private String errCode = "0000";
            private String errMsg;
            private long firstTargetTempId;
            private long lastTargetTempId;

            private TargetTempBySchd(long schdId) {
                this.tmsSchdInfo = TmsLocalItemWriter.this.sendInfoDao.selectSchdInfo(schdId);
                this.targetCounter = new TargetCounter();
            }

            private void setFirstTargetTempId(long fid) {
                this.firstTargetTempId = fid;
            }

            private void setLastTargetTempId(long fid) {
                this.lastTargetTempId = fid;
            }

            public TargetCounter getTargetCounter() {
                return this.targetCounter;
            }

            public TmsSchdInfo getTmsSchdInfo() {
                return this.tmsSchdInfo;
            }

            public String getErrCode() {
                return this.errCode;
            }

            public String getErrMsg() {
                return this.errMsg;
            }

            public long getFirstTargetTempId() {
                return this.firstTargetTempId;
            }

            public long getLastTargetTempId() {
                return this.lastTargetTempId;
            }

            public void setTargetCounter(TargetCounter targetCounter) {
                this.targetCounter = targetCounter;
            }

            public void setTmsSchdInfo(TmsSchdInfo tmsSchdInfo) {
                this.tmsSchdInfo = tmsSchdInfo;
            }

            public void setErrCode(String errCode) {
                this.errCode = errCode;
            }

            public void setErrMsg(String errMsg) {
                this.errMsg = errMsg;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TargetTempBySchd)) {
                    return false;
                }
                TargetTempBySchd other = (TargetTempBySchd)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TargetCounter this$targetCounter = this.getTargetCounter();
                TargetCounter other$targetCounter = other.getTargetCounter();
                if (this$targetCounter == null ? other$targetCounter != null : !((Object)this$targetCounter).equals(other$targetCounter)) {
                    return false;
                }
                TmsSchdInfo this$tmsSchdInfo = this.getTmsSchdInfo();
                TmsSchdInfo other$tmsSchdInfo = other.getTmsSchdInfo();
                if (this$tmsSchdInfo == null ? other$tmsSchdInfo != null : !((Object)this$tmsSchdInfo).equals(other$tmsSchdInfo)) {
                    return false;
                }
                String this$errCode = this.getErrCode();
                String other$errCode = other.getErrCode();
                if (this$errCode == null ? other$errCode != null : !this$errCode.equals(other$errCode)) {
                    return false;
                }
                String this$errMsg = this.getErrMsg();
                String other$errMsg = other.getErrMsg();
                if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
                    return false;
                }
                if (this.getFirstTargetTempId() != other.getFirstTargetTempId()) {
                    return false;
                }
                return this.getLastTargetTempId() == other.getLastTargetTempId();
            }

            protected boolean canEqual(Object other) {
                return other instanceof TargetTempBySchd;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TargetCounter $targetCounter = this.getTargetCounter();
                result = result * 59 + ($targetCounter == null ? 43 : ((Object)$targetCounter).hashCode());
                TmsSchdInfo $tmsSchdInfo = this.getTmsSchdInfo();
                result = result * 59 + ($tmsSchdInfo == null ? 43 : ((Object)$tmsSchdInfo).hashCode());
                String $errCode = this.getErrCode();
                result = result * 59 + ($errCode == null ? 43 : $errCode.hashCode());
                String $errMsg = this.getErrMsg();
                result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
                long $firstTargetTempId = this.getFirstTargetTempId();
                result = result * 59 + (int)($firstTargetTempId >>> 32 ^ $firstTargetTempId);
                long $lastTargetTempId = this.getLastTargetTempId();
                result = result * 59 + (int)($lastTargetTempId >>> 32 ^ $lastTargetTempId);
                return result;
            }

            public String toString() {
                return "TmsLocalItemWriter.TargetingItemWriter.TargetTempBySchd(targetCounter=" + this.getTargetCounter() + ", tmsSchdInfo=" + this.getTmsSchdInfo() + ", errCode=" + this.getErrCode() + ", errMsg=" + this.getErrMsg() + ", firstTargetTempId=" + this.getFirstTargetTempId() + ", lastTargetTempId=" + this.getLastTargetTempId() + ")";
            }
        }
    }
}

