/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch;

import com.humuson.tms.trans.module.batch.BatchFileTargetInfo;
import com.humuson.tms.trans.module.batch.sec.TmsBatchDecryptor;
import com.humuson.tms.trans.module.batch.sec.TmsBatchEncryptor;
import com.humuson.tms.util.charset.FileControlUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.DelimitedLineTokenizer;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BindException;

@Component
public class TmsFileItemReader<T> {
    private static final Logger log = LoggerFactory.getLogger(TmsFileItemReader.class);
    @Autowired(required=false)
    TmsBatchEncryptor tmsBatchEncryptor;
    @Autowired(required=false)
    TmsBatchDecryptor tmsBatchDecryptor;
    @Value(value="${tms.security.encrypt.enable}")
    public boolean isEncrypt;
    protected boolean isDecrypt;

    @Bean
    @StepScope
    public ItemReader<HashMap<String, T>> createItemFileReader(BatchFileTargetInfo targetInfo) throws Exception {
        this.isEncrypt = targetInfo.isENCRYPT();
        this.isDecrypt = !ObjectUtils.isEmpty((Object)this.tmsBatchDecryptor);
        String fullPathFileName = targetInfo.getTARGET_FILE_NAME();
        String delimiter = "|";
        if (delimiter.equalsIgnoreCase("|")) {
            delimiter = "\\|";
        }
        Object[] fieldSetList = String.valueOf(targetInfo.getMAPPING_HEADER()).split(delimiter);
        String charset = this.getFileCharset(fullPathFileName);
        delimiter = targetInfo.getTARGET_FILE_DELIM();
        boolean firstSkip = targetInfo.getTARGET_FILE_HEAD_FLAG().equalsIgnoreCase("Y");
        String targetFileIdx = targetInfo.getTARGET_FILE_IDX();
        DelimitedLineTokenizer delimitedLineTokenizer = new DelimitedLineTokenizer(delimiter);
        delimitedLineTokenizer.setNames((String[])fieldSetList);
        delimitedLineTokenizer.setStrict(false);
        FileTargetDataRowMapper fileTargetDataRowMapper = new FileTargetDataRowMapper();
        fileTargetDataRowMapper.setTargetFileIdx(targetFileIdx);
        DefaultLineMapper defaultLineMapper = new DefaultLineMapper();
        defaultLineMapper.setLineTokenizer((LineTokenizer)delimitedLineTokenizer);
        defaultLineMapper.setFieldSetMapper((FieldSetMapper)fileTargetDataRowMapper);
        FlatFileItemReader flatFileItemReader = new FlatFileItemReader();
        if (firstSkip) {
            flatFileItemReader.setLinesToSkip(1);
        }
        flatFileItemReader.setResource((Resource)new FileSystemResource(fullPathFileName));
        flatFileItemReader.setEncoding(charset);
        flatFileItemReader.setLineMapper((LineMapper)defaultLineMapper);
        flatFileItemReader.setName(targetInfo.getJOB_NAME());
        if (log.isDebugEnabled()) {
            log.debug("BATCH FILE READER JOB[{}]: charset[{}], delimiter[{}], first-skip[{}], targetIdx[{}], fields[{}]", new Object[]{targetInfo.getJOB_NAME(), charset, delimiter, firstSkip, targetFileIdx, Arrays.toString(fieldSetList)});
        }
        return flatFileItemReader;
    }

    private String getFileCharset(String fullPathFileName) throws Exception {
        String charset = FileControlUtil.charsetFile((String)fullPathFileName);
        if (charset == null || charset.isEmpty()) {
            charset = Charset.defaultCharset().name();
        }
        return charset;
    }

    class FileTargetDataRowMapper
    implements FieldSetMapper<HashMap<String, Object>> {
        private int fieldSetCount = 0;
        private List<Integer> targetFileIdxList = new ArrayList<Integer>();

        FileTargetDataRowMapper() {
        }

        public HashMap<String, Object> mapFieldSet(FieldSet fieldSet) throws BindException {
            if (this.fieldSetCount == 0) {
                this.fieldSetCount = fieldSet.getFieldCount();
            }
            if (log.isDebugEnabled()) {
                log.debug("fieldSet names:{}, values:{}", (Object)fieldSet.getNames().length, (Object)fieldSet.getValues().length);
            }
            String[] names = fieldSet.getNames();
            String[] values = fieldSet.getValues();
            HashMap<String, Object> target = new HashMap<String, Object>();
            try {
                int size = this.targetFileIdxList.size();
                for (int i = 0; i < size; ++i) {
                    if (this.targetFileIdxList.get(i) < 0) continue;
                    String key = names[i].trim();
                    if (TmsFileItemReader.this.isDecrypt) {
                        target.put(key, TmsFileItemReader.this.tmsBatchDecryptor.decrypt(key, values[this.targetFileIdxList.get(i)]));
                    }
                    if (TmsFileItemReader.this.isEncrypt) {
                        target.put(key, TmsFileItemReader.this.tmsBatchEncryptor.encrypt(key, values[this.targetFileIdxList.get(i)]));
                        continue;
                    }
                    target.put(key, values[this.targetFileIdxList.get(i)]);
                }
            }
            catch (Exception e) {
                log.error("target data bind error [{}]", (Object)fieldSet.getProperties().toString());
                throw new BindException((Object)this, "fieldSetBind Error");
            }
            return target;
        }

        public void setTargetFileIdx(String targetFileIdx) {
            for (String idx : targetFileIdx.split("[|]")) {
                try {
                    this.targetFileIdxList.add(Integer.parseInt(idx));
                }
                catch (Exception e) {
                    log.error("idx parse error [targetFileIdx:{}, idx:{}]", (Object)targetFileIdx, (Object)idx);
                    this.targetFileIdxList.add(-1);
                }
            }
        }
    }
}

