/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch;

import com.humuson.tms.config.Constants;
import com.humuson.tms.trans.module.batch.BatchDbTargetInfo;
import com.humuson.tms.trans.module.batch.BatchTargetInfo;
import com.humuson.tms.trans.module.batch.BatchTargetInfomation;
import com.humuson.tms.trans.repository.model.TmsABInfo;
import com.humuson.tms.util.date.DateUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;

public class TmsBatchTargetInfo
implements BatchTargetInfomation {
    private final BatchTargetInfo READ_TARGET_INFO;
    private BatchDbTargetInfo WRITE_TARGET_INFO;
    private final String WORKDAY;
    private long SEND_ID;
    private long SCHD_ID;
    private long TARGET_ID;
    private int GROUP_DIVISION_UNIT;
    private int DIVIDE_MINUTE;
    private boolean PUSH_CHANNEL = false;
    private String ENCRYPT_KEY;
    private boolean ENCRYPT = false;
    private String CHANNEL_TYPE;
    private String TARGET_TYPE;
    private String TRIGGER_METHOD;
    private int APP_GRP_ID;
    private boolean AB_YN;
    private long TARGET_SEQ_COUNT;
    private boolean NOW_TARGETING = false;
    private boolean MOVE = true;
    private boolean DELAY = false;
    private List<TmsABInfo> TMS_AB_TARGETS = new ArrayList<TmsABInfo>();

    public TmsBatchTargetInfo(BatchTargetInfo readTargetInfo) {
        this.READ_TARGET_INFO = readTargetInfo;
        if (readTargetInfo.isDB_TARGET()) {
            this.TARGET_TYPE = Constants.TargetType.DB.name();
        } else {
            this.TARGET_TYPE = Constants.TargetType.FILE.name();
            this.WRITE_TARGET_INFO = new BatchDbTargetInfo();
            this.WRITE_TARGET_INFO.setDB_ID(-1);
        }
        this.WORKDAY = DateUtil.getWorkday();
    }

    public TmsBatchTargetInfo(BatchTargetInfo readTargetInfo, BatchDbTargetInfo writeTargetInfo) {
        this.READ_TARGET_INFO = readTargetInfo;
        this.TARGET_TYPE = readTargetInfo.isDB_TARGET() ? Constants.TargetType.DB.name() : Constants.TargetType.FILE.name();
        this.WRITE_TARGET_INFO = writeTargetInfo;
        this.WORKDAY = DateUtil.getWorkday();
    }

    public void setTmsABInfo(TmsABInfo tmsABInfo) {
        this.TMS_AB_TARGETS.add(tmsABInfo);
    }

    @Override
    public String jobName() {
        return null;
    }

    @Override
    public int chunkUnit() {
        return 0;
    }

    @Override
    public long groupDivisionUnit() {
        return 0L;
    }

    @Override
    public long targetCount() {
        return 0L;
    }

    @Override
    public boolean isFromDB() {
        return false;
    }

    public ItemReader reader() {
        return null;
    }

    public ItemWriter writer() {
        return null;
    }

    public BatchTargetInfo getREAD_TARGET_INFO() {
        return this.READ_TARGET_INFO;
    }

    public BatchDbTargetInfo getWRITE_TARGET_INFO() {
        return this.WRITE_TARGET_INFO;
    }

    public String getWORKDAY() {
        return this.WORKDAY;
    }

    public long getSEND_ID() {
        return this.SEND_ID;
    }

    public long getSCHD_ID() {
        return this.SCHD_ID;
    }

    public long getTARGET_ID() {
        return this.TARGET_ID;
    }

    public int getGROUP_DIVISION_UNIT() {
        return this.GROUP_DIVISION_UNIT;
    }

    public int getDIVIDE_MINUTE() {
        return this.DIVIDE_MINUTE;
    }

    public boolean isPUSH_CHANNEL() {
        return this.PUSH_CHANNEL;
    }

    public String getENCRYPT_KEY() {
        return this.ENCRYPT_KEY;
    }

    public boolean isENCRYPT() {
        return this.ENCRYPT;
    }

    public String getCHANNEL_TYPE() {
        return this.CHANNEL_TYPE;
    }

    public String getTARGET_TYPE() {
        return this.TARGET_TYPE;
    }

    public String getTRIGGER_METHOD() {
        return this.TRIGGER_METHOD;
    }

    public int getAPP_GRP_ID() {
        return this.APP_GRP_ID;
    }

    public boolean isAB_YN() {
        return this.AB_YN;
    }

    public long getTARGET_SEQ_COUNT() {
        return this.TARGET_SEQ_COUNT;
    }

    public boolean isNOW_TARGETING() {
        return this.NOW_TARGETING;
    }

    public boolean isMOVE() {
        return this.MOVE;
    }

    public boolean isDELAY() {
        return this.DELAY;
    }

    public List<TmsABInfo> getTMS_AB_TARGETS() {
        return this.TMS_AB_TARGETS;
    }

    public void setWRITE_TARGET_INFO(BatchDbTargetInfo WRITE_TARGET_INFO) {
        this.WRITE_TARGET_INFO = WRITE_TARGET_INFO;
    }

    public void setSEND_ID(long SEND_ID) {
        this.SEND_ID = SEND_ID;
    }

    public void setSCHD_ID(long SCHD_ID) {
        this.SCHD_ID = SCHD_ID;
    }

    public void setTARGET_ID(long TARGET_ID) {
        this.TARGET_ID = TARGET_ID;
    }

    public void setGROUP_DIVISION_UNIT(int GROUP_DIVISION_UNIT) {
        this.GROUP_DIVISION_UNIT = GROUP_DIVISION_UNIT;
    }

    public void setDIVIDE_MINUTE(int DIVIDE_MINUTE) {
        this.DIVIDE_MINUTE = DIVIDE_MINUTE;
    }

    public void setPUSH_CHANNEL(boolean PUSH_CHANNEL) {
        this.PUSH_CHANNEL = PUSH_CHANNEL;
    }

    public void setENCRYPT_KEY(String ENCRYPT_KEY) {
        this.ENCRYPT_KEY = ENCRYPT_KEY;
    }

    public void setENCRYPT(boolean ENCRYPT) {
        this.ENCRYPT = ENCRYPT;
    }

    public void setCHANNEL_TYPE(String CHANNEL_TYPE) {
        this.CHANNEL_TYPE = CHANNEL_TYPE;
    }

    public void setTARGET_TYPE(String TARGET_TYPE) {
        this.TARGET_TYPE = TARGET_TYPE;
    }

    public void setTRIGGER_METHOD(String TRIGGER_METHOD) {
        this.TRIGGER_METHOD = TRIGGER_METHOD;
    }

    public void setAPP_GRP_ID(int APP_GRP_ID) {
        this.APP_GRP_ID = APP_GRP_ID;
    }

    public void setAB_YN(boolean AB_YN) {
        this.AB_YN = AB_YN;
    }

    public void setTARGET_SEQ_COUNT(long TARGET_SEQ_COUNT) {
        this.TARGET_SEQ_COUNT = TARGET_SEQ_COUNT;
    }

    public void setNOW_TARGETING(boolean NOW_TARGETING) {
        this.NOW_TARGETING = NOW_TARGETING;
    }

    public void setMOVE(boolean MOVE) {
        this.MOVE = MOVE;
    }

    public void setDELAY(boolean DELAY) {
        this.DELAY = DELAY;
    }

    public void setTMS_AB_TARGETS(List<TmsABInfo> TMS_AB_TARGETS) {
        this.TMS_AB_TARGETS = TMS_AB_TARGETS;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TmsBatchTargetInfo)) {
            return false;
        }
        TmsBatchTargetInfo other = (TmsBatchTargetInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BatchTargetInfo this$READ_TARGET_INFO = this.getREAD_TARGET_INFO();
        BatchTargetInfo other$READ_TARGET_INFO = other.getREAD_TARGET_INFO();
        if (this$READ_TARGET_INFO == null ? other$READ_TARGET_INFO != null : !((Object)this$READ_TARGET_INFO).equals(other$READ_TARGET_INFO)) {
            return false;
        }
        BatchDbTargetInfo this$WRITE_TARGET_INFO = this.getWRITE_TARGET_INFO();
        BatchDbTargetInfo other$WRITE_TARGET_INFO = other.getWRITE_TARGET_INFO();
        if (this$WRITE_TARGET_INFO == null ? other$WRITE_TARGET_INFO != null : !((Object)this$WRITE_TARGET_INFO).equals(other$WRITE_TARGET_INFO)) {
            return false;
        }
        String this$WORKDAY = this.getWORKDAY();
        String other$WORKDAY = other.getWORKDAY();
        if (this$WORKDAY == null ? other$WORKDAY != null : !this$WORKDAY.equals(other$WORKDAY)) {
            return false;
        }
        if (this.getSEND_ID() != other.getSEND_ID()) {
            return false;
        }
        if (this.getSCHD_ID() != other.getSCHD_ID()) {
            return false;
        }
        if (this.getTARGET_ID() != other.getTARGET_ID()) {
            return false;
        }
        if (this.getGROUP_DIVISION_UNIT() != other.getGROUP_DIVISION_UNIT()) {
            return false;
        }
        if (this.getDIVIDE_MINUTE() != other.getDIVIDE_MINUTE()) {
            return false;
        }
        if (this.isPUSH_CHANNEL() != other.isPUSH_CHANNEL()) {
            return false;
        }
        String this$ENCRYPT_KEY = this.getENCRYPT_KEY();
        String other$ENCRYPT_KEY = other.getENCRYPT_KEY();
        if (this$ENCRYPT_KEY == null ? other$ENCRYPT_KEY != null : !this$ENCRYPT_KEY.equals(other$ENCRYPT_KEY)) {
            return false;
        }
        if (this.isENCRYPT() != other.isENCRYPT()) {
            return false;
        }
        String this$CHANNEL_TYPE = this.getCHANNEL_TYPE();
        String other$CHANNEL_TYPE = other.getCHANNEL_TYPE();
        if (this$CHANNEL_TYPE == null ? other$CHANNEL_TYPE != null : !this$CHANNEL_TYPE.equals(other$CHANNEL_TYPE)) {
            return false;
        }
        String this$TARGET_TYPE = this.getTARGET_TYPE();
        String other$TARGET_TYPE = other.getTARGET_TYPE();
        if (this$TARGET_TYPE == null ? other$TARGET_TYPE != null : !this$TARGET_TYPE.equals(other$TARGET_TYPE)) {
            return false;
        }
        String this$TRIGGER_METHOD = this.getTRIGGER_METHOD();
        String other$TRIGGER_METHOD = other.getTRIGGER_METHOD();
        if (this$TRIGGER_METHOD == null ? other$TRIGGER_METHOD != null : !this$TRIGGER_METHOD.equals(other$TRIGGER_METHOD)) {
            return false;
        }
        if (this.getAPP_GRP_ID() != other.getAPP_GRP_ID()) {
            return false;
        }
        if (this.isAB_YN() != other.isAB_YN()) {
            return false;
        }
        if (this.getTARGET_SEQ_COUNT() != other.getTARGET_SEQ_COUNT()) {
            return false;
        }
        if (this.isNOW_TARGETING() != other.isNOW_TARGETING()) {
            return false;
        }
        if (this.isMOVE() != other.isMOVE()) {
            return false;
        }
        if (this.isDELAY() != other.isDELAY()) {
            return false;
        }
        List<TmsABInfo> this$TMS_AB_TARGETS = this.getTMS_AB_TARGETS();
        List<TmsABInfo> other$TMS_AB_TARGETS = other.getTMS_AB_TARGETS();
        return !(this$TMS_AB_TARGETS == null ? other$TMS_AB_TARGETS != null : !((Object)this$TMS_AB_TARGETS).equals(other$TMS_AB_TARGETS));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TmsBatchTargetInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BatchTargetInfo $READ_TARGET_INFO = this.getREAD_TARGET_INFO();
        result = result * 59 + ($READ_TARGET_INFO == null ? 43 : ((Object)$READ_TARGET_INFO).hashCode());
        BatchDbTargetInfo $WRITE_TARGET_INFO = this.getWRITE_TARGET_INFO();
        result = result * 59 + ($WRITE_TARGET_INFO == null ? 43 : ((Object)$WRITE_TARGET_INFO).hashCode());
        String $WORKDAY = this.getWORKDAY();
        result = result * 59 + ($WORKDAY == null ? 43 : $WORKDAY.hashCode());
        long $SEND_ID = this.getSEND_ID();
        result = result * 59 + (int)($SEND_ID >>> 32 ^ $SEND_ID);
        long $SCHD_ID = this.getSCHD_ID();
        result = result * 59 + (int)($SCHD_ID >>> 32 ^ $SCHD_ID);
        long $TARGET_ID = this.getTARGET_ID();
        result = result * 59 + (int)($TARGET_ID >>> 32 ^ $TARGET_ID);
        result = result * 59 + this.getGROUP_DIVISION_UNIT();
        result = result * 59 + this.getDIVIDE_MINUTE();
        result = result * 59 + (this.isPUSH_CHANNEL() ? 79 : 97);
        String $ENCRYPT_KEY = this.getENCRYPT_KEY();
        result = result * 59 + ($ENCRYPT_KEY == null ? 43 : $ENCRYPT_KEY.hashCode());
        result = result * 59 + (this.isENCRYPT() ? 79 : 97);
        String $CHANNEL_TYPE = this.getCHANNEL_TYPE();
        result = result * 59 + ($CHANNEL_TYPE == null ? 43 : $CHANNEL_TYPE.hashCode());
        String $TARGET_TYPE = this.getTARGET_TYPE();
        result = result * 59 + ($TARGET_TYPE == null ? 43 : $TARGET_TYPE.hashCode());
        String $TRIGGER_METHOD = this.getTRIGGER_METHOD();
        result = result * 59 + ($TRIGGER_METHOD == null ? 43 : $TRIGGER_METHOD.hashCode());
        result = result * 59 + this.getAPP_GRP_ID();
        result = result * 59 + (this.isAB_YN() ? 79 : 97);
        long $TARGET_SEQ_COUNT = this.getTARGET_SEQ_COUNT();
        result = result * 59 + (int)($TARGET_SEQ_COUNT >>> 32 ^ $TARGET_SEQ_COUNT);
        result = result * 59 + (this.isNOW_TARGETING() ? 79 : 97);
        result = result * 59 + (this.isMOVE() ? 79 : 97);
        result = result * 59 + (this.isDELAY() ? 79 : 97);
        List<TmsABInfo> $TMS_AB_TARGETS = this.getTMS_AB_TARGETS();
        result = result * 59 + ($TMS_AB_TARGETS == null ? 43 : ((Object)$TMS_AB_TARGETS).hashCode());
        return result;
    }

    public String toString() {
        return "TmsBatchTargetInfo(READ_TARGET_INFO=" + this.getREAD_TARGET_INFO() + ", WRITE_TARGET_INFO=" + this.getWRITE_TARGET_INFO() + ", WORKDAY=" + this.getWORKDAY() + ", SEND_ID=" + this.getSEND_ID() + ", SCHD_ID=" + this.getSCHD_ID() + ", TARGET_ID=" + this.getTARGET_ID() + ", GROUP_DIVISION_UNIT=" + this.getGROUP_DIVISION_UNIT() + ", DIVIDE_MINUTE=" + this.getDIVIDE_MINUTE() + ", PUSH_CHANNEL=" + this.isPUSH_CHANNEL() + ", ENCRYPT_KEY=" + this.getENCRYPT_KEY() + ", ENCRYPT=" + this.isENCRYPT() + ", CHANNEL_TYPE=" + this.getCHANNEL_TYPE() + ", TARGET_TYPE=" + this.getTARGET_TYPE() + ", TRIGGER_METHOD=" + this.getTRIGGER_METHOD() + ", APP_GRP_ID=" + this.getAPP_GRP_ID() + ", AB_YN=" + this.isAB_YN() + ", TARGET_SEQ_COUNT=" + this.getTARGET_SEQ_COUNT() + ", NOW_TARGETING=" + this.isNOW_TARGETING() + ", MOVE=" + this.isMOVE() + ", DELAY=" + this.isDELAY() + ", TMS_AB_TARGETS=" + this.getTMS_AB_TARGETS() + ")";
    }
}

