/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch;

import com.humuson.tms.adaptor.jdbc.DBType;
import com.humuson.tms.adaptor.jdbc.mybatis.DefaultDatabaseConfig;
import com.humuson.tms.config.ClassDispatcher;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.trans.module.batch.BatchProcessor;
import com.humuson.tms.trans.module.batch.BatchTargetExecutor;
import com.humuson.tms.trans.module.batch.BatchTargetInfo;
import com.humuson.tms.trans.module.batch.TmsBatchTargetInfo;
import com.humuson.tms.trans.module.batch.TmsLocalItemWriter;
import com.humuson.tms.trans.module.batch.confing.AsyncTaskPoolExecutorProperty;
import com.humuson.tms.trans.module.batch.confing.BatchTaskExecutorMonitor;
import com.humuson.tms.trans.module.batch.confing.DynamicBatchAssembly;
import com.humuson.tms.trans.module.batch.confing.TmsSimpleJobLauncherConfiguration;
import com.humuson.tms.trans.module.batch.option.ABTestJobParameter;
import com.humuson.tms.trans.repository.dao.SendInfoDao;
import com.humuson.tms.trans.repository.dao.TargetInfoDao;
import com.humuson.tms.trans.repository.model.TmsABInfo;
import com.humuson.tms.trans.repository.model.TmsControlInfo;
import com.humuson.tms.trans.repository.model.TmsTargetTemp;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

@Component
@EnableBatchProcessing
public abstract class TmsBatchTargetExecutor
extends BatchTargetExecutor<TmsBatchTargetInfo> {
    private static final Logger log = LoggerFactory.getLogger(TmsBatchTargetExecutor.class);
    @Autowired
    StepBuilderFactory stepBuilderFactory;
    @Autowired
    private TmsCommonConfig tmsConfig;
    @Autowired
    @Qualifier(value="tmsTargetTempProcessor")
    BatchProcessor<Map<String, Object>, TmsTargetTemp> tmsTargetTempProcessor;
    @Autowired
    @Qualifier(value="tmsTargetTempABProcessor")
    BatchProcessor<Map<String, Object>, TmsTargetTemp> tmsTargetTempABProcessor;
    @Autowired
    @Qualifier(value="tmsTargetTempDelayProcessor")
    BatchProcessor<Map<String, Object>, TmsTargetTemp> tmsTargetTempDelayProcessor;
    @Autowired
    TmsSimpleJobLauncherConfiguration tmsSimpleJobLauncherConfiguration;
    @Autowired
    DynamicBatchAssembly dynamicBatchAssembly;
    @Autowired
    AsyncTaskPoolExecutorProperty batchProperty;
    @Autowired
    SendInfoDao sendInfoDao;
    @Autowired
    TargetInfoDao targetInfoDao;
    @Autowired
    private DefaultDatabaseConfig defaultDatabaseConfig;
    @Autowired
    BatchTaskExecutorMonitor batchTaskExecutorMonitor;

    protected void preProcessing(TmsBatchTargetInfo targetInfo) throws Exception {
        this.isDivideSendThenSetDivide(targetInfo);
        targetInfo.setENCRYPT_KEY(this.tmsConfig.getHumusonKey());
        this.targetPreparation(targetInfo);
    }

    private void isDivideSendThenSetDivide(TmsBatchTargetInfo targetInfo) {
        TmsControlInfo controlInfo = this.sendInfoDao.selectControlInfo(targetInfo.getSEND_ID());
        if ("Y".equalsIgnoreCase(controlInfo.getUSE_YN()) && "Y".equalsIgnoreCase(controlInfo.getDIVIDE_SEND_USE_YN())) {
            targetInfo.setGROUP_DIVISION_UNIT(controlInfo.getDIVIDE_CNT());
            targetInfo.setDIVIDE_MINUTE(controlInfo.getDIVIDE_MINUTE());
        }
    }

    public void execute(TmsBatchTargetInfo targetInfo) throws Exception {
        this.execute(targetInfo, true);
    }

    public void lockExecute(TmsBatchTargetInfo targetInfo, boolean overPoolSkip) throws Exception {
        this.execute(targetInfo, overPoolSkip);
    }

    public void execute(TmsBatchTargetInfo targetInfo, boolean overPoolSkip) throws Exception {
        this.preProcessing(targetInfo);
        BatchTargetInfo batchTargetInfo = this.getBatchTargetInfo(targetInfo);
        try {
            while (!this.isAvailableTaskPool(targetInfo.getTRIGGER_METHOD())) {
                if (overPoolSkip) {
                    log.warn("job launcher is pool over. so this job[{}] skip", (Object)batchTargetInfo.getJOB_NAME());
                    return;
                }
                log.info("job launcher is pool over. so retry after 500ms job[{}]", (Object)batchTargetInfo.getJOB_NAME());
                Thread.sleep(500L);
            }
            TmsLocalItemWriter.TargetingItemWriter targetingItemWriter = (TmsLocalItemWriter.TargetingItemWriter)ClassDispatcher.getApplicationContext().getBean(TmsLocalItemWriter.TargetingItemWriter.class);
            ItemReader<HashMap<String, Object>> reader = this.getItemReader(targetInfo);
            if (reader instanceof JdbcCursorItemReader) {
                targetingItemWriter.setReadDataSource(((JdbcCursorItemReader)reader).getDataSource());
            }
            log.info("targetingItemWriter:[{}] targetingItemReader:[{}]", (Object)targetingItemWriter, reader);
            boolean isSecondaryTargeting = targetInfo.isDELAY() && !targetInfo.isMOVE();
            JobParameters jobParameters = null;
            if (isSecondaryTargeting) {
                targetingItemWriter.setDelayTargetInfo(targetInfo);
                jobParameters = this.createJobParameters(targetInfo);
            } else {
                targetingItemWriter.setTargetInfo(targetInfo);
                jobParameters = targetInfo.isAB_YN() ? this.setAbTestJobParameters(targetInfo) : this.createJobParameters(targetInfo);
            }
            DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
            attribute.setPropagationBehavior(Propagation.REQUIRED.value());
            attribute.setIsolationLevel(Isolation.READ_COMMITTED.value());
            TaskletStep step = this.stepBuilderFactory.get("STEP:".concat(batchTargetInfo.getJOB_NAME())).chunk(1000).reader(reader).processor(isSecondaryTargeting ? this.tmsTargetTempDelayProcessor : (targetInfo.isAB_YN() ? this.tmsTargetTempABProcessor : this.tmsTargetTempProcessor)).writer((ItemWriter)targetingItemWriter).transactionAttribute((TransactionAttribute)attribute).build();
            SimpleJobLauncher jobLauncher = this.tmsSimpleJobLauncherConfiguration.getLauncher(targetInfo.getTRIGGER_METHOD());
            log.info("job Launcher start [{}]", (Object)jobLauncher);
            if (log.isInfoEnabled()) {
                log.info("this job[{}] JobParameters[{}]", (Object)batchTargetInfo.getJOB_NAME(), (Object)jobParameters);
            }
            this.sendInfoDao.updateSendInfoJobStatus(targetInfo.getSEND_ID(), "25");
            jobLauncher.run(this.dynamicBatchAssembly.oneStepJob(batchTargetInfo.getJOB_NAME(), (Step)step), jobParameters);
            targetInfo.setNOW_TARGETING(true);
        }
        catch (Exception e) {
            log.error("batch target[job={}] error", (Object)batchTargetInfo.getJOB_NAME(), (Object)e);
            this.sendInfoDao.updateSendInfoJobStatus(targetInfo.getSEND_ID(), "31");
        }
    }

    private boolean isAvailableTaskPool(String triggerMethod) {
        return this.batchTaskExecutorMonitor.isAvailable(triggerMethod);
    }

    @Deprecated
    private void ifOracleTargetCount(long targetCount) {
        if (DBType.ORACLE == this.defaultDatabaseConfig.getDbType()) {
            this.targetInfoDao.selectTmsTargetTempSeqNextVal();
            long min = this.targetInfoDao.selectTmsTargetTempSeqCurrentVal();
            targetCount = min + targetCount;
            while (targetCount >= this.targetInfoDao.selectTmsTargetTempSeqNextVal()) {
                log.info("MAX TARGET COUNT >> {}", (Object)targetCount);
            }
        }
    }

    private JobParameters setAbTestJobParameters(TmsBatchTargetInfo targetInfo) {
        List<TmsABInfo> tmsABInfos = targetInfo.getTMS_AB_TARGETS();
        JobParametersBuilder builder = new JobParametersBuilder();
        for (TmsABInfo tmsABInfo : tmsABInfos) {
            builder.addParameter(tmsABInfo.getSEND_ID() + tmsABInfo.getTYPE(), (JobParameter)new ABTestJobParameter(tmsABInfo));
        }
        this.addJobParameters(builder, targetInfo);
        JobParameters jobParameters = builder.toJobParameters();
        return jobParameters;
    }

    public void addJobParameters(JobParametersBuilder builder, Object obj) {
        this.mappingParameters(builder, obj);
    }

    public JobParameters createJobParameters(Object obj) {
        JobParametersBuilder builder = new JobParametersBuilder();
        this.mappingParameters(builder, obj);
        return builder.toJobParameters();
    }

    private void mappingParameters(JobParametersBuilder builder, Object obj) {
        try {
            Method[] methods;
            for (Method m : methods = obj.getClass().getMethods()) {
                String key;
                Object value;
                if (m.getName().startsWith("get") && !m.getName().startsWith("getClass")) {
                    value = m.invoke(obj, new Object[0]);
                    key = m.getName().substring(3);
                    this.transObject(builder, value, key);
                    continue;
                }
                if (!m.getName().startsWith("is") || m.getName().startsWith("getClass")) continue;
                value = m.invoke(obj, new Object[0]);
                key = m.getName().substring(2);
                this.transObject(builder, value, key);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            log.error("error bean[{}] to map change. return null", obj, (Object)e);
            return;
        }
    }

    private void transObject(JobParametersBuilder builder, Object value, String key) {
        if (value instanceof String) {
            builder.addString(key, (String)value);
        } else if (value instanceof Float || value instanceof Double) {
            builder.addDouble(key, Double.valueOf(((Number)value).doubleValue()));
        } else if (value instanceof Integer || value instanceof Long) {
            builder.addLong(key, Long.valueOf(((Number)value).longValue()));
        } else if (value instanceof Date) {
            builder.addDate(key, (Date)value);
        } else if (value instanceof Boolean) {
            builder.addString(key, String.valueOf(value));
        } else {
            log.debug("Object contains values which are not job parameters (ignoring). [key:{}, value:{}]", (Object)key, value);
        }
    }

    protected abstract BatchTargetInfo getBatchTargetInfo(TmsBatchTargetInfo var1);

    protected abstract void targetPreparation(TmsBatchTargetInfo var1);

    protected abstract ItemReader<HashMap<String, Object>> getItemReader(TmsBatchTargetInfo var1) throws Exception;
}

