/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch;

import com.humuson.tms.adaptor.jdbc.TmsBatchDataSourceManager;
import com.humuson.tms.adaptor.jdbc.mybatis.DefaultDatabaseConfig;
import com.humuson.tms.batch.JdbcCursorItemReaderBuilder;
import com.humuson.tms.crypto.HumusonDecryptor;
import com.humuson.tms.trans.module.batch.BatchDbTargetInfo;
import com.humuson.tms.trans.module.batch.BatchTargetInfo;
import com.humuson.tms.trans.module.batch.TmsBatchTargetExecutor;
import com.humuson.tms.trans.module.batch.TmsBatchTargetInfo;
import com.humuson.tms.trans.module.batch.sec.TmsBatchDecryptor;
import com.humuson.tms.trans.module.batch.sec.TmsBatchEncryptor;
import com.humuson.tms.trans.repository.dao.TargetInfoDao;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.batch.MyBatisPagingItemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
@Qualifier(value="tmsBatchDbTargetExecutor")
public class TmsBatchDbTargetExecutor
extends TmsBatchTargetExecutor {
    private static final Logger log = LoggerFactory.getLogger(TmsBatchDbTargetExecutor.class);
    @Autowired
    DefaultDatabaseConfig defaultDatabaseConfig;
    @Autowired
    TargetInfoDao targetInfoDao;
    @Autowired(required=false)
    TmsBatchEncryptor tmsBatchEncryptor;
    @Autowired(required=false)
    TmsBatchDecryptor tmsBatchDecryptor;
    @Value(value="${tms.security.encrypt.enable}")
    protected boolean isEncrypt;
    @Value(value="${tms.security.encrypt-key}")
    protected String ENCRYPT_KEY;
    protected boolean isDecrypt;
    private DataSource readDataSource;

    @Override
    protected void targetPreparation(TmsBatchTargetInfo targetInfo) {
        this.isEncrypt = targetInfo.isENCRYPT();
        this.isDecrypt = !ObjectUtils.isEmpty((Object)this.tmsBatchDecryptor);
    }

    public DataSource getDataSource() {
        return this.readDataSource;
    }

    public SqlSessionFactory sqlSessionFactory(DataSource dataSource) throws Exception {
        SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(dataSource);
        return sessionFactory.getObject();
    }

    @Bean
    public ItemReader<HashMap<String, Object>> mybatisItemReader(SqlSessionFactory sqlSessionFactory) {
        MyBatisPagingItemReader reader = new MyBatisPagingItemReader();
        reader.setSqlSessionFactory(sqlSessionFactory);
        reader.setPageSize(1000);
        reader.setQueryId("mapper.package.path.MapperClass.MethodName");
        return reader;
    }

    @Override
    protected ItemReader<HashMap<String, Object>> getItemReader(TmsBatchTargetInfo targetInfo) throws Exception {
        BatchDbTargetInfo dbTargetInfo = (BatchDbTargetInfo)targetInfo.getREAD_TARGET_INFO();
        return new JdbcCursorItemReaderBuilder().dataSource(this.getDatasource(dbTargetInfo.getDB_ID(), targetInfo.targetCount())).name(dbTargetInfo.JOB_NAME).sql(dbTargetInfo.getSELECT_QUERY()).fetchSize(100).queryTimeout(0).rowMapper(this.getRowMapper()).ignoreWarnings(true).build();
    }

    private int timeout(String triggerMethod, long targetCount) {
        int timeout = 10 * (int)targetCount;
        if (timeout < 30000) {
            return 30000;
        }
        if (triggerMethod.equals("O9")) {
            return timeout * 3;
        }
        return timeout;
    }

    private RowMapper<HashMap<String, Object>> getRowMapper() {
        return new RowMapper<HashMap<String, Object>>(){

            public HashMap<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                return this.commonRowMapping(rs);
            }

            protected HashMap<String, Object> commonRowMapping(ResultSet rs) throws SQLException {
                HashMap<String, Object> mapping = new HashMap<String, Object>();
                ResultSetMetaData rsmd = rs.getMetaData();
                int cnt = rsmd.getColumnCount();
                for (int loop = 0; loop < cnt; ++loop) {
                    String key = rsmd.getColumnLabel(loop + 1);
                    if (ObjectUtils.isEmpty((Object)rs.getObject(loop + 1))) {
                        this.securityMappingPut(mapping, key, rs.getObject(loop + 1));
                        continue;
                    }
                    if (key.startsWith("TMS_")) {
                        if (rs.getObject(loop + 1) instanceof String) {
                            this.securityMappingPut(mapping, key, rs.getObject(loop + 1).toString().trim());
                            continue;
                        }
                        this.securityMappingPut(mapping, key, rs.getObject(loop + 1));
                        continue;
                    }
                    this.securityMappingPut(mapping, key, rs.getObject(loop + 1));
                }
                return mapping;
            }

            private void securityMappingPut(HashMap<String, Object> mapping, String key, Object value) {
                if (TmsBatchDbTargetExecutor.this.isDecrypt) {
                    mapping.put(key, TmsBatchDbTargetExecutor.this.tmsBatchDecryptor.decrypt(key, value));
                }
                if (TmsBatchDbTargetExecutor.this.isEncrypt) {
                    mapping.put(key, TmsBatchDbTargetExecutor.this.tmsBatchEncryptor.encrypt(key, value));
                } else {
                    mapping.put(key, value);
                }
            }
        };
    }

    public DataSource getDatasource1(int dbId, long targetCount) throws Exception {
        try {
            return TmsBatchDataSourceManager.INSTANCE.getDataSource(dbId);
        }
        catch (Exception e) {
            log.error("1012|datasource access error db_id[{}]", (Object)dbId, (Object)e);
            throw new Exception();
        }
    }

    public DataSource getDatasource(int dbId, long targetCount) throws Exception {
        try {
            DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource();
            Map dbInfo = TmsBatchDataSourceManager.INSTANCE.getTmsTargetDatabaseInfo(dbId);
            driverManagerDataSource.setUrl(dbInfo.get("DB_URL").toString());
            driverManagerDataSource.setDriverClassName(dbInfo.get("DB_DRV").toString());
            driverManagerDataSource.setUsername(dbInfo.get("DB_USR").toString());
            String pwd = HumusonDecryptor.decrypt((String)dbInfo.get("DB_PWD").toString(), (String)"amail0722!@");
            driverManagerDataSource.setPassword(pwd);
            return driverManagerDataSource;
        }
        catch (Exception e) {
            log.error("1012|datasource access error db_id[{}]", (Object)dbId, (Object)e);
            throw new Exception();
        }
    }

    @Override
    protected BatchTargetInfo getBatchTargetInfo(TmsBatchTargetInfo targetInfo) {
        return targetInfo.getREAD_TARGET_INFO();
    }
}

