/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module.batch;

import java.util.concurrent.atomic.AtomicInteger;

class TargetCounter {
    private AtomicInteger nowTargetCount = new AtomicInteger();
    private AtomicInteger targetCountOfSchdInfo = new AtomicInteger();
    private AtomicInteger successCumulativeCountDbBySchdInfo = new AtomicInteger();
    private AtomicInteger successCumulativeCountRedisBySchdInfo = new AtomicInteger();
    private AtomicInteger targetSeq = new AtomicInteger();
    private AtomicInteger totalTargetCountBySendInfo = new AtomicInteger();

    public TargetCounter() {
        this.nowTargetCount.set(0);
        this.targetCountOfSchdInfo.set(0);
        this.successCumulativeCountDbBySchdInfo.set(0);
        this.successCumulativeCountRedisBySchdInfo.set(0);
        this.targetSeq.set(0);
        this.totalTargetCountBySendInfo.set(0);
    }

    public int failedCountOfSchdInfo() {
        return this.targetCountOfSchdInfo.get() - this.successCumulativeCountRedisBySchdInfo.get();
    }

    public void setNowTargetCount(int count) {
        this.nowTargetCount.set(count);
        this.targetCountOfSchdInfo.getAndAdd(count);
        this.totalTargetCountBySendInfo.getAndAdd(count);
    }

    public void clearOfSchdInfo() {
        this.nowTargetCount.set(0);
        this.targetCountOfSchdInfo.set(0);
        this.successCumulativeCountDbBySchdInfo.set(0);
        this.successCumulativeCountRedisBySchdInfo.set(0);
    }

    public void setTotalTargetCountBySendInfo(int count) {
        this.totalTargetCountBySendInfo.getAndAdd(count);
    }

    public void setTargetCountOfSchdInfo(int count) {
        this.targetCountOfSchdInfo.getAndAdd(count);
    }

    public void setSuccessCumulativeCountDbBySchdInfo(int insertedCountToTempTable) {
        this.successCumulativeCountDbBySchdInfo.getAndAdd(insertedCountToTempTable);
    }

    public void setFailedIntoRedisBySchdInfo(int errSize) {
        this.successCumulativeCountRedisBySchdInfo.set(this.successCumulativeCountDbBySchdInfo.get() - errSize);
    }

    public AtomicInteger getNowTargetCount() {
        return this.nowTargetCount;
    }

    public AtomicInteger getTargetCountOfSchdInfo() {
        return this.targetCountOfSchdInfo;
    }

    public AtomicInteger getSuccessCumulativeCountDbBySchdInfo() {
        return this.successCumulativeCountDbBySchdInfo;
    }

    public AtomicInteger getSuccessCumulativeCountRedisBySchdInfo() {
        return this.successCumulativeCountRedisBySchdInfo;
    }

    public AtomicInteger getTargetSeq() {
        return this.targetSeq;
    }

    public AtomicInteger getTotalTargetCountBySendInfo() {
        return this.totalTargetCountBySendInfo;
    }

    public void setSuccessCumulativeCountRedisBySchdInfo(AtomicInteger successCumulativeCountRedisBySchdInfo) {
        this.successCumulativeCountRedisBySchdInfo = successCumulativeCountRedisBySchdInfo;
    }

    public void setTargetSeq(AtomicInteger targetSeq) {
        this.targetSeq = targetSeq;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TargetCounter)) {
            return false;
        }
        TargetCounter other = (TargetCounter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AtomicInteger this$nowTargetCount = this.getNowTargetCount();
        AtomicInteger other$nowTargetCount = other.getNowTargetCount();
        if (this$nowTargetCount == null ? other$nowTargetCount != null : !this$nowTargetCount.equals(other$nowTargetCount)) {
            return false;
        }
        AtomicInteger this$targetCountOfSchdInfo = this.getTargetCountOfSchdInfo();
        AtomicInteger other$targetCountOfSchdInfo = other.getTargetCountOfSchdInfo();
        if (this$targetCountOfSchdInfo == null ? other$targetCountOfSchdInfo != null : !this$targetCountOfSchdInfo.equals(other$targetCountOfSchdInfo)) {
            return false;
        }
        AtomicInteger this$successCumulativeCountDbBySchdInfo = this.getSuccessCumulativeCountDbBySchdInfo();
        AtomicInteger other$successCumulativeCountDbBySchdInfo = other.getSuccessCumulativeCountDbBySchdInfo();
        if (this$successCumulativeCountDbBySchdInfo == null ? other$successCumulativeCountDbBySchdInfo != null : !this$successCumulativeCountDbBySchdInfo.equals(other$successCumulativeCountDbBySchdInfo)) {
            return false;
        }
        AtomicInteger this$successCumulativeCountRedisBySchdInfo = this.getSuccessCumulativeCountRedisBySchdInfo();
        AtomicInteger other$successCumulativeCountRedisBySchdInfo = other.getSuccessCumulativeCountRedisBySchdInfo();
        if (this$successCumulativeCountRedisBySchdInfo == null ? other$successCumulativeCountRedisBySchdInfo != null : !this$successCumulativeCountRedisBySchdInfo.equals(other$successCumulativeCountRedisBySchdInfo)) {
            return false;
        }
        AtomicInteger this$targetSeq = this.getTargetSeq();
        AtomicInteger other$targetSeq = other.getTargetSeq();
        if (this$targetSeq == null ? other$targetSeq != null : !this$targetSeq.equals(other$targetSeq)) {
            return false;
        }
        AtomicInteger this$totalTargetCountBySendInfo = this.getTotalTargetCountBySendInfo();
        AtomicInteger other$totalTargetCountBySendInfo = other.getTotalTargetCountBySendInfo();
        return !(this$totalTargetCountBySendInfo == null ? other$totalTargetCountBySendInfo != null : !this$totalTargetCountBySendInfo.equals(other$totalTargetCountBySendInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TargetCounter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AtomicInteger $nowTargetCount = this.getNowTargetCount();
        result = result * 59 + ($nowTargetCount == null ? 43 : $nowTargetCount.hashCode());
        AtomicInteger $targetCountOfSchdInfo = this.getTargetCountOfSchdInfo();
        result = result * 59 + ($targetCountOfSchdInfo == null ? 43 : $targetCountOfSchdInfo.hashCode());
        AtomicInteger $successCumulativeCountDbBySchdInfo = this.getSuccessCumulativeCountDbBySchdInfo();
        result = result * 59 + ($successCumulativeCountDbBySchdInfo == null ? 43 : $successCumulativeCountDbBySchdInfo.hashCode());
        AtomicInteger $successCumulativeCountRedisBySchdInfo = this.getSuccessCumulativeCountRedisBySchdInfo();
        result = result * 59 + ($successCumulativeCountRedisBySchdInfo == null ? 43 : $successCumulativeCountRedisBySchdInfo.hashCode());
        AtomicInteger $targetSeq = this.getTargetSeq();
        result = result * 59 + ($targetSeq == null ? 43 : $targetSeq.hashCode());
        AtomicInteger $totalTargetCountBySendInfo = this.getTotalTargetCountBySendInfo();
        result = result * 59 + ($totalTargetCountBySendInfo == null ? 43 : $totalTargetCountBySendInfo.hashCode());
        return result;
    }

    public String toString() {
        return "TargetCounter(nowTargetCount=" + this.getNowTargetCount() + ", targetCountOfSchdInfo=" + this.getTargetCountOfSchdInfo() + ", successCumulativeCountDbBySchdInfo=" + this.getSuccessCumulativeCountDbBySchdInfo() + ", successCumulativeCountRedisBySchdInfo=" + this.getSuccessCumulativeCountRedisBySchdInfo() + ", targetSeq=" + this.getTargetSeq() + ", totalTargetCountBySendInfo=" + this.getTotalTargetCountBySendInfo() + ")";
    }
}

