/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module;

import com.humuson.tms.adaptor.jdbc.DBType;
import com.humuson.tms.adaptor.jdbc.mybatis.DefaultDatabaseConfig;
import com.humuson.tms.adaptor.jdbc.mybatis.DynamicMapSqlMapper;
import com.humuson.tms.config.Constants;
import com.humuson.tms.trans.repository.dao.SendInfoDao;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import com.humuson.tms.trans.repository.model.TmsSchdTarget;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import com.humuson.tms.trans.repository.model.TmsTargetLinkQueryInfo;
import com.humuson.tms.trans.repository.model.TmsTargetTempInfo;
import com.humuson.tms.trans.util.ObjectUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Component
@Transactional
public class TmsSchdInfoFactory {
    private static final Logger log = LoggerFactory.getLogger(TmsSchdInfoFactory.class);
    @Autowired
    protected SendInfoDao sendInfoDao;
    @Value(value="${tms.tracking.close.day:7}")
    private int tracking_close;
    @Autowired
    DynamicMapSqlMapper sqlMapper;
    @Autowired
    DefaultDatabaseConfig localDatabaseConfig;

    public TmsSchdInfo createSchdInfo(TmsSendInfo tmsSendInfo) throws Exception {
        return this.createSchdInfo(tmsSendInfo, false);
    }

    public TmsSchdInfo createSchdInfo(TmsSendInfo tmsSendInfo, boolean noTracking) throws Exception {
        TmsSchdInfo tmsSchdInfo = new TmsSchdInfo(tmsSendInfo.getSEND_ID());
        ObjectUtil.objectMerge(tmsSchdInfo, tmsSendInfo);
        this.setAddField(tmsSchdInfo, noTracking);
        return tmsSchdInfo;
    }

    public void makeSelectTargetQuery(TmsSchdTarget tmsSchdTarget, TmsTargetTempInfo tempInfo) {
        tmsSchdTarget.setTARGET_QUERY_S(this.sqlMapper.dynamicBoundSql(tmsSchdTarget.getTARGET_QUERY_S(), (Object)tempInfo, "@{"));
    }

    public TmsSchdTarget createTmsSchdTarget(TmsSchdInfo tmsSchdInfo, boolean isMoved) throws Exception {
        TmsSchdTarget tmsSchdTarget = new TmsSchdTarget();
        try {
            List<TmsTargetLinkQueryInfo> tmsTargetLinkQueryInfos = this.sendInfoDao.selectTargetLinkQueryInfo(tmsSchdInfo.getTARGET_ID(), tmsSchdInfo.getTARGET_TYPE());
            ObjectUtil.objectMerge(tmsSchdTarget, tmsSchdInfo);
            TmsTargetLinkQueryInfo selectTargetLinkQueryInfo = "FILE".equals(tmsSchdInfo.getTARGET_TYPE()) ? tmsTargetLinkQueryInfos.get(0) : this.getSelectTargetLinkQueryInfo(tmsTargetLinkQueryInfos);
            if (ObjectUtils.isEmpty((Object)selectTargetLinkQueryInfo)) {
                throw new NullPointerException("target_id=" + tmsSchdInfo.getTARGET_ID());
            }
            if (this.isNecessaryQueryForTmsTargetTemp(isMoved, selectTargetLinkQueryInfo.getTARGET_TYPE(), tmsSchdInfo.getCHANNEL_TYPE())) {
                this.setQueryLocalTmsTargetTemp(tmsSchdInfo, tmsSchdTarget);
                return tmsSchdTarget;
            }
            if ("FILE".equals(tmsSchdInfo.getTARGET_TYPE())) {
                ObjectUtil.objectMerge(tmsSchdTarget, tmsSchdInfo, selectTargetLinkQueryInfo);
                tmsSchdTarget.setTARGET_FILE(selectTargetLinkQueryInfo.getTARGET_FILE_NAME());
                tmsSchdTarget.setTARGET_FILE_ID(selectTargetLinkQueryInfo.getFILE_ID());
                return tmsSchdTarget;
            }
            for (TmsTargetLinkQueryInfo tmsTargetLinkQueryInfo : tmsTargetLinkQueryInfos) {
                if ("10".equals(tmsTargetLinkQueryInfo.getQUERY_TYPE())) {
                    ObjectUtil.objectMerge(tmsSchdTarget, tmsSchdInfo, tmsTargetLinkQueryInfo);
                    tmsSchdTarget.setTARGET_DB_ID(tmsTargetLinkQueryInfo.getDB_ID());
                    tmsSchdTarget.setTARGET_QUERY_S(tmsTargetLinkQueryInfo.getQUERY());
                    continue;
                }
                if (!"40".equals(tmsTargetLinkQueryInfo.getQUERY_TYPE())) continue;
                tmsSchdTarget.setTARGET_QUERY_U(tmsTargetLinkQueryInfo.getQUERY());
            }
            return tmsSchdTarget;
        }
        catch (NullPointerException e) {
            log.error("1101| null pointer error tmsSchdTarget[{}] ", (Object)tmsSchdTarget, (Object)e);
            throw e;
        }
        catch (Exception e) {
            log.error("1102| error inserting DB tmsSchdTarget[{}] ", (Object)tmsSchdTarget, (Object)e);
            throw e;
        }
    }

    public void setQueryLocalTmsTargetTemp(TmsSchdInfo tmsSchdInfo, TmsSchdTarget tmsSchdTarget) {
        tmsSchdTarget.setTARGET_DB_ID(-1);
        if (this.isPushChannel(tmsSchdInfo.getCHANNEL_TYPE())) {
            tmsSchdTarget.setTARGET_QUERY_S(this.makeRealtimePushTargetQuery(this.localDatabaseConfig.getDbType()));
            if (Constants.TriggerMethod.C5.name().equals(tmsSchdInfo.getTRIGGER_METHOD())) {
                tmsSchdTarget.setTARGET_QUERY_U(this.sqlMapper.boundOriginalSql("transferedUpdateQuery"));
            }
        } else {
            tmsSchdTarget.setTARGET_QUERY_S(this.sqlMapper.boundOriginalSql("transferedSelectQuery"));
        }
    }

    private boolean shouldUpdateQueryOfTmsTargetTemp(TmsSchdInfo tmsSchdInfo, TmsSchdTarget tmsSchdTarget) {
        return false;
    }

    private TmsTargetLinkQueryInfo getSelectTargetLinkQueryInfo(List<TmsTargetLinkQueryInfo> tmsTargetLinkQueryInfos) {
        for (TmsTargetLinkQueryInfo tmsTargetLinkQueryInfo : tmsTargetLinkQueryInfos) {
            if (!"10".equals(tmsTargetLinkQueryInfo.getQUERY_TYPE())) continue;
            return tmsTargetLinkQueryInfo;
        }
        return null;
    }

    public void createAndInsertSchdInfo(TmsSendInfo tmsSendInfo, boolean isMoved) throws Exception {
        this.createAndInsertSchdInfo(tmsSendInfo, isMoved, false);
    }

    public void createAndInsertSchdInfo(TmsSendInfo tmsSendInfo, boolean isMoved, boolean isZero) throws Exception {
        TmsSchdInfo schdInfo = this.createSchdInfo(tmsSendInfo, isZero);
        TmsSchdTarget tmsSchdTarget = this.createTmsSchdTarget(schdInfo, isMoved);
        schdInfo.setENCRYPT_YN(tmsSchdTarget.getENCRYPT_YN());
        if (!isMoved && Constants.TargetType.FILE.name().equals(tmsSendInfo.getTARGET_TYPE())) {
            tmsSchdTarget.setCT_TARGET_TYPE("FILE");
        } else {
            tmsSchdTarget.setCT_TARGET_TYPE("DB");
        }
        this.insertSchdInfo(schdInfo, tmsSchdTarget);
    }

    public long insertSchdInfo(TmsSchdInfo tmsSchdInfo) throws Exception {
        int insertSchdInfoCount = this.sendInfoDao.insertTmsSchdInfo(tmsSchdInfo);
        if (insertSchdInfoCount != 1) {
            log.error("DS0143|schd_info insert count is not one. so throw Exception schd_info_count[{}]", (Object)insertSchdInfoCount);
            throw new Exception("bad insert count schd_info_count[" + insertSchdInfoCount + "]");
        }
        return tmsSchdInfo.getSCHD_ID();
    }

    public void insertSchdInfo(TmsSchdInfo tmsSchdInfo, TmsSchdTarget tmsSchdTarget) throws Exception {
        try {
            int insertSchdInfoCount = this.sendInfoDao.insertTmsSchdInfo(tmsSchdInfo);
            tmsSchdTarget.setSCHD_ID(tmsSchdInfo.getSCHD_ID());
            int insertSchdTargetCount = this.sendInfoDao.insertTmsSchdTarget(tmsSchdTarget);
            if (log.isDebugEnabled()) {
                log.debug("for insert. tms-schd-info[{}]", (Object)tmsSchdInfo);
            }
            if (insertSchdInfoCount != 1 || insertSchdTargetCount != 1) {
                log.error("DS0143|schd_info, schd_target insert count is not one. so throw Exception schd_info_count[{}], schd_target_count[{}]", (Object)insertSchdInfoCount, (Object)insertSchdTargetCount);
                throw new Exception("bad insert count schd_info_count[" + insertSchdInfoCount + "], schd_target_count[" + insertSchdTargetCount + "]");
            }
            log.info("created schd info[schd_id={}], schd_target[schd_target_id={}] in send_id[{}]", new Object[]{tmsSchdInfo.getSCHD_ID(), tmsSchdTarget.getSCHD_TARGET_ID(), tmsSchdInfo.getSEND_ID()});
            if (log.isDebugEnabled()) {
                log.debug("\n created schd_info[{}] \n created schd_target[{}]", (Object)tmsSchdInfo, (Object)tmsSchdTarget);
            }
        }
        catch (Exception e) {
            log.error("DS0144|failed insert to schd_info[{}], schd_target table rollback send_id[{}]", new Object[]{tmsSchdInfo.getSCHD_ID(), tmsSchdInfo.getSEND_ID(), e});
        }
    }

    private void setAddField(TmsSchdInfo tmsSchdInfo, boolean noTracking) {
        tmsSchdInfo.setWORKDAY(DateUtil.getWorkday());
        tmsSchdInfo.setEND_DATE(DateUtil.getDateEndTime());
        if (tmsSchdInfo.getSTART_DATE() == null) {
            tmsSchdInfo.setSTART_DATE(DateUtil.getFullDate((String)"yyyy-MM-dd HH:mm:ss"));
        }
        tmsSchdInfo.setJOB_STATUS("20");
        tmsSchdInfo.setDEL_YN("N");
        tmsSchdInfo.setWORKING_YN("N");
        String trackingClose = this.sendInfoDao.selectControlInfo(tmsSchdInfo.getSEND_ID()).getTRACKING_CLOSE();
        if (noTracking) {
            tmsSchdInfo.setTRACKING_CLOSE("1900-01-01");
        } else {
            tmsSchdInfo.setTRACKING_CLOSE(StringUtils.isEmpty((String)trackingClose) ? DateUtil.addDate((String)"yyyy-MM-dd", (int)this.tracking_close) : trackingClose);
        }
        tmsSchdInfo.setGRP_ID("" + System.currentTimeMillis());
    }

    private boolean isNecessaryQueryForTmsTargetTemp(boolean isMoved, String targetType, String channelType) {
        return isMoved || Constants.ChannelType.PU.name().equalsIgnoreCase(channelType);
    }

    private boolean isPushChannel(String channelType) {
        return Constants.ChannelType.PU.name().equalsIgnoreCase(channelType);
    }

    @Deprecated
    private String makeRealtimePushUpdateQuery() {
        return ((StringBuilder)new SQL(){
            {
                this.UPDATE("TMS_TARGET_TEMP");
                this.SET("TARGET_FLAG='Y'");
                this.WHERE("TARGET_TEMP_ID=#{TARGET_TEMP_ID} AND TARGET_FLAG='N'");
            }
        }.usingAppender((Appendable)new StringBuilder())).toString();
    }

    private String makeRealtimePushTargetQuery(DBType dbType) {
        if (DBType.ORACLE == dbType) {
            return ((StringBuilder)new SQL(){
                {
                    this.SELECT("T.TMS_M_ID,                                                    T.TARGET_TEMP_ID,                                              T.TARGET_ID,                                                   NVL(D.APP_GRP_ID, D2.APP_GRP_ID) AS APP_GRP_ID,             NVL(D.APP_ID, D2.APP_ID) AS APP_ID,                         NVL(D.DEVICE_ID, D2.DEVICE_ID) AS DEVICE_ID,                NVL(D.DEVICE, D2.DEVICE) AS DEVICE,                         NVL(D.NOTI_FLAG, D2.NOTI_FLAG) NOTI_FLAG,                   NVL(D.BMKT_FLAG, D2.BMKT_FLAG) BMKT_FLAG,                   NVL(D.UUID, D2.UUID) UUID,                                  NVL(D.OS, D2.OS) OS,                                        NVL(D.TOKEN, NVL(D2.TOKEN,'NO_TOKEN')) AS TMS_M_TOKEN,      T.GRP_SEQ,                                                     T.WORKDAY,                                                     T.SEND_ID,                                                     T.TMS_M_NAME,                                                  T.TMS_M_EMAIL,                                                 T.TMS_M_PHONE,                                                 T.TARGET_FLAG,                                                 T.DATA01,                                                      T.DATA02,                                                      T.DATA03,                                                      T.ETC,                                                         T.REG_DATE                                                     ");
                    this.FROM(" TMS_TARGET_TEMP T");
                    this.LEFT_OUTER_JOIN("TMS_APP_USER_LIST U ON (U.CUST_ID = T.TMS_M_ID AND U.APP_GRP_ID = @{APP_GRP_ID})");
                    this.LEFT_OUTER_JOIN("TMS_APP_DEVICE_LIST D ON (D.DEVICE_ID = U.LAST_DEVICE_ID AND D.APP_GRP_ID = @{APP_GRP_ID})");
                    this.LEFT_OUTER_JOIN("TMS_APP_DEVICE_LIST D2 ON (D2.DEVICE_ID = SUBSTR(T.TMS_M_ID,5) AND T.TMS_M_ID LIKE 'TMS-%' AND D2.APP_GRP_ID = @{APP_GRP_ID})");
                    this.WHERE(" T.TARGET_ID =@{TARGET_ID} ");
                    this.WHERE(" T.GRP_SEQ =  @{GRP_SEQ}   ");
                    this.WHERE(" T.SEND_ID=   @{SEND_ID}   ");
                    this.WHERE(" T.WORKDAY = '@{WORKDAY}'  ");
                    this.WHERE(" T.TARGET_FLAG = 'N'  ");
                }
            }.usingAppender((Appendable)new StringBuilder())).toString();
        }
        return ((StringBuilder)new SQL(){
            {
                this.SELECT("T.TMS_M_ID,                                                    T.TARGET_TEMP_ID,                                              T.TARGET_ID,                                                   IFNULL(D.APP_GRP_ID, D2.APP_GRP_ID) AS APP_GRP_ID,             IFNULL(D.APP_ID, D2.APP_ID) AS APP_ID,                         IFNULL(D.DEVICE_ID, D2.DEVICE_ID) AS DEVICE_ID,                IFNULL(D.DEVICE, D2.DEVICE) AS DEVICE,                         IFNULL(D.NOTI_FLAG, D2.NOTI_FLAG) NOTI_FLAG,                   IFNULL(D.BMKT_FLAG, D2.BMKT_FLAG) BMKT_FLAG,                   IFNULL(D.UUID, D2.UUID) UUID,                                  IFNULL(D.OS, D2.OS) OS,                                        IFNULL(D.TOKEN, IFNULL(D2.TOKEN,'NO_TOKEN')) AS TMS_M_TOKEN,   T.GRP_SEQ,                                                     T.WORKDAY,                                                     T.SEND_ID,                                                     T.TMS_M_NAME,                                                  T.TMS_M_EMAIL,                                                 T.TMS_M_PHONE,                                                 T.TARGET_FLAG,                                                 T.DATA01,                                                      T.DATA02,                                                      T.DATA03,                                                      T.ETC,                                                         T.REG_DATE                                                     ");
                this.FROM(" TMS_TARGET_TEMP T");
                this.LEFT_OUTER_JOIN("TMS_APP_USER_LIST U ON (U.CUST_ID = T.TMS_M_ID AND U.APP_GRP_ID = @{APP_GRP_ID})");
                this.LEFT_OUTER_JOIN("TMS_APP_DEVICE_LIST D ON (D.DEVICE_ID = U.LAST_DEVICE_ID AND D.APP_GRP_ID = @{APP_GRP_ID})");
                this.LEFT_OUTER_JOIN("TMS_APP_DEVICE_LIST D2 ON (D2.DEVICE_ID = SUBSTR(T.TMS_M_ID,5) AND T.TMS_M_ID LIKE 'TMS-%' AND D2.APP_GRP_ID = @{APP_GRP_ID})");
                this.WHERE(" T.TARGET_ID =@{TARGET_ID} ");
                this.WHERE(" T.GRP_SEQ =  @{GRP_SEQ}   ");
                this.WHERE(" T.SEND_ID=   @{SEND_ID}   ");
                this.WHERE(" T.WORKDAY = '@{WORKDAY}'  ");
                this.WHERE(" T.TARGET_FLAG = 'N'  ");
            }
        }.usingAppender((Appendable)new StringBuilder())).toString();
    }

    public void updateSchdInfoOfRealtimePush(TmsSchdInfo tmsSchdInfo, TmsSchdTarget tmsSchdTarget) throws Exception {
        this.sendInfoDao.updateSchdTargetQuery(tmsSchdInfo.getSCHD_ID(), tmsSchdInfo.getWORKDAY(), tmsSchdTarget.getTARGET_QUERY_S(), tmsSchdTarget.getTARGET_QUERY_U());
        this.sendInfoDao.updateSchdInfoJobStatus(tmsSchdInfo.getSCHD_ID(), "10");
    }
}

