/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.trans.repository.model.redis.RedisUploader;
import com.humuson.tms.util.json.JsonConvertUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class TmsRedisVoProvider {
    private static final Logger log = LoggerFactory.getLogger(TmsRedisVoProvider.class);
    @Autowired
    protected WrapperRedisTemplate rdTemplate;

    public boolean upload(RedisUploader uploader) {
        try {
            this.uploadRedis(uploader);
            return true;
        }
        catch (Exception e) {
            log.error("error uploading to redis. pinfoVo[{}]", (Object)uploader, (Object)e);
            return false;
        }
    }

    public void uploadRedis(RedisUploader uploader) throws Exception {
        uploader.execute(this.rdTemplate);
    }

    public void uploadListSameKeyRedis(List<RedisUploader> uploadList) throws Exception {
        String key = null;
        HashMap<String, String> fieldValue = new HashMap<String, String>();
        for (RedisUploader uploader : uploadList) {
            if (key == null) {
                key = uploader.key();
            }
            fieldValue.put(uploader.field(), JsonConvertUtil.objectToJsonString((Serializable)((Serializable)uploader.value())));
        }
        this.rdTemplate.hmsetAll(key, fieldValue);
    }

    public void uploadListSameKeyRedis(String key, Map<Object, Object> fieldValue) throws Exception {
        this.rdTemplate.hmsetAllObject(key, fieldValue);
    }
}

