/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module;

import com.humuson.tms.trans.module.AllTlistUploadException;
import com.humuson.tms.trans.module.TmsRedisVoProvider;
import com.humuson.tms.trans.module.util.EmailUtil;
import com.humuson.tms.trans.repository.model.TmsPuTargetTemp;
import com.humuson.tms.trans.repository.model.TmsTargetTemp;
import com.humuson.tms.trans.repository.model.redis.MfatiVo;
import com.humuson.tms.trans.repository.model.redis.PinfoVo;
import com.humuson.tms.trans.repository.model.redis.PuTlistVo;
import com.humuson.tms.trans.repository.model.redis.TlistVo;
import com.humuson.tms.util.Cal;
import com.humuson.tms.util.date.DateUtil;
import com.humuson.tms.util.json.JsonConvertUtil;
import com.humuson.tms.util.validator.TmsValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class TmsRedisTlistProvider
extends TmsRedisVoProvider {
    private static final Logger log = LoggerFactory.getLogger(TmsRedisTlistProvider.class);
    List<TmsTargetTemp> errors = new ArrayList<TmsTargetTemp>();
    String channelType;

    public String uploadTlistVos(PinfoVo basicPinfoVo, TlistVo basicTlistVo, List<? extends Object> targetTemp) throws Exception {
        this.errors.clear();
        TmsValidator validator = new TmsValidator();
        this.channelType = basicTlistVo.getChannel_type();
        TlistVo vo = new TlistVo();
        try {
            validator.init();
            HashMap<Object, Object> fieldValues = new HashMap<Object, Object>();
            for (Object object : targetTemp) {
                try {
                    TmsTargetTemp tmsTargetTemp = (TmsTargetTemp)object;
                    this.validate((TmsValidator<TmsTargetTemp>)validator, tmsTargetTemp);
                    if (!tmsTargetTemp.isSuccessValidate()) {
                        log.error("this target[schd_id={}/tms_m_id={}] filtered. error code[{}], msg[{}]", new Object[]{tmsTargetTemp.getSCHD_ID(), tmsTargetTemp.getTMS_M_ID(), tmsTargetTemp.getErrCode(), tmsTargetTemp.getErrMsg()});
                        this.errors.add((TmsTargetTemp)object);
                        continue;
                    }
                    vo = this.createTlistVo(basicTlistVo, tmsTargetTemp);
                    this.setTMS_M_TARGET(basicTlistVo.getChannel_type(), vo, tmsTargetTemp);
                    fieldValues.put(vo.field(), JsonConvertUtil.objectToJsonString((Serializable)vo.value()));
                }
                catch (NullPointerException ne) {
                    log.error("[TLIST] vo create is null, param[basicTlistvo={}], tmsTargetTemp={}", new Object[]{basicTlistVo, object, ne});
                    this.errors.add((TmsTargetTemp)object);
                }
                catch (Exception e) {
                    log.error("this targetTemp is failed upload to redis [TLIST]. TmsTargetTemp=[{}]", object, (Object)e);
                    this.errors.add((TmsTargetTemp)object);
                }
            }
            if (this.errors.size() == targetTemp.size()) {
                log.error("all target data[count={}] is error for tlist uploading. schd_id[{}]. basicTlistVo={} ", new Object[]{this.errors.size(), this.errors.get(0).getSCHD_ID(), basicTlistVo});
                throw new AllTlistUploadException("TLIST uploading all error. check validator schd_id[" + this.errors.get(0).getSCHD_ID() + "]");
            }
            this.uploadListSameKeyRedis(vo.key(), fieldValues);
            String string = vo.key();
            return string;
        }
        catch (Exception e) {
            log.error("error creating tlist TmsTargetTemp size[err={}/all={}]", new Object[]{this.errors.size(), targetTemp.size(), e});
            throw e;
        }
        finally {
            validator.close();
        }
    }

    private void filter(PinfoVo basicPinfoVo, TmsTargetTemp tmsTargetTemp) {
        if (!basicPinfoVo.isFatigue()) {
            return;
        }
        MfatiVo fatigue = MfatiVo.builder().CHANNEL_TYPE(basicPinfoVo.getCHANNEL_TYPE()).SITE_ID(basicPinfoVo.getSITE_ID()).TMS_M_ID(tmsTargetTemp.getTMS_M_ID()).build();
        int limit = basicPinfoVo.getHOUR_LIMIT();
        String limitTimeTxt = "\uc2dc\uac04";
        this.filterFatigue(basicPinfoVo, tmsTargetTemp, fatigue);
        if (basicPinfoVo.getDAY_LIMIT() > 0) {
            fatigue.setDateTimeKey(Cal.getDayDate());
            this.upload(fatigue);
            if (fatigue.isOverSent(basicPinfoVo.getDAY_LIMIT())) {
                tmsTargetTemp.setErrCode("1011");
                tmsTargetTemp.setErrMsg("\uc77c \ubc1c\uc1a1 \uc81c\ud55c[" + basicPinfoVo.getDAY_LIMIT() + "]\ubcf4\ub2e4 \ub9ce\uc740 \ud69f\uc218[" + fatigue.getSentCount() + "]\ub85c \ud53c\ub85c\ub3c4\uc5d0 \ud544\ud130\ub9c1 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            }
        }
        if (basicPinfoVo.getWEEK_LIMIT() > 0) {
            fatigue.setDateTimeKey(Cal.getMonth() + Cal.getWeekDay());
            this.upload(fatigue);
            if (fatigue.isOverSent(basicPinfoVo.getWEEK_LIMIT())) {
                tmsTargetTemp.setErrCode("1012");
                tmsTargetTemp.setErrMsg("\uc8fc \ubc1c\uc1a1 \uc81c\ud55c[" + basicPinfoVo.getWEEK_LIMIT() + "]\ubcf4\ub2e4 \ub9ce\uc740 \ud69f\uc218[" + fatigue.getSentCount() + "]\ub85c \ud53c\ub85c\ub3c4\uc5d0 \ud544\ud130\ub9c1 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            }
        }
        if (basicPinfoVo.getMON_LIMIT() > 0) {
            fatigue.setDateTimeKey(Cal.getYYYYMM());
            this.upload(fatigue);
            if (fatigue.isOverSent(basicPinfoVo.getMON_LIMIT())) {
                tmsTargetTemp.setErrCode("1013");
                tmsTargetTemp.setErrMsg("\uc6d4 \ubc1c\uc1a1 \uc81c\ud55c[" + basicPinfoVo.getMON_LIMIT() + "]\ubcf4\ub2e4 \ub9ce\uc740 \ud69f\uc218[" + fatigue.getSentCount() + "]\ub85c \ud53c\ub85c\ub3c4\uc5d0 \ud544\ud130\ub9c1 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            }
        }
    }

    private void filterFatigue(PinfoVo basicPinfoVo, TmsTargetTemp tmsTargetTemp, MfatiVo fatigue) {
        if (basicPinfoVo.getHOUR_LIMIT() > 0) {
            fatigue.setDateTimeKey(Cal.getHourDate());
            this.upload(fatigue);
            if (fatigue.isOverSent(basicPinfoVo.getHOUR_LIMIT())) {
                tmsTargetTemp.setErrCode("1010");
                tmsTargetTemp.setErrMsg("\uc2dc\uac04 \ubc1c\uc1a1 \uc81c\ud55c[" + basicPinfoVo.getHOUR_LIMIT() + "]\ubcf4\ub2e4 \ub9ce\uc740 \ud69f\uc218[" + fatigue.getSentCount() + "]\ub85c \ud53c\ub85c\ub3c4\uc5d0 \ud544\ud130\ub9c1 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
            }
        }
    }

    private void setTMS_M_TARGET(String channelType, TlistVo vo, TmsTargetTemp targetTemp) {
        if ("EM".equals(channelType)) {
            vo.setTms_m_target(vo.getTms_m_email());
        } else if ("SM".equals(channelType) || "KA".equals(channelType)) {
            vo.setTms_m_target(vo.getTms_m_phone());
        } else if ("PU".equals(channelType)) {
            vo.setTms_m_target(((PuTlistVo)vo).getTms_m_token());
        }
    }

    public void validate(TmsValidator<TmsTargetTemp> validator, TmsTargetTemp temp) {
        String errMessage = validator.validating((Object)temp);
        if (!ObjectUtils.isEmpty((Object)errMessage)) {
            temp.setErrCode("1009");
            temp.setErrMsg(errMessage);
        }
    }

    public List<TmsTargetTemp> getErrorList() {
        return this.errors;
    }

    private TlistVo createTlistVo(TlistVo basicTlistVo, TmsTargetTemp target) {
        if (target instanceof TmsPuTargetTemp) {
            TmsPuTargetTemp puTarget = (TmsPuTargetTemp)target;
            PuTlistVo vo = PuTlistVo.builder().app_grp_id(puTarget.getAPP_GRP_ID()).app_id(puTarget.getAPP_ID()).device(puTarget.getDEVICE()).device_id(puTarget.getDEVICE_ID()).noti_flag(puTarget.getNOTI_FLAG()).bmkt_flag(puTarget.getBMKT_FLAG()).tms_m_token(puTarget.getTMS_M_TOKEN()).uuid(puTarget.getUUID()).build();
            vo.setDomain(puTarget.getDOMAIN());
            vo.setSchd_id(target.getSCHD_ID());
            vo.setWorkday(target.getWORKDAY());
            vo.setMember_id(target.getTMS_M_ID());
            vo.setTms_m_id(target.getTMS_M_ID());
            vo.setCamp_type(basicTlistVo.getCamp_type());
            vo.setMember_id_seq(target.getTARGET_TEMP_ID());
            vo.setTms_m_email(target.getTMS_M_EMAIL());
            vo.setTms_m_name(target.getTMS_M_NAME());
            vo.setTms_m_phone(target.getTMS_M_PHONE());
            vo.setStart_time(DateUtil.getFullDateDefaultFormat());
            vo.setServer_id(basicTlistVo.getServer_id());
            vo.setTarget_seq(basicTlistVo.getTarget_seq());
            return vo;
        }
        TlistVo vo = new TlistVo();
        vo.setSchd_id(target.getSCHD_ID());
        vo.setWorkday(target.getWORKDAY());
        vo.setMember_id(target.getTMS_M_ID());
        vo.setTms_m_id(target.getTMS_M_ID());
        vo.setCamp_type(basicTlistVo.getCamp_type());
        vo.setMember_id_seq(target.getTARGET_TEMP_ID());
        vo.setTms_m_email(target.getTMS_M_EMAIL());
        vo.setTms_m_name(target.getTMS_M_NAME());
        vo.setTms_m_phone(target.getTMS_M_PHONE());
        vo.setStart_time(DateUtil.getFullDateDefaultFormat());
        vo.setDomain(this.setChannelTypeDomain(target));
        vo.setServer_id(basicTlistVo.getServer_id());
        vo.setTarget_seq(basicTlistVo.getTarget_seq());
        return vo;
    }

    private String setChannelTypeDomain(TmsTargetTemp target) {
        if ("PU".equals(this.channelType)) {
            return ((TmsPuTargetTemp)target).getOS();
        }
        if ("SM".equals(this.channelType)) {
            return "SMS";
        }
        if ("EM".equals(this.channelType)) {
            return EmailUtil.getDomain(target.getTMS_M_EMAIL());
        }
        return null;
    }

    public static void main(String[] args) {
        String email = "netwelnaver.com";
        Object email1 = null;
        System.out.println(EmailUtil.getDomain(email));
    }
}

