/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module;

import com.humuson.tms.config.ChannelType;
import com.humuson.tms.trans.module.NotFoundPinfoChannelException;
import com.humuson.tms.trans.module.TmsRedisVoProvider;
import com.humuson.tms.trans.repository.dao.PinfoDao;
import com.humuson.tms.trans.repository.dao.SendInfoDao;
import com.humuson.tms.trans.repository.model.TmsAdditionInfo;
import com.humuson.tms.trans.repository.model.TmsAppInfo;
import com.humuson.tms.trans.repository.model.TmsChannelInfo;
import com.humuson.tms.trans.repository.model.TmsContentInfo;
import com.humuson.tms.trans.repository.model.TmsControlInfo;
import com.humuson.tms.trans.repository.model.TmsFatigueInfo;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import com.humuson.tms.trans.repository.model.TmsSiteInfo;
import com.humuson.tms.trans.repository.model.TmsTargetInfo;
import com.humuson.tms.trans.repository.model.redis.EmPinfoVo;
import com.humuson.tms.trans.repository.model.redis.KaPinfoVo;
import com.humuson.tms.trans.repository.model.redis.PinfoVo;
import com.humuson.tms.trans.repository.model.redis.PuPinfoVo;
import com.humuson.tms.trans.repository.model.redis.SmPinfoVo;
import com.humuson.tms.trans.util.ObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TmsRedisPinfoProvider
extends TmsRedisVoProvider {
    private static final Logger log = LoggerFactory.getLogger(TmsRedisPinfoProvider.class);
    @Autowired
    private PinfoDao pinfoDao;
    @Autowired
    private SendInfoDao sendInfoDao;

    public boolean upload(PinfoVo basicPinfoVo, TmsSchdInfo tmsSchdInfo) {
        try {
            BeanUtils.copyProperties((Object)tmsSchdInfo, (Object)basicPinfoVo);
        }
        catch (Exception e) {
            log.error("object merge fail to pinfoVo. tmsSchdInfo[{}] ", (Object)tmsSchdInfo, (Object)e);
            return false;
        }
        return this.upload(basicPinfoVo);
    }

    public PinfoVo createBasicPinfo(TmsSendInfo tmsSendInfo) throws Exception {
        PinfoVo pinfoVo = this.createPinfoOfChannel(tmsSendInfo.getCHANNEL_TYPE());
        pinfoVo.setCHANNEL_TYPE(tmsSendInfo.getCHANNEL_TYPE());
        TmsSiteInfo tmsSiteInfo = this.pinfoDao.selectSiteInfo(tmsSendInfo.getCAMP_ID());
        TmsContentInfo tmsContentInfo = this.pinfoDao.selectContentInfo(tmsSendInfo.getCONTENT_ID());
        TmsTargetInfo tmsTargetInfo = this.pinfoDao.selectTargetInfo(tmsSendInfo.getTARGET_ID());
        TmsAdditionInfo tmsAdditionInfo = this.pinfoDao.selectAdditionInfo(tmsSendInfo.getSEND_ADD_ID());
        TmsControlInfo tmsControlInfo = this.pinfoDao.selectControlInfo(tmsSendInfo.getSEND_ADD_ID());
        TmsFatigueInfo tmsFatigueInfo = this.pinfoDao.selectFatigueInfo(tmsSendInfo.getSITE_ID(), tmsSendInfo.getCHANNEL_TYPE());
        if ("PU".equals(tmsSendInfo.getCHANNEL_TYPE())) {
            TmsAppInfo tmsAppInfo = this.pinfoDao.selectAppInfo(tmsAdditionInfo.getAPP_GRP_ID());
            ObjectUtil.objectMerge(pinfoVo, tmsAppInfo);
        }
        if ("SM".equals(tmsSendInfo.getCHANNEL_TYPE())) {
            TmsChannelInfo tmsChannelInfo = this.pinfoDao.selectChannelInfo(tmsSendInfo.getCHANNEL_ID());
            ObjectUtil.objectMerge(pinfoVo, tmsChannelInfo);
        }
        try {
            ObjectUtil.objectMerge(pinfoVo, tmsSiteInfo);
            ObjectUtil.objectMerge(pinfoVo, tmsContentInfo);
            ObjectUtil.objectMerge(pinfoVo, tmsTargetInfo);
            ObjectUtil.objectMerge(pinfoVo, tmsAdditionInfo);
            ObjectUtil.objectMerge(pinfoVo, tmsControlInfo);
            ObjectUtil.objectMergeNullIgnore(pinfoVo, tmsFatigueInfo);
            ObjectUtil.objectMerge(pinfoVo, tmsSendInfo);
            return pinfoVo;
        }
        catch (Exception e) {
            log.error("object merge failed to pinfoVo. sendInfo[{}] ", (Object)tmsSendInfo, (Object)e);
            throw e;
        }
    }

    private PinfoVo createPinfoOfChannel(String cType) throws NotFoundPinfoChannelException {
        if (ChannelType.EMAIL.getCode().equalsIgnoreCase(cType.trim())) {
            return new EmPinfoVo();
        }
        if (ChannelType.PUSH.getCode().equalsIgnoreCase(cType.trim())) {
            return new PuPinfoVo();
        }
        if (ChannelType.KAKAO.getCode().equalsIgnoreCase(cType.trim())) {
            return new KaPinfoVo();
        }
        if (ChannelType.SMS.getCode().equalsIgnoreCase(cType.trim())) {
            return new SmPinfoVo();
        }
        throw new NotFoundPinfoChannelException(cType);
    }

    public PinfoVo createBasicPinfo(long sendId) throws Exception {
        return this.createBasicPinfo(this.sendInfoDao.selectSendInfo(sendId));
    }

    public static void main(String[] args) {
        EmPinfoVo p = new EmPinfoVo();
        p.setATTACH_YN("Y");
        p.setFROM_EMAIL("from@humuson.com");
        TmsSchdInfo schdInfo = new TmsSchdInfo();
        schdInfo.setSCHD_ID(12345L);
        BeanUtils.copyProperties((Object)schdInfo, (Object)p);
        System.out.println(p);
    }
}

