/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.module;

import com.humuson.tms.adaptor.jdbc.mybatis.TmsJdbcTemplate;
import com.humuson.tms.adaptor.jdbc.mybatis.util.VariableTokenHandler;
import com.humuson.tms.config.Constants;
import com.humuson.tms.trans.module.batch.BatchDbTargetInfo;
import com.humuson.tms.trans.module.batch.BatchFileTargetInfo;
import com.humuson.tms.trans.module.batch.BatchTargetInfo;
import com.humuson.tms.trans.module.batch.TmsBatchTargetInfo;
import com.humuson.tms.trans.module.query.BasicQueryOptimizer;
import com.humuson.tms.trans.module.query.QueryOptimizer;
import com.humuson.tms.trans.repository.dao.SendInfoDao;
import com.humuson.tms.trans.repository.model.TmsABInfo;
import com.humuson.tms.trans.repository.model.TmsSchdInfo;
import com.humuson.tms.trans.repository.model.TmsSchdTarget;
import com.humuson.tms.trans.repository.model.TmsSendInfo;
import com.humuson.tms.trans.repository.model.TmsTargetInfo;
import com.humuson.tms.trans.repository.model.TmsTargetLinkQueryInfo;
import com.humuson.tms.trans.repository.model.TmsTestInfo;
import com.humuson.tms.trans.util.ObjectUtil;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class TmsBatchTargetInfoFactory {
    private static final Logger log = LoggerFactory.getLogger(TmsBatchTargetInfoFactory.class);
    @Autowired
    SendInfoDao sendInfoDao;
    @Autowired
    BasicQueryOptimizer basicQueryOptimizer;
    @Value(value="${tms.target-limit.query}")
    public long maxQueryCount;
    @Value(value="${tms.target-limit.file}")
    public long maxFileLine;
    @Value(value="${tms.ds-chunk-unit:1000}")
    int chunkUnit;
    @Value(value="${tms.ds-schd-unit:100000}")
    int groupDivisionUnit;

    public TmsBatchTargetInfo createBatchTargetInfo(TmsSchdInfo tmsSchdInfo) throws Exception {
        TmsSendInfo tmsSendInfo = this.sendInfoDao.selectSendInfo(tmsSchdInfo.getSEND_ID());
        TmsSchdTarget tmsSchdTarget = this.sendInfoDao.selectSchdTarget(tmsSchdInfo.getSCHD_ID());
        BatchDbTargetInfo batchDbTargetInfo = new BatchDbTargetInfo();
        AtomicInteger targetCount = new AtomicInteger();
        batchDbTargetInfo.setSELECT_QUERY(tmsSchdTarget.getTARGET_QUERY_S());
        ObjectUtil.objectMerge(batchDbTargetInfo, tmsSendInfo);
        batchDbTargetInfo.setDB_ID(-1);
        return this.addTargetField(tmsSendInfo, batchDbTargetInfo, targetCount.get());
    }

    public TmsBatchTargetInfo createBatchTargetInfo(TmsSchdInfo tmsSchdInfo, String selectQueryOfTarget) throws Exception {
        TmsSendInfo tmsSendInfo = this.sendInfoDao.selectSendInfo(tmsSchdInfo.getSEND_ID());
        if (ObjectUtils.isEmpty((Object)tmsSendInfo)) {
            tmsSendInfo = this.sendInfoDao.selectSendInfoEmptyTargetId(tmsSchdInfo.getSEND_ID());
            tmsSendInfo.setTARGET_ID(this.sendInfoDao.selectTargetIdOfAB(tmsSendInfo.getSEND_ADD_ID()));
        }
        BatchDbTargetInfo batchDbTargetInfo = new BatchDbTargetInfo();
        batchDbTargetInfo.setSELECT_QUERY(selectQueryOfTarget);
        ObjectUtil.objectMerge(batchDbTargetInfo, tmsSendInfo);
        batchDbTargetInfo.setDB_ID(-1);
        return this.addTargetField(tmsSendInfo, batchDbTargetInfo);
    }

    public TmsBatchTargetInfo createBatchTargetInfo(TmsSendInfo tmsSendInfo) throws Exception {
        return this.createBatchTargetInfo(tmsSendInfo, true);
    }

    public TmsBatchTargetInfo createBatchTargetInfo(TmsTestInfo tmsTestInfo) throws Exception {
        TmsSendInfo tmsSendInfo = this.sendInfoDao.selectSendInfo(tmsTestInfo.getSEND_ID());
        tmsSendInfo.setTRIGGER_METHOD("O8");
        TmsTargetInfo tmsTargetInfo = this.sendInfoDao.selectOneTargetInfo(tmsTestInfo.getTARGET_ID());
        TmsTargetLinkQueryInfo tmsTargetLinkQueryInfo = tmsTestInfo.getTargetLinkQueryInfo();
        if (this.isFileTarget(tmsTargetInfo.getTARGET_TYPE())) {
            return this.setBatchFileTargetInfo(tmsSendInfo, tmsTargetInfo, tmsTargetLinkQueryInfo);
        }
        BatchDbTargetInfo batchDbTargetInfo = new BatchDbTargetInfo();
        AtomicInteger targetCount = new AtomicInteger();
        targetCount.set(-1);
        targetCount.set(this.getSelectCount(tmsTargetLinkQueryInfo.getDB_ID(), tmsTargetLinkQueryInfo.getDB_TYPE(), tmsTargetLinkQueryInfo.getTEST_QUERY()));
        batchDbTargetInfo.setSELECT_QUERY(tmsTargetLinkQueryInfo.getTEST_QUERY());
        ObjectUtil.objectMerge(batchDbTargetInfo, tmsSendInfo, tmsTargetLinkQueryInfo);
        TmsBatchTargetInfo tmsBatchTargetInfo = this.addTargetField(tmsSendInfo, batchDbTargetInfo, targetCount.get());
        this.updateTargetCount(tmsTargetInfo, targetCount.get());
        this.setEncrypt(tmsBatchTargetInfo, tmsTargetLinkQueryInfo.getENCRYPT_YN());
        return tmsBatchTargetInfo;
    }

    public TmsBatchTargetInfo createBatchTargetInfo(TmsSendInfo tmsSendInfo, boolean selectTargetCount) throws Exception {
        TmsTargetInfo tmsTargetInfo = this.sendInfoDao.selectOneTargetInfo(tmsSendInfo.getTARGET_ID());
        TmsTargetLinkQueryInfo tmsTargetLinkQueryInfo = null;
        if (this.isFileTarget(tmsTargetInfo.getTARGET_TYPE())) {
            tmsTargetLinkQueryInfo = this.sendInfoDao.selectFileTargetLinkQueryInfo(tmsSendInfo.getTARGET_ID());
            return this.setBatchFileTargetInfo(tmsSendInfo, tmsTargetInfo, tmsTargetLinkQueryInfo);
        }
        tmsTargetLinkQueryInfo = this.sendInfoDao.selectOneTargetLinkQueryInfo(tmsSendInfo.getTARGET_ID(), "10");
        BatchDbTargetInfo batchDbTargetInfo = new BatchDbTargetInfo();
        AtomicInteger targetCount = new AtomicInteger();
        targetCount.set(-1);
        String selectQuery = this.addSelectTargetInfo(tmsSendInfo, selectTargetCount, tmsTargetLinkQueryInfo, targetCount);
        this.addUpdateQueryInfo(tmsSendInfo, batchDbTargetInfo);
        ObjectUtil.objectMerge(batchDbTargetInfo, tmsSendInfo, tmsTargetLinkQueryInfo);
        batchDbTargetInfo.setSELECT_QUERY(tmsTargetLinkQueryInfo.getQUERY());
        TmsBatchTargetInfo tmsBatchTargetInfo = this.addTargetField(tmsSendInfo, batchDbTargetInfo, targetCount.get());
        this.updateTargetCount(tmsTargetInfo, targetCount.get());
        this.setEncrypt(tmsBatchTargetInfo, tmsTargetLinkQueryInfo.getENCRYPT_YN());
        return tmsBatchTargetInfo;
    }

    private String addSelectTargetInfo(TmsSendInfo tmsSendInfo, boolean selectTargetCount, TmsTargetLinkQueryInfo tmsTargetLinkQueryInfo, AtomicInteger targetCount) throws Exception {
        Map<String, Object> map = this.preQueryMapping(tmsSendInfo);
        String selectQuery = this.queryMapping(map, tmsTargetLinkQueryInfo.getQUERY());
        if (selectTargetCount) {
            targetCount.set(this.getSelectCount(tmsTargetLinkQueryInfo.getDB_ID(), tmsTargetLinkQueryInfo.getDB_TYPE(), selectQuery));
            if (targetCount.get() > 0) {
                log.info("send_id[{}] db_id[{}] select target count[{}] query[{}]", new Object[]{tmsSendInfo.getSEND_ID(), tmsTargetLinkQueryInfo.getDB_ID(), targetCount, tmsTargetLinkQueryInfo.getQUERY()});
            } else {
                log.debug("send_id[{}] db_id[{}] select target count[0]", (Object)tmsSendInfo.getSEND_ID(), (Object)tmsTargetLinkQueryInfo.getDB_ID());
            }
        }
        return selectQuery;
    }

    private void addUpdateQueryInfo(TmsSendInfo tmsSendInfo, BatchDbTargetInfo batchDbTargetInfo) {
        List<TmsTargetLinkQueryInfo> updateTargetLinkQueryInfos = this.sendInfoDao.selectTargetLinkUpdateQueryInfo(tmsSendInfo.getTARGET_ID(), "40");
        if (!ObjectUtils.isEmpty(updateTargetLinkQueryInfos)) {
            List<Map<Integer, String>> updateTargets = batchDbTargetInfo.getUPDATE_QUERY();
            for (TmsTargetLinkQueryInfo updateTargetLinkQueryInfo : updateTargetLinkQueryInfos) {
                HashMap<Integer, String> update = new HashMap<Integer, String>();
                update.put(updateTargetLinkQueryInfo.getDB_ID(), updateTargetLinkQueryInfo.getQUERY());
                updateTargets.add(update);
            }
        }
    }

    private TmsBatchTargetInfo setBatchFileTargetInfo(TmsSendInfo tmsSendInfo, TmsTargetInfo tmsTargetInfo, TmsTargetLinkQueryInfo tmsTargetLinkQueryInfo) throws Exception {
        long targetCount = TmsBatchTargetInfoFactory.fileCountLines(tmsTargetLinkQueryInfo.getTARGET_FILE_NAME());
        BatchFileTargetInfo batchFileTargetInfo = new BatchFileTargetInfo();
        ObjectUtil.objectMerge(batchFileTargetInfo, tmsSendInfo, tmsTargetLinkQueryInfo);
        TmsBatchTargetInfo tmsBatchTargetInfo = this.addTargetField(tmsSendInfo, batchFileTargetInfo, targetCount);
        this.updateTargetCount(tmsTargetInfo, targetCount);
        this.setEncrypt(tmsBatchTargetInfo, tmsTargetLinkQueryInfo.getENCRYPT_YN());
        batchFileTargetInfo.setENCRYPT(tmsBatchTargetInfo.isENCRYPT());
        return tmsBatchTargetInfo;
    }

    public void setSchdIfRealtime(TmsBatchTargetInfo tmsBatchTargetInfo) {
        if ("C5".equals(tmsBatchTargetInfo.getTRIGGER_METHOD())) {
            TmsSchdInfo tmsSchdInfo = this.sendInfoDao.selectMaxTmsSchdInfo(tmsBatchTargetInfo.getSEND_ID(), tmsBatchTargetInfo.getWORKDAY(), "15");
            tmsBatchTargetInfo.setSCHD_ID(tmsSchdInfo.getSCHD_ID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> preQueryMapping(TmsSendInfo tmsSendInfo) throws Exception {
        TmsTargetLinkQueryInfo tmsTargetLinkQueryInfoTmp = this.sendInfoDao.selectOneTargetLinkQueryInfo(tmsSendInfo.getTARGET_ID(), "50");
        Map map = null;
        if (!ObjectUtils.isEmpty((Object)tmsTargetLinkQueryInfoTmp)) {
            String queryMap = tmsTargetLinkQueryInfoTmp.getQUERY();
            int dbId = tmsTargetLinkQueryInfoTmp.getDB_ID();
            try (TmsJdbcTemplate template = new TmsJdbcTemplate();){
                map = template.db(dbId, false).selectOne(queryMap);
            }
        }
        return map;
    }

    private String queryMapping(Map<String, Object> map, String query) {
        if (ObjectUtils.isEmpty(map)) {
            return query;
        }
        GenericTokenParser parser = new GenericTokenParser("${", "}", (TokenHandler)new VariableTokenHandler(map));
        return parser.parse(query);
    }

    private void setEncrypt(TmsBatchTargetInfo tmsBatchTargetInfo, String encryptYN) {
        tmsBatchTargetInfo.setENCRYPT(encryptYN.equalsIgnoreCase("Y"));
    }

    private TmsBatchTargetInfo addTargetField(TmsSendInfo tmsSendInfo, BatchTargetInfo readBatchTargetInfo) throws Exception {
        return this.addTargetField(tmsSendInfo, readBatchTargetInfo, 0L);
    }

    private TmsBatchTargetInfo addTargetField(TmsSendInfo tmsSendInfo, BatchTargetInfo readBatchTargetInfo, long targetCount) throws Exception {
        readBatchTargetInfo.setJOB_NAME(tmsSendInfo.getTRIGGER_METHOD() + "-" + tmsSendInfo.getSEND_ID() + ":" + System.currentTimeMillis());
        readBatchTargetInfo.setTARGET_COUNT(targetCount);
        readBatchTargetInfo.setCHUNK_UNIT(this.chunkUnit);
        TmsBatchTargetInfo tmsBatchTargetInfo = null;
        tmsBatchTargetInfo = new TmsBatchTargetInfo(readBatchTargetInfo);
        ObjectUtil.objectMerge(tmsBatchTargetInfo, tmsSendInfo);
        if (tmsSendInfo.isAB_YN()) {
            this.createABTarget(tmsSendInfo, tmsBatchTargetInfo);
        }
        tmsBatchTargetInfo.setGROUP_DIVISION_UNIT(this.groupDivisionUnit);
        this.ifPush(tmsBatchTargetInfo, tmsSendInfo.getTRIGGER_METHOD());
        return tmsBatchTargetInfo;
    }

    private void createABTarget(TmsSendInfo tmsSendInfo, TmsBatchTargetInfo tmsBatchTargetInfo) {
        List<TmsABInfo> abTestInfos = this.sendInfoDao.selectAbTestInfo(tmsSendInfo.getSEND_ID());
        long targetCount = tmsBatchTargetInfo.getREAD_TARGET_INFO().getTARGET_COUNT();
        int snapShotCount = 0;
        for (TmsABInfo abTestInfo : abTestInfos) {
            abTestInfo.setSTART_COUNT(snapShotCount + 1);
            long rate = abTestInfo.getRATE();
            snapShotCount = (int)((double)snapShotCount + (double)rate / 100.0 * (double)targetCount);
            abTestInfo.setEND_COUNT(snapShotCount);
            tmsBatchTargetInfo.setTmsABInfo(abTestInfo);
        }
    }

    private void updateTargetCount(TmsTargetInfo tmsTargetInfo, long targetCount) {
        tmsTargetInfo.setTARGET_DS_COUNT(targetCount);
        this.sendInfoDao.updateTargetCount(tmsTargetInfo.getTARGET_ID(), targetCount);
    }

    private void ifPush(TmsBatchTargetInfo batchTargetInfo, String triggerMethod) {
        if (Constants.ChannelType.PU.name().equalsIgnoreCase(batchTargetInfo.getCHANNEL_TYPE())) {
            batchTargetInfo.setPUSH_CHANNEL(true);
            if (this.realTimePushTrigger(triggerMethod)) {
                this.setReadBatchTargetOfRealtimePush(batchTargetInfo, triggerMethod);
            }
        }
    }

    private void setReadBatchTargetOfRealtimePush(TmsBatchTargetInfo batchTargetInfo, String triggerMethod) {
        batchTargetInfo.getREAD_TARGET_INFO().setJOB_NAME(triggerMethod + "-" + batchTargetInfo.getSEND_ID() + ":" + System.currentTimeMillis());
        batchTargetInfo.setDIVIDE_MINUTE(0);
        batchTargetInfo.setGROUP_DIVISION_UNIT(Integer.MAX_VALUE);
    }

    private boolean realTimePushTrigger(String triggerMethod) {
        return Constants.TriggerMethod.C5.name().equals(triggerMethod);
    }

    private boolean isFileTarget(String type) {
        return Constants.TargetType.FILE.name().equals(type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long fileCountLines(String filename) throws IOException {
        try (LineNumberReader reader = new LineNumberReader(new FileReader(filename));){
            while (reader.skip(Long.MAX_VALUE) > 0L) {
            }
            long l = (int)((long)reader.getLineNumber() + 1L);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSelectCount(int dbId, String dbType, String query) throws Exception {
        try (QueryOptimizer queryOptimizer = null;){
            queryOptimizer = dbId == -1 ? this.basicQueryOptimizer.getDefaultOptimizer() : this.basicQueryOptimizer.getQueryOptimizer(dbType);
            queryOptimizer.setDbId(dbId);
            int n = (int)queryOptimizer.selectCount(query);
            return n;
        }
    }
}

