/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.batch.writer;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.trans.repository.model.SiteUser;
import com.humuson.tms.util.date.DateUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="uploadPushBMKTWriter")
@StepScope
public class UploadPushBMKTAgreeWriter
implements ItemWriter<SiteUser> {
    private static final Logger log = LoggerFactory.getLogger(UploadPushBMKTAgreeWriter.class);
    @Autowired
    private WrapperRedisTemplate wrapperRedisTemplate;

    @AfterStep
    public ExitStatus afterStep(StepExecution stepExecution) {
        log.info(" uploadPushBMKTWriter AFTER_STEP");
        List exceptions = stepExecution.getFailureExceptions();
        if (!exceptions.isEmpty()) {
            return ExitStatus.FAILED;
        }
        return ExitStatus.COMPLETED;
    }

    @Transactional
    public void write(List<? extends SiteUser> items) {
        log.debug(" item size {}", (Object)items.size());
        HashMap uploadMap = new HashMap();
        Map<String, String> itemMap = null;
        Long siteId = 0L;
        for (SiteUser siteUser : items) {
            siteId = siteUser.getSiteId();
            itemMap = new HashMap<String, String>();
            if (uploadMap.size() > 0 && uploadMap.containsKey(siteId)) {
                itemMap = (Map)uploadMap.get(siteId);
            }
            if (siteUser.getDelYn().trim().equalsIgnoreCase("Y")) {
                itemMap.put(siteUser.getDeviceId(), "N");
            } else {
                itemMap.put(siteUser.getDeviceId(), siteUser.getBmktFlag());
            }
            uploadMap.put(siteId, itemMap);
        }
        if (uploadMap != null && uploadMap.size() > 0) {
            Iterator keys = uploadMap.keySet().iterator();
            while (keys.hasNext()) {
                try {
                    long l = (Long)keys.next();
                    this.wrapperRedisTemplate.hmsetAll("BMKT:" + l, (Map)uploadMap.get(l));
                    this.wrapperRedisTemplate.hmset("DINDI", "UploadPushBMKT", DateUtil.getFullDateDefaultFormat());
                }
                catch (Exception exception) {
                    log.error("print stack trace", (Throwable)exception);
                    log.error("{}|Redis::[{}] ERROR:{}", new Object[]{"CM0201", "BMKT", exception});
                }
            }
        }
    }
}

