/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.batch.writer;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.trans.repository.model.SiteUser;
import com.humuson.tms.util.JsonUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="uploadSiteWriter")
@StepScope
public class UploadMarketingAgreeWriter
implements ItemWriter<SiteUser> {
    private static final Logger log = LoggerFactory.getLogger(UploadMarketingAgreeWriter.class);
    @Autowired
    private WrapperRedisTemplate wrapperRedisTemplate;

    @AfterStep
    public ExitStatus afterStep(StepExecution stepExecution) {
        log.info(" uploadSiteWriter AFTER_STEP");
        List exceptions = stepExecution.getFailureExceptions();
        if (!exceptions.isEmpty()) {
            return ExitStatus.FAILED;
        }
        return ExitStatus.COMPLETED;
    }

    @Transactional
    public void write(List<? extends SiteUser> items) {
        log.debug(" item size {}", (Object)items.size());
        HashMap uploadMap = new HashMap();
        Map itemMap = null;
        HashMap<String, String> tempMap = null;
        Long siteId = 0L;
        for (SiteUser siteUser : items) {
            siteId = siteUser.getSiteId();
            itemMap = uploadMap.size() > 0 && uploadMap.containsKey(siteId) ? (Map)uploadMap.get(siteId) : new HashMap();
            tempMap = new HashMap<String, String>();
            tempMap.put("EM", siteUser.getMktEm());
            tempMap.put("SM", siteUser.getMktSm());
            tempMap.put("PU", siteUser.getMktPu());
            try {
                log.debug("{} {}", (Object)siteUser.getCustId(), (Object)JsonUtil.convertStringMapToJsonString(tempMap, (boolean)true));
                itemMap.put(siteUser.getCustId(), JsonUtil.convertStringMapToJsonString(tempMap, (boolean)true));
            }
            catch (Exception e) {
                log.error("{}|{} json convert ERROR:{}", new Object[]{"DS0401", siteUser.getCustId(), e});
            }
            uploadMap.put(siteId, itemMap);
        }
        if (uploadMap != null && uploadMap.size() > 0) {
            Iterator keys = uploadMap.keySet().iterator();
            while (keys.hasNext()) {
                try {
                    long l = (Long)keys.next();
                    this.wrapperRedisTemplate.hmsetAll("MMKT:" + l, (Map)uploadMap.get(l));
                    this.wrapperRedisTemplate.hmset("DINDI", "UploadSiteUser", DateUtil.getFullDateDefaultFormat());
                }
                catch (Exception exception) {
                    log.error("{}|Redis::[{}] ERROR:{}", new Object[]{"CM0201", "MMKT", exception});
                }
            }
        }
    }
}

