/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.batch.writer;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.trans.repository.model.Hardbounce;
import com.humuson.tms.util.date.DateUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Component(value="uploadHardWriter")
@StepScope
public class UploadHardbounceWriter
implements ItemWriter<Hardbounce> {
    private static final Logger log = LoggerFactory.getLogger(UploadHardbounceWriter.class);
    @Autowired
    private WrapperRedisTemplate wrapperRedisTemplate;

    @AfterStep
    public ExitStatus afterStep(StepExecution stepExecution) {
        log.info(" uploadHardWriter AFTER_STEP");
        List exceptions = stepExecution.getFailureExceptions();
        if (!exceptions.isEmpty()) {
            return ExitStatus.FAILED;
        }
        return ExitStatus.COMPLETED;
    }

    @Transactional
    public void write(List<? extends Hardbounce> items) {
        log.info(" item size {}", (Object)items.size());
        HashMap<String, String> itemMap = new HashMap<String, String>();
        for (Hardbounce hardbounce : items) {
            itemMap.put(hardbounce.getErrEmail(), hardbounce.getErrEmail());
        }
        if (!ObjectUtils.isEmpty(itemMap)) {
            try {
                this.wrapperRedisTemplate.hmsetAll("MHARD", itemMap);
                this.wrapperRedisTemplate.hmset("DINDI", "UploadHardbounce", DateUtil.getFullDateDefaultFormat());
            }
            catch (Exception e) {
                log.error("1007|filtering hard bounce error redis::[{}] ERROR:{}", (Object)"MHARD", (Object)e);
            }
        }
    }
}

