/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.batch.task;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Configuration
@Component
@EnableAsync
public class DispatchJobConfig {
    private static final Logger log = LoggerFactory.getLogger(DispatchJobConfig.class);
    @Autowired
    JobRepository jobRepository;
    @Value(value="${tms.batch.once.core-pool:10}")
    private int corePoolSize;
    @Value(value="${tms.batch.once.max-pool:20}")
    private int maxPoolSize;
    @Value(value="${tms.batch.once.capacity:2}")
    private int queueCapacity;
    @Value(value="${tms.batch.once.timeout:180}")
    private int threadTimeout;
    @Value(value="${tms.batch.once.waitForTasksToCompleteOnShutdown:true}")
    private boolean isWait;

    @Bean(value={"syncJobLauncher"})
    public JobLauncher syncJobLauncher() {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        try {
            jobLauncher.setJobRepository(this.jobRepository);
            jobLauncher.afterPropertiesSet();
            log.info("[JobService] syncJobLauncher bean set");
        }
        catch (Exception e) {
            log.error("print stack trace", (Throwable)e);
        }
        return jobLauncher;
    }

    @Bean(value={"asyncJobLauncher"})
    public JobLauncher asyncJobLauncher() {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(this.jobRepository);
        jobLauncher.setTaskExecutor((TaskExecutor)this.threadPoolTaskExecutor());
        try {
            jobLauncher.afterPropertiesSet();
            log.info("[JobService] asyncJobLauncher bean set");
        }
        catch (Exception e) {
            log.error("print stack trace", (Throwable)e);
        }
        return jobLauncher;
    }

    @Bean(value={"dsAsyncJobExecutor"})
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.corePoolSize);
        threadPoolTaskExecutor.setMaxPoolSize(this.maxPoolSize);
        threadPoolTaskExecutor.setQueueCapacity(this.queueCapacity);
        threadPoolTaskExecutor.setWaitForTasksToCompleteOnShutdown(this.isWait);
        threadPoolTaskExecutor.setThreadNamePrefix("dsAsyncJob-");
        log.info("[JobService] dsAsyncJobExecutor bean set");
        return threadPoolTaskExecutor;
    }
}

