/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.batch.reader;

import com.humuson.tms.trans.repository.model.RdbFilterStand;
import com.humuson.tms.trans.repository.model.SiteUser;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.batch.MyBatisCursorItemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="uploadPushBMKTReader")
@StepScope
public class UploadPushBMKTAgreeReader
extends MyBatisCursorItemReader<SiteUser> {
    private static final Logger log = LoggerFactory.getLogger(UploadPushBMKTAgreeReader.class);
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Value(value="#{jobParameters['UploadPushBMKT']}")
    private String uptIndi;
    @Value(value="#{jobParameters['bmktStr']}")
    private String bmktStr;
    @Value(value="${tms.upload-info.filter.chunk-size}")
    private int chunkSize;

    @PostConstruct
    public void init() {
        log.info("[UploadPushBMKTAgreeReader] uptIndi {} ", (Object)this.uptIndi);
        this.setSqlSessionFactory(this.sqlSessionFactory);
        this.setQueryId("com.humuson.tms.dataschd.repository.dao.UploadFilterInfoDao.selectPushBmktList");
    }

    @BeforeStep
    public void before() {
        ArrayList<RdbFilterStand> filterList = new ArrayList<RdbFilterStand>();
        HashMap<String, ArrayList<RdbFilterStand>> paramMap = new HashMap<String, ArrayList<RdbFilterStand>>();
        try {
            if (this.bmktStr == null || "".equals(this.bmktStr)) {
                RdbFilterStand readerModel = new RdbFilterStand();
                readerModel.setOrderNum(0);
                readerModel.setSitId(0);
                readerModel.setUptIndi(null);
                filterList.add(readerModel);
                paramMap.put("filterList", filterList);
            } else {
                String[] bmktStrs = this.bmktStr.split("\\|");
                RdbFilterStand readerModel = null;
                for (String bmkt : bmktStrs) {
                    readerModel = new RdbFilterStand();
                    String[] targets = bmkt.split(",");
                    readerModel.setOrderNum(Integer.parseInt(targets[0]));
                    readerModel.setSitId(Integer.parseInt(targets[1]));
                    if (!this.uptIndi.trim().equals("-1")) {
                        readerModel.setUptIndi(this.uptIndi);
                    }
                    filterList.add(readerModel);
                }
                paramMap.put("filterList", filterList);
            }
            this.setParameterValues(paramMap);
            this.afterPropertiesSet();
        }
        catch (Exception e) {
            log.error("1006|push marketing agree reading job param process error {}", (Throwable)e);
        }
    }

    public SiteUser read() throws Exception, UnexpectedInputException, ParseException {
        return (SiteUser)super.read();
    }
}

