/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.batch.reader;

import com.humuson.tms.trans.repository.model.Hardbounce;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.batch.MyBatisCursorItemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="uploadHardReader")
@StepScope
public class UploadHardbounceReader
extends MyBatisCursorItemReader<Hardbounce> {
    private static final Logger log = LoggerFactory.getLogger(UploadHardbounceReader.class);
    @Autowired
    SqlSessionFactory sqlSessionFactory;
    @Value(value="#{jobParameters['UploadHardbounce']}")
    private String uptIndi;
    @Value(value="${tms.upload-info.filter.chunk-size}")
    private int chunkSize;

    @PostConstruct
    public void init() {
        log.info("[UploadHardbounceReader] uptIndi {} ", (Object)this.uptIndi);
        this.setSqlSessionFactory(this.sqlSessionFactory);
        this.setQueryId("com.humuson.tms.dataschd.repository.dao.UploadFilterInfoDao.selectHardbounceErrList");
    }

    @BeforeStep
    public void before() {
        if (!this.uptIndi.trim().equals("-1")) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("UPT_INDI", this.uptIndi);
            try {
                this.setParameterValues(paramMap);
                this.afterPropertiesSet();
            }
            catch (Exception e) {
                log.error("print stack trace", (Throwable)e);
            }
        }
    }

    public Hardbounce read() throws Exception, UnexpectedInputException, ParseException {
        return (Hardbounce)super.read();
    }
}

