/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.trans.batch.processor;

import com.humuson.tms.config.Constants;
import com.humuson.tms.util.JsonUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class TransferProcessor
implements ItemProcessor<Map<String, Object>, Map<String, Object>>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(TransferProcessor.class);
    StepExecution stepExecution;
    @Value(value="${tms.ds-schd-unit}")
    int defaultSchdUnit;
    long schdUnit = 0L;

    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        this.stepExecution.getExecutionContext().putLong("GRP_SEQ", 0L);
        this.stepExecution.getExecutionContext().putString("DIVIDE_MINUTE", "0");
        this.schdUnit = Long.valueOf(this.stepExecution.getJobExecution().getJobParameters().getString("DIVIDE_CNT", this.defaultSchdUnit + ""));
        long lastGrpSeq = this.stepExecution.getJobExecution().getJobParameters().getLong("GRP_SEQ", 0L);
        if (lastGrpSeq != 0L) {
            this.stepExecution.getExecutionContext().putLong("GRP_SEQ", lastGrpSeq);
        }
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return null;
    }

    public Map<String, Object> process(Map<String, Object> items) throws Exception {
        String channelType;
        this.stepExecution.getExecutionContext().putLong("SCHD_TARGETED_COUNT", this.stepExecution.getExecutionContext().getLong("SCHD_TARGETED_COUNT", 0L) + 1L);
        items.put("SEND_ID", this.stepExecution.getJobExecution().getJobParameters().getString("SEND_ID"));
        items.put("TARGET_ID", this.stepExecution.getJobExecution().getJobParameters().getString("TARGET_ID"));
        items.put("WORKDAY", this.stepExecution.getJobExecution().getJobParameters().getString("WORKDAY"));
        items.put("GRP_SEQ", this.stepExecution.getExecutionContext().getLong("GRP_SEQ"));
        if (items.containsKey("TMS_M_ID") && String.valueOf(items.get("TMS_M_ID")).startsWith("TMS-")) {
            String id = String.valueOf(items.get("TMS_M_ID")).trim();
            items.put("DEVICE_ID", id.substring(id.indexOf("TMS-") + 4, id.length()));
        }
        if (!items.containsKey("DEVICE_ID") || items.get("DEVICE_ID") == null || String.valueOf(items.get("DEVICE_ID")).trim().isEmpty()) {
            items.put("DEVICE_ID", -1);
        }
        if ((channelType = this.stepExecution.getJobExecution().getJobParameters().getString("CHANNEL_TYPE")).equalsIgnoreCase(Constants.ChannelType.PU.name())) {
            items.put("APP_GRP_ID", this.stepExecution.getJobExecution().getJobParameters().getString("APP_GRP_ID"));
        }
        items.put("ETC", JsonUtil.convertMapToJsonString(items));
        return items;
    }
}

