/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.api;

import com.humuson.tms.config.lock.AllLockController;
import com.humuson.tms.trans.module.rest.ExtractRandomSampling;
import com.humuson.tms.trans.module.rest.TargetCounterUtil;
import com.humuson.tms.util.JsonUtil;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@DependsOn(value={"defaultDatabaseConfig"})
public class RestAPI {
    private static final Logger log = LoggerFactory.getLogger(RestAPI.class);
    @Autowired
    TargetCounterUtil targetCounterUtil;
    @Autowired
    ExtractRandomSampling extractRandomUser;

    @RequestMapping(value={"/controlCentor"}, method={RequestMethod.POST})
    public String controlCentor(@RequestBody Map<String, Object> json) {
        log.info("control center json info={}", json);
        return "{\"status\":\"OK\",\"process\":\"" + json + "\"}";
    }

    @RequestMapping(value={"/watcher"}, method={RequestMethod.GET})
    public String watcher(@RequestParam(value="demon") String demon, @RequestParam(value="process") String process) {
        log.info("DataScheduler RESTful API test");
        return "{\"status\":\"NO\",\"process\":\"" + process + "\"}";
    }

    @RequestMapping(value={"/test"})
    public String test() {
        log.info("DataScheduler RESTful API test");
        return "DataScheduler RESTful API test";
    }

    @RequestMapping(value={"/alock"})
    public String allLock() {
        log.info("DataScheduler all scheduler try lock");
        AllLockController.SCHDULER.tryAllLock();
        return "try DS scheduler all lock";
    }

    @RequestMapping(value={"/play"})
    public String allUnlock() {
        log.info("DataScheduler all scheduler try un lock");
        AllLockController.SCHDULER.tryAllUnlock();
        return "try DS scheduler all un lock";
    }

    @RequestMapping(value={"/lock"}, method={RequestMethod.GET})
    public String lock(@RequestParam(value="method") String methodName) {
        try {
            if (StringUtils.isEmpty((Object)methodName)) {
                return "this method is empty.";
            }
            AllLockController.SCHDULER.tryLock(methodName);
            return "this method[" + methodName + "] is lock";
        }
        catch (Exception e) {
            return "Exception : " + e.getMessage();
        }
    }

    @RequestMapping(value={"/unlock"}, method={RequestMethod.GET})
    public String unlock(@RequestParam(value="method") String methodName) {
        try {
            if (StringUtils.isEmpty((Object)methodName)) {
                return "method is empty.";
            }
            AllLockController.SCHDULER.tryUnlock(methodName);
            return "this method[" + methodName + "] is un lock";
        }
        catch (Exception e) {
            return "Exception : " + e.getMessage();
        }
    }

    @RequestMapping(value={"/monitor"}, method={RequestMethod.GET})
    public String monitor(@RequestParam(value="method") String methodName, @RequestParam(value="second") int second) {
        try {
            if (StringUtils.isEmpty((Object)methodName)) {
                return "method is empty.";
            }
            if (second == 0) {
                return "Set the time(second) to monitor how long";
            }
            AllLockController.SCHDULER.addMonitor(methodName, second);
            return "this method[" + methodName + "] monitoring start. </br> execution time is recorded in log.info level </br> and after a period of (" + second + ")time second , the monitoring is removed. ";
        }
        catch (Exception e) {
            return "Exception : " + e.getMessage();
        }
    }

    @RequestMapping(value={"/sizeFileTarget"}, method={RequestMethod.POST})
    public String countFileLine(@RequestParam(value="request") String requestJson) {
        try {
            JSONObject object = new JSONObject(requestJson);
            if (!object.has("SEND_ID")) {
                return "ERROR. not contain SEND_ID";
            }
            if (!object.has("REG_ID")) {
                return "ERROR. not contain REG_ID";
            }
            long totalRow = this.targetCounterUtil.getFileTargetCount(object.getLong("SEND_ID"), object.getString("TARGET_FILE_NAME"), object.getString("TARGET_FILE_HEAD_FLAG"), object.getString("REG_ID"));
            object.put("COUNT_TARGET", totalRow);
            return object.toString();
        }
        catch (Exception e) {
            log.error("1001|sizeFileTarget request data[{}] Exception", (Object)requestJson, (Object)e);
            return "Exception : " + e.getMessage();
        }
    }

    @RequestMapping(value={"/sizeDbTarget"}, method={RequestMethod.POST})
    public String countDbLine(@RequestParam(value="request") String requestJson) {
        try {
            JSONObject object = new JSONObject(requestJson);
            if (!object.has("SEND_ID")) {
                return "ERROR. not contain SEND_ID";
            }
            if (!object.has("REG_ID")) {
                return "ERROR. not contain REG_ID";
            }
            long totalRow = this.targetCounterUtil.getDbTargetCount(object.getLong("SEND_ID"), object.getLong("TARGET_ID"), object.getString("REG_ID"));
            object.put("COUNT_TARGET", totalRow);
            return object.toString();
        }
        catch (Exception e) {
            log.error("1002|sizeDbTarget request data[{}] Exception", (Object)requestJson, (Object)e);
            return "Exception : " + e.getMessage();
        }
    }

    @RequestMapping(value={"/random"}, method={RequestMethod.POST})
    public String getRandomUser(@RequestParam(value="SEND_ID") String sendId, @RequestParam(value="CONTENT_SEND_ID", required=false, defaultValue="") String contentSendId, @RequestParam(value="COUNT", required=false, defaultValue="5") String count) {
        try {
            if (sendId == null || sendId.trim().isEmpty()) {
                return "SendId is empty.";
            }
            JSONObject object = this.extractRandomUser.getList(sendId, contentSendId, count);
            JsonUtil.overWriteNullToEmpty((JSONObject)object);
            log.info("getRandomUser snedId({}, result : {}", (Object)sendId, (Object)object.toString());
            return object.toString();
        }
        catch (Exception e) {
            log.error("1003|web call random error send_id[{}], count[{}]", new Object[]{sendId, count, e});
            return "Exception : " + e.getMessage();
        }
    }

    @RequestMapping(value={"/sampleUser"}, method={RequestMethod.POST})
    public String getSampleUser(@RequestBody String test) {
        try {
            if (test == null || test.trim().length() == 0) {
                return "request parameter is empty.";
            }
            log.info("REST API. url : /sampleUser, param : {}", (Object)test);
            JSONObject json = new JSONObject(test);
            String sendId = json.getString("SEND_ID");
            String memberId = json.getString("MEMBER_ID");
            String seq = json.getString("SEQ");
            String contentSendId = null;
            if (json.has("CONTENT_SEND_ID")) {
                contentSendId = json.getString("CONTENT_SEND_ID");
            }
            if (memberId == null || memberId.trim().isEmpty()) {
                return "memberId is empty.";
            }
            if (sendId == null || sendId.trim().isEmpty()) {
                return "SendId is empty.";
            }
            if (seq == null || seq.trim().isEmpty()) {
                return "seq is empty.";
            }
            JSONObject obj = this.extractRandomUser.getUser(sendId, memberId, contentSendId, seq);
            JsonUtil.overWriteNullToEmpty((JSONObject)obj);
            log.info("getSampleUser snedId({}, result : {}", (Object)sendId, (Object)obj.toString());
            return obj.toString();
        }
        catch (Exception e) {
            log.error("1004|sampleUser request data[{}] Exception", (Object)test, (Object)e);
            return "Exception : " + e.getMessage();
        }
    }
}

