/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.smtp;

import com.humuson.tms.sender.smtp.TmsDefaultSmtpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.util.CharsetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TmsSmtpResponseDecoder
extends LineBasedFrameDecoder {
    private static final Logger log = LoggerFactory.getLogger(TmsSmtpResponseDecoder.class);
    private List<CharSequence> details;

    public TmsSmtpResponseDecoder(int maxLineLength) {
        super(maxLineLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected TmsDefaultSmtpResponse decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        ByteBuf frame = (ByteBuf)super.decode(ctx, buffer);
        if (frame == null) {
            return null;
        }
        try {
            int readable = frame.readableBytes();
            int readerIndex = frame.readerIndex();
            if (readable < 3) {
                throw TmsSmtpResponseDecoder.newDecoderException(buffer, readerIndex, readable);
            }
            int code = TmsSmtpResponseDecoder.parseCode(frame);
            byte separator = frame.readByte();
            String detail = frame.isReadable() ? frame.toString(CharsetUtil.US_ASCII) : null;
            List<CharSequence> details = this.details;
            switch (separator) {
                case 32: {
                    this.details = null;
                    if (details != null) {
                        if (detail != null) {
                            details.add(detail);
                        }
                    } else {
                        details = Collections.singletonList(detail);
                    }
                    TmsDefaultSmtpResponse tmsDefaultSmtpResponse = new TmsDefaultSmtpResponse(code, details, "");
                    return tmsDefaultSmtpResponse;
                }
                case 45: {
                    if (detail == null) return null;
                    if (details == null) {
                        this.details = details = new ArrayList<CharSequence>(4);
                    }
                    details.add(detail);
                    return null;
                }
                default: {
                    throw TmsSmtpResponseDecoder.newDecoderException(buffer, readerIndex, readable);
                }
            }
        }
        finally {
            frame.release();
        }
    }

    private static DecoderException newDecoderException(ByteBuf buffer, int readerIndex, int readable) {
        return new DecoderException("Received invalid line: '" + buffer.toString(readerIndex, readable, CharsetUtil.US_ASCII) + '\'');
    }

    private static int parseCode(ByteBuf buffer) {
        int first = TmsSmtpResponseDecoder.parseNumber(buffer.readByte()) * 100;
        int second = TmsSmtpResponseDecoder.parseNumber(buffer.readByte()) * 10;
        int third = TmsSmtpResponseDecoder.parseNumber(buffer.readByte());
        return first + second + third;
    }

    private static int parseNumber(byte b) {
        return Character.digit((char)b, 10);
    }
}

