/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.smtp;

import com.humuson.tms.sender.mail.model.TmsEmailVo;
import com.humuson.tms.sender.smtp.SmtpResponseFuture;
import com.humuson.tms.sender.smtp.TmsDefaultSmtpResponse;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmsRcptChannelHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(TmsRcptChannelHandler.class);
    private SmtpResponseFuture smtpResponseFuture;
    private TmsEmailVo em;
    final Object lock = this;

    public void setResponseFuture(SmtpResponseFuture future) {
        this.smtpResponseFuture = future;
        this.smtpResponseFuture.resetState();
    }

    public void setEmailVo(TmsEmailVo em) {
        this.em = em;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.smtpResponseFuture == null) {
            this.smtpResponseFuture = new SmtpResponseFuture();
        }
        System.out.println("ctx : 2222@@@ " + ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        TmsDefaultSmtpResponse response = (TmsDefaultSmtpResponse)msg;
        System.out.println("@@@@@@" + response);
        this.smtpResponseFuture.resetState();
        switch (response.code()) {
            case 250: {
                this.smtpResponseFuture.set(response);
                break;
            }
            case 220: {
                this.smtpResponseFuture.set(response);
                break;
            }
            case 550: {
                this.smtpResponseFuture.set(response);
                break;
            }
            case 354: {
                this.smtpResponseFuture.set(response);
                break;
            }
            default: {
                this.smtpResponseFuture.set(response);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Channel channel = ctx.channel();
        if (channel.isActive()) {
            ctx.close().sync();
            System.out.println(channel.isActive());
        } else {
            log.error("channel is not active, An error has occurred in the Channel handler : {} ", cause);
            ctx.fireExceptionCaught(cause);
        }
    }
}

