/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.smtp;

import com.humuson.tms.sender.smtp.SmtpUtils;
import io.netty.handler.codec.smtp.SmtpResponse;
import java.util.Collections;
import java.util.List;

public final class TmsDefaultSmtpResponse
implements SmtpResponse {
    private final int code;
    private final List<CharSequence> details;
    private String returnCode = "";

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public TmsDefaultSmtpResponse(int code) {
        this(code, (List<CharSequence>)null, "");
    }

    public TmsDefaultSmtpResponse(int code, CharSequence ... details) {
        this(code, SmtpUtils.toUnmodifiableList(details), "");
    }

    TmsDefaultSmtpResponse(int code, List<CharSequence> details, String returnCode) {
        if (code < 100 || code > 599) {
            throw new IllegalArgumentException("code must be 100 <= code <= 599");
        }
        this.code = code;
        this.details = details == null ? Collections.emptyList() : Collections.unmodifiableList(details);
        this.returnCode = returnCode;
    }

    public int code() {
        return this.code;
    }

    public List<CharSequence> details() {
        return this.details;
    }

    public int hashCode() {
        return this.code * 31 + this.details.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TmsDefaultSmtpResponse)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        TmsDefaultSmtpResponse other = (TmsDefaultSmtpResponse)o;
        return this.code() == other.code() && this.details().equals(other.details());
    }

    public String toString() {
        return "DefaultSmtpResponse{code=" + this.code + ", details=" + this.details + ", returnCode=" + this.returnCode + '}';
    }
}

