/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.smtp;

import io.netty.handler.codec.smtp.SmtpResponse;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtpResponseFuture
implements Future<SmtpResponse> {
    private static final Logger log = LoggerFactory.getLogger(SmtpResponseFuture.class);
    private volatile State state = State.WATTING;
    ArrayBlockingQueue<SmtpResponse> blockingResponse = new ArrayBlockingQueue(1);

    public boolean isCancelled() {
        return false;
    }

    public void resetState() {
        this.state = State.WATTING;
    }

    public boolean isDone() {
        return this.state == State.DONE;
    }

    public SmtpResponse get() throws InterruptedException, ExecutionException {
        SmtpResponse smtpResponse = this.blockingResponse.take();
        this.blockingResponse.put(smtpResponse);
        return smtpResponse;
    }

    public SmtpResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        SmtpResponse responseAfterWait = this.blockingResponse.poll(timeout, unit);
        if (responseAfterWait == null) {
            throw new TimeoutException();
        }
        return responseAfterWait;
    }

    public boolean isSuccess() {
        return this.state == State.DONE;
    }

    public boolean isCancellable() {
        return false;
    }

    public Throwable cause() {
        return null;
    }

    public Future<SmtpResponse> addListener(GenericFutureListener<? extends Future<? super SmtpResponse>> listener) {
        return null;
    }

    public Future<SmtpResponse> addListeners(GenericFutureListener<? extends Future<? super SmtpResponse>> ... listeners) {
        return null;
    }

    public Future<SmtpResponse> removeListener(GenericFutureListener<? extends Future<? super SmtpResponse>> listener) {
        return null;
    }

    public Future<SmtpResponse> removeListeners(GenericFutureListener<? extends Future<? super SmtpResponse>> ... listeners) {
        return null;
    }

    public Future<SmtpResponse> sync() throws InterruptedException {
        return null;
    }

    public Future<SmtpResponse> syncUninterruptibly() {
        return null;
    }

    public Future<SmtpResponse> await() throws InterruptedException {
        return null;
    }

    public Future<SmtpResponse> awaitUninterruptibly() {
        return null;
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        return false;
    }

    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return false;
    }

    public boolean awaitUninterruptibly(long timeoutMillis) {
        return false;
    }

    public SmtpResponse getNow() {
        return null;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public void set(SmtpResponse msg) {
        if (this.state == State.DONE) {
            return;
        }
        try {
            this.blockingResponse.put(msg);
            this.state = State.DONE;
        }
        catch (InterruptedException e) {
            log.error("Set SmtpResponse Error : {}", (Throwable)e);
        }
    }

    private static enum State {
        WATTING,
        DONE;

    }
}

