/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.smtp;

import com.humuson.tms.sender.smtp.NioClientChannelInitializer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;

public class SmtpConfig {
    private final ChannelGroup chGroup = this.chGroup();
    private final Bootstrap bs = this.bootStrap();
    private final EventLoopGroup nioEventGroup = this.nioEventGroup();
    private static SmtpConfig smtpConfig = null;

    private SmtpConfig() {
    }

    public static SmtpConfig getInstance() {
        if (smtpConfig == null) {
            smtpConfig = new SmtpConfig();
        }
        return smtpConfig;
    }

    public ChannelGroup chGroup() {
        DefaultChannelGroup chGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        return chGroup;
    }

    public EventLoopGroup nioEventGroup() {
        return new NioEventLoopGroup();
    }

    public Bootstrap bootStrap() {
        Bootstrap bs = new Bootstrap();
        bs.group(this.nioEventGroup());
        bs.channel(NioSocketChannel.class);
        bs.handler((ChannelHandler)new NioClientChannelInitializer());
        bs.option(ChannelOption.TCP_NODELAY, (Object)true);
        bs.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)1000);
        return bs;
    }

    public ChannelGroup getChGroup() {
        return this.chGroup;
    }

    public Bootstrap getBs() {
        return this.bs;
    }

    public EventLoopGroup getNioEventGroup() {
        return this.nioEventGroup;
    }
}

