/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.smtp;

import com.humuson.tms.sender.smtp.SmtpResponseFuture;
import com.humuson.tms.sender.smtp.TmsDefaultSmtpResponse;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioClientChannelHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(NioClientChannelHandler.class);
    private SmtpResponseFuture smtpResponseFuture;
    final Object lock = this;

    public void setResponseFuture(SmtpResponseFuture future) {
        this.smtpResponseFuture = future;
        this.smtpResponseFuture.resetState();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.smtpResponseFuture == null) {
            this.smtpResponseFuture = new SmtpResponseFuture();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent e;
        if (evt instanceof IdleStateEvent && (e = (IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
            log.error("Idle Channel : READER_IDLE");
            ctx.close();
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        TmsDefaultSmtpResponse response = (TmsDefaultSmtpResponse)msg;
        this.smtpResponseFuture.resetState();
        switch (response.code()) {
            case 250: {
                this.smtpResponseFuture.set(response);
                break;
            }
            case 220: {
                this.smtpResponseFuture.set(response);
                break;
            }
            case 550: {
                this.smtpResponseFuture.set(response);
                break;
            }
            case 354: {
                this.smtpResponseFuture.set(response);
                break;
            }
            default: {
                this.smtpResponseFuture.set(response);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Channel channel = ctx.channel();
        if (channel.isActive()) {
            ctx.close().sync();
        } else {
            log.error("channel is not active, An error has occurred in the Channel handler : {} ", cause);
            ctx.fireExceptionCaught(cause);
        }
    }
}

