/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.sms.util;

import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.sms.model.InfobankColumn;
import com.humuson.tms.sender.sms.model.InfobankLmsColumn;
import com.humuson.tms.sender.sms.model.InfobankMmsAttachFileColumn;
import com.humuson.tms.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsUtil {
    private static final Logger log = LoggerFactory.getLogger(SmsUtil.class);

    public static Map<String, Object> createInfoBankTargetLmsData(JSONObject targetJson, TMSCommonPInfo pinfo) throws JSONException {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        try {
            map.put(InfobankLmsColumn.REQ_DATE.getColumn(), SmsUtil.createData());
            map.put(InfobankLmsColumn.CONTENT.getColumn(), targetJson.get(InfobankLmsColumn.CONTENT.getKey()));
            if (targetJson.has(InfobankLmsColumn.FROM_NUMBER.getKey())) {
                if (!StringUtils.isNull((String)((String)targetJson.get(InfobankLmsColumn.FROM_NUMBER.getKey())))) {
                    map.put(InfobankLmsColumn.FROM_NUMBER.getColumn(), (String)targetJson.get(InfobankLmsColumn.FROM_NUMBER.getKey()));
                } else {
                    map.put(InfobankLmsColumn.FROM_NUMBER.getColumn(), pinfo.getFromNumber());
                }
            } else {
                map.put(InfobankLmsColumn.FROM_NUMBER.getColumn(), pinfo.getFromNumber());
            }
            map.put(InfobankLmsColumn.SERVICE_TYPE.getColumn(), InfobankLmsColumn.SERVICE_TYPE.getValue());
            map.put(InfobankLmsColumn.BROADCAST_YN.getColumn(), InfobankLmsColumn.BROADCAST_YN.getValue());
            map.put(InfobankLmsColumn.ATTACH_FILE_GROUP_KEY.getColumn(), InfobankLmsColumn.ATTACH_FILE_GROUP_KEY.getValue());
            if (targetJson.has(InfobankLmsColumn.SUBJECT.getKey())) {
                map.put(InfobankLmsColumn.SUBJECT.getColumn(), targetJson.get(InfobankLmsColumn.SUBJECT.getKey()));
            } else {
                map.put(InfobankLmsColumn.SUBJECT.getColumn(), pinfo.getSubject());
            }
            map.put(InfobankLmsColumn.MSG_STATUS.getColumn(), InfobankLmsColumn.MSG_STATUS.getValue());
            map.put(InfobankLmsColumn.TMS_M_TARGET.getColumn(), targetJson.get(InfobankLmsColumn.TMS_M_TARGET.getKey()));
            map.put(InfobankLmsColumn.SCHD_ID.getColumn(), pinfo.getSchdId().concat("|").concat(pinfo.getSendId()));
            map.put(InfobankLmsColumn.DOMAIN.getColumn(), targetJson.get(InfobankLmsColumn.DOMAIN.getKey()));
            map.put(InfobankLmsColumn.TMS_M_ID.getColumn(), targetJson.get(InfobankLmsColumn.TMS_M_ID.getKey()).toString().concat("|").concat(targetJson.get("UNIQUE_SEQ").toString()));
            map.put(InfobankLmsColumn.WORKDAY.getColumn(), pinfo.getWorkday());
            map.put(InfobankLmsColumn.SMS_YN.getColumn(), InfobankLmsColumn.SMS_YN.getValue());
        }
        catch (JSONException e) {
            log.error("setting target Data error : {}", (Throwable)e);
            throw new JSONException("setting target Data error : " + e.toString());
        }
        return map;
    }

    public static Map<String, Object> createInfoBankTargetSmsData(JSONObject targetJson, TMSCommonPInfo pinfo) throws JSONException {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        try {
            map.put(InfobankColumn.REQ_DATE.getColumn(), SmsUtil.createData());
            map.put(InfobankColumn.CONTENT.getColumn(), targetJson.get(InfobankColumn.CONTENT.getKey()));
            if (targetJson.has(InfobankColumn.FROM_NUMBER.getKey())) {
                if (!StringUtils.isNull((String)((String)targetJson.get(InfobankColumn.FROM_NUMBER.getKey())))) {
                    map.put(InfobankColumn.FROM_NUMBER.getColumn(), (String)targetJson.get(InfobankColumn.FROM_NUMBER.getKey()));
                } else {
                    map.put(InfobankColumn.FROM_NUMBER.getColumn(), pinfo.getFromNumber());
                }
            } else {
                map.put(InfobankColumn.FROM_NUMBER.getColumn(), pinfo.getFromNumber());
            }
            map.put(InfobankColumn.SERVICE_TYPE.getColumn(), InfobankColumn.SERVICE_TYPE.getValue());
            map.put(InfobankColumn.BROADCAST_YN.getColumn(), InfobankColumn.BROADCAST_YN.getValue());
            map.put(InfobankColumn.MSG_STATUS.getColumn(), InfobankColumn.MSG_STATUS.getValue());
            map.put(InfobankColumn.TMS_M_TARGET.getColumn(), targetJson.get(InfobankColumn.TMS_M_TARGET.getKey()));
            map.put(InfobankColumn.SCHD_ID.getColumn(), pinfo.getSchdId().concat("|").concat(pinfo.getSendId()));
            map.put(InfobankColumn.DOMAIN.getColumn(), targetJson.get(InfobankColumn.DOMAIN.getKey()));
            map.put(InfobankColumn.TMS_M_ID.getColumn(), targetJson.get(InfobankColumn.TMS_M_ID.getKey()).toString().concat("|").concat(targetJson.get("UNIQUE_SEQ").toString()));
            map.put(InfobankColumn.WORKDAY.getColumn(), pinfo.getWorkday());
            map.put(InfobankColumn.SMS_YN.getColumn(), InfobankColumn.SMS_YN.getValue());
        }
        catch (JSONException e) {
            log.error("setting target Data error : {}", (Throwable)e);
            throw new JSONException("setting target Data error : " + e.toString());
        }
        return map;
    }

    public static Map<String, Object> createInfoBankTargetMmsData(JSONObject targetJson, TMSCommonPInfo pinfo) throws JSONException {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        try {
            map.put(InfobankLmsColumn.REQ_DATE.getColumn(), SmsUtil.createData());
            map.put(InfobankLmsColumn.CONTENT.getColumn(), targetJson.get(InfobankLmsColumn.CONTENT.getKey()));
            if (targetJson.has(InfobankLmsColumn.FROM_NUMBER.getKey())) {
                if (!StringUtils.isNull((String)((String)targetJson.get(InfobankLmsColumn.FROM_NUMBER.getKey())))) {
                    map.put(InfobankLmsColumn.FROM_NUMBER.getColumn(), (String)targetJson.get(InfobankLmsColumn.FROM_NUMBER.getKey()));
                } else {
                    map.put(InfobankLmsColumn.FROM_NUMBER.getColumn(), pinfo.getFromNumber());
                }
            } else {
                map.put(InfobankLmsColumn.FROM_NUMBER.getColumn(), pinfo.getFromNumber());
            }
            map.put(InfobankLmsColumn.SERVICE_TYPE.getColumn(), InfobankLmsColumn.SERVICE_TYPE.getValue());
            map.put(InfobankLmsColumn.BROADCAST_YN.getColumn(), InfobankLmsColumn.BROADCAST_YN.getValue());
            map.put(InfobankLmsColumn.ATTACH_FILE_GROUP_KEY.getColumn(), InfobankLmsColumn.ATTACH_FILE_GROUP_KEY.getValue());
            map.put(InfobankLmsColumn.SUBJECT.getColumn(), targetJson.get(InfobankLmsColumn.SUBJECT.getKey()));
            map.put(InfobankLmsColumn.MSG_STATUS.getColumn(), InfobankColumn.MSG_STATUS.getValue());
            map.put(InfobankLmsColumn.TMS_M_TARGET.getColumn(), targetJson.get(InfobankLmsColumn.TMS_M_TARGET.getKey()));
            map.put(InfobankLmsColumn.SCHD_ID.getColumn(), pinfo.getSchdId().concat("|").concat(pinfo.getSendId()));
            map.put(InfobankLmsColumn.DOMAIN.getColumn(), targetJson.get(InfobankLmsColumn.DOMAIN.getKey()));
            map.put(InfobankLmsColumn.TMS_M_ID.getColumn(), targetJson.get(InfobankLmsColumn.TMS_M_ID.getKey()).toString().concat("|").concat(targetJson.get("UNIQUE_SEQ").toString()));
            map.put(InfobankLmsColumn.WORKDAY.getColumn(), pinfo.getWorkday());
            map.put(InfobankLmsColumn.SMS_YN.getColumn(), InfobankLmsColumn.SMS_YN.getValue());
        }
        catch (JSONException e) {
            log.error("setting target Data error : {}", (Throwable)e);
            throw new JSONException("setting target Data error : " + e.toString());
        }
        return map;
    }

    public static Map<String, Object> createInfoBankTargetMmsFileData(JSONObject targetJson, TMSCommonPInfo pinfo) throws JSONException {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        try {
            map.put(InfobankMmsAttachFileColumn.ATTACH_FILE_GROUP_KEY.getColumn(), InfobankMmsAttachFileColumn.ATTACH_FILE_GROUP_KEY.getValue());
            map.put(InfobankMmsAttachFileColumn.ATTACH_FILE_GROUP_SEQ.getColumn(), InfobankMmsAttachFileColumn.ATTACH_FILE_GROUP_KEY.getValue());
            map.put(InfobankMmsAttachFileColumn.ATTACH_FILE_SEQ.getColumn(), InfobankMmsAttachFileColumn.ATTACH_FILE_GROUP_KEY.getValue());
            map.put(InfobankMmsAttachFileColumn.ATTACH_FILE_SUBPATH.getColumn(), InfobankMmsAttachFileColumn.ATTACH_FILE_GROUP_KEY.getValue());
            map.put(InfobankMmsAttachFileColumn.ATTACH_FILE_NAME.getColumn(), targetJson.get(InfobankMmsAttachFileColumn.ATTACH_FILE_NAME.getValue()));
        }
        catch (JSONException e) {
            log.error("setting target Data error : {}", (Throwable)e);
            throw new JSONException("setting target Data error : " + e.toString());
        }
        return map;
    }

    public static String createData() {
        SimpleDateFormat today = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dateObj = new Date();
        return today.format(dateObj);
    }
}

