/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.sms.model;

import com.humuson.tms.sender.common.model.EnumModel;
import java.text.SimpleDateFormat;
import java.util.Date;

public enum InfobankColumn implements EnumModel
{
    REQ_DATE("date_client_req", InfobankColumn.createData()),
    CONTENT("content", ""),
    FROM_NUMBER("callback", ""),
    SERVICE_TYPE("service_type", "1"),
    BROADCAST_YN("broadcast_yn", "N"),
    MSG_STATUS("msg_status", "1"),
    TMS_M_TARGET("recipient_num", ""),
    SCHD_ID("etc1", ""),
    DOMAIN("etc2", ""),
    TMS_M_ID("etc3", ""),
    WORKDAY("etc4", InfobankColumn.createWorkday()),
    SMS_YN("etc5", "N");

    private String column;
    private String defaultValue;

    private InfobankColumn(String column, String defaultValue) {
        this.column = column;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public String getValue() {
        return this.defaultValue;
    }

    @Override
    public String getKey() {
        return this.name();
    }

    public static String[] getColumnList() {
        String[] columnList = new String[InfobankColumn.values().length];
        int i = 0;
        for (InfobankColumn imcColumn : InfobankColumn.values()) {
            columnList[i] = imcColumn.column;
            ++i;
        }
        return columnList;
    }

    public static String createData() {
        SimpleDateFormat today = new SimpleDateFormat("yyyyMMddHHmmss");
        Date dateObj = new Date();
        return today.format(dateObj);
    }

    public static String createWorkday() {
        SimpleDateFormat today = new SimpleDateFormat("yyMMdd");
        Date dateObj = new Date();
        return today.format(dateObj);
    }
}

