/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.sms.model;

import com.humuson.tms.sender.common.model.EnumModel;
import java.text.SimpleDateFormat;
import java.util.Date;

public enum IMCColumn implements EnumModel
{
    REG_DATE("RESERVED_DATE", IMCColumn.createData()),
    MT_TYPE("MT_TYPE", "SM"),
    STATUS("STATUS", "1"),
    PRIORITY("PRIORITY", "N"),
    CONTENT("MESSAGE", ""),
    FROM_NUMBER("CALLBACK", ""),
    TMS_M_TARGET("PHONE_NUMBER", ""),
    SCHD_ID("ETC1", ""),
    DOMAIN("ETC2", ""),
    MEMBER_ID("ETC3", ""),
    WORKDAY("ETC4", ""),
    SMS_YN("ETC5", "N"),
    SUBJECT("TITLE", ""),
    ATTACH_1("ATTACH_FILE_01", ""),
    ATTACH_2("ATTACH_FILE_02", ""),
    ATTACH_3("ATTACH_FILE_03", ""),
    MKT_YN("AD_FLAG", "N");

    private String column;
    private String defaultValue;

    private IMCColumn(String column, String defaultValue) {
        this.column = column;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public String getValue() {
        return this.defaultValue;
    }

    @Override
    public String getKey() {
        return this.name();
    }

    public static String[] getColumnList() {
        String[] columnList = new String[IMCColumn.values().length];
        int i = 0;
        for (IMCColumn imcColumn : IMCColumn.values()) {
            columnList[i] = imcColumn.column;
            ++i;
        }
        return columnList;
    }

    public static String createData() {
        SimpleDateFormat today = new SimpleDateFormat("yyyyMMddHHmmss");
        Date dateObj = new Date();
        return today.format(dateObj);
    }
}

