/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.sms.actor;

import com.humuson.tms.sender.common.TmsMessageListener;
import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.sms.actor.TmsImcSmsSender;
import com.humuson.tms.sender.sms.actor.TmsInfoBankMmsSender;
import com.humuson.tms.sender.sms.actor.TmsInfoBankSmsSender;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmsMmsMessageListener
extends TmsMessageListener {
    private static final Logger log = LoggerFactory.getLogger(TmsMmsMessageListener.class);
    private TmsSenderCommonConfig commonConfig;

    public TmsMmsMessageListener(TmsSenderCommonConfig commonConfig) {
        super(commonConfig);
        this.commonConfig = commonConfig;
    }

    @Override
    public boolean validationCheck(JSONObject targetData, TMSCommonPInfo pinfo) {
        return true;
    }

    @Override
    public TmsResponse sendProcess(JSONObject targetData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        log.debug("Thread : {}", (Object)this.getClass().getName());
        String mmsCompany = chinfo.getTargetCompany().toLowerCase();
        TmsResponse result = null;
        if (mmsCompany.equals("infobank")) {
            TmsInfoBankMmsSender tmsSmsActor = new TmsInfoBankMmsSender(this.commonConfig);
            result = tmsSmsActor.targetDataSendToServer(targetData, pinfo, chinfo);
        } else if (mmsCompany.equals("imc")) {
            TmsImcSmsSender tmsImcSmsActor = new TmsImcSmsSender(this.commonConfig);
            result = tmsImcSmsActor.targetDataSendToServer(targetData, pinfo, chinfo);
        } else {
            TmsInfoBankSmsSender tmsSmsActor = new TmsInfoBankSmsSender(this.commonConfig);
            result = tmsSmsActor.targetDataSendToServer(targetData, pinfo, chinfo);
        }
        log.info("MMS Single SEND RESULT] : {}", (Object)result.toString());
        return result;
    }

    @Override
    public List<TmsResponse> sendBulkProcess(List<JSONObject> targetListData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        log.debug("Thread : {}", (Object)this.getClass().getName());
        ArrayList<TmsResponse> resultList = new ArrayList();
        String mmsCompany = chinfo.getTargetCompany().toLowerCase();
        if (mmsCompany.equals("infobank")) {
            TmsInfoBankMmsSender tmsSmsActor = new TmsInfoBankMmsSender(this.commonConfig);
            resultList = tmsSmsActor.targetDataListSendToServer(targetListData, pinfo, chinfo);
        } else if (mmsCompany.equals("imc")) {
            TmsImcSmsSender tmsImcSmsActor = new TmsImcSmsSender(this.commonConfig);
            resultList = tmsImcSmsActor.targetDataListSendToServer(targetListData, pinfo, chinfo);
        } else {
            TmsInfoBankSmsSender tmsSmsActor = new TmsInfoBankSmsSender(this.commonConfig);
            resultList = tmsSmsActor.targetDataListSendToServer(targetListData, pinfo, chinfo);
        }
        log.info("MMS Single SEND RESULT] : {}", (Object)resultList.size());
        return resultList;
    }

    @Override
    public boolean checkTargetData(JSONObject targetJson) {
        String domain = "";
        String status = "";
        try {
            if (targetJson.has("DOMAIN")) {
                domain = targetJson.getString("DOMAIN");
            }
            if (targetJson.has("STATUS")) {
                status = targetJson.getString("STATUS");
            }
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return !domain.equals("") && status.equals("") && domain.toUpperCase().equals("MMS");
    }
}

