/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.sms.actor;

import com.humuson.tms.sender.common.TmsMessageListener;
import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.sms.actor.TmsImcSmsSender;
import com.humuson.tms.sender.sms.actor.TmsInfoBankLmsSender;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmsLmsMessageListener
extends TmsMessageListener {
    private static final Logger log = LoggerFactory.getLogger(TmsLmsMessageListener.class);
    private TmsSenderCommonConfig commonConfig;

    public TmsLmsMessageListener(TmsSenderCommonConfig commonConfig) {
        super(commonConfig);
        this.commonConfig = commonConfig;
    }

    @Override
    public boolean validationCheck(JSONObject targetData, TMSCommonPInfo pinfo) {
        return true;
    }

    @Override
    public TmsResponse sendProcess(JSONObject targetData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        log.info("Thread : {}", (Object)this.getClass().getName());
        String smsCompany = this.commonConfig.getTmsSmsConfig().getSmsCompany();
        TmsResponse result = null;
        if (smsCompany.equals("infobank")) {
            TmsInfoBankLmsSender tmsLmsActor = new TmsInfoBankLmsSender(this.commonConfig);
            result = tmsLmsActor.targetDataSendToServer(targetData, pinfo, chinfo);
        } else if (smsCompany.equals("imc")) {
            TmsImcSmsSender tmsImcSmsActor = new TmsImcSmsSender(this.commonConfig);
            result = tmsImcSmsActor.targetDataSendToServer(targetData, pinfo, chinfo);
        } else {
            TmsInfoBankLmsSender tmsLmsActor = new TmsInfoBankLmsSender(this.commonConfig);
            result = tmsLmsActor.targetDataSendToServer(targetData, pinfo, chinfo);
        }
        return result;
    }

    @Override
    public List<TmsResponse> sendBulkProcess(List<JSONObject> targetListData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        log.info("Thread : {}", (Object)this.getClass().getName());
        String smsCompany = this.commonConfig.getTmsSmsConfig().getSmsCompany();
        List<Object> resultList = new ArrayList();
        if (smsCompany.equals("infobank")) {
            TmsInfoBankLmsSender tmsLmsActor = new TmsInfoBankLmsSender(this.commonConfig);
            resultList = tmsLmsActor.targetDataListSendToServer(targetListData, pinfo, chinfo);
        } else if (smsCompany.equals("imc")) {
            TmsImcSmsSender tmsImcSmsActor = new TmsImcSmsSender(this.commonConfig);
            resultList = tmsImcSmsActor.targetDataListSendToServer(targetListData, pinfo, chinfo);
        } else {
            TmsInfoBankLmsSender tmsLmsActor = new TmsInfoBankLmsSender(this.commonConfig);
            resultList = tmsLmsActor.targetDataListSendToServer(targetListData, pinfo, chinfo);
        }
        return resultList;
    }

    @Override
    public boolean checkTargetData(JSONObject targetJson) {
        String domain = "";
        String status = "";
        try {
            if (targetJson.has("DOMAIN")) {
                domain = targetJson.getString("DOMAIN");
            }
            if (targetJson.has("STATUS")) {
                status = targetJson.getString("STATUS");
            }
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return !domain.equals("") && status.equals("") && domain.toUpperCase().equals("LMS");
    }
}

