/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.sms.actor;

import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.mail.actor.SenderActor;
import com.humuson.tms.sender.sms.model.InfobankColumn;
import com.humuson.tms.sender.sms.model.InfobankLmsColumn;
import com.humuson.tms.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;

public class TmsInfoBankMmsSender
implements SenderActor {
    private static final Logger log = LoggerFactory.getLogger(TmsInfoBankMmsSender.class);
    private TmsSenderCommonConfig tmsCommonConfig;
    private List<Map<String, Object>> batchValues;
    private List<TmsResponse> resultList;

    public TmsInfoBankMmsSender(TmsSenderCommonConfig tmsCommonConfig) {
        this.tmsCommonConfig = tmsCommonConfig;
        this.batchValues = new ArrayList<Map<String, Object>>();
        this.resultList = new ArrayList<TmsResponse>();
    }

    @Override
    public TmsResponse targetDataSendToServer(JSONObject targetJson, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        JdbcTemplate smsConnection = this.tmsCommonConfig.getTmsSmsConfig().getSmsJdbcTemplate();
        String smsTable = this.tmsCommonConfig.getTmsSmsConfig().getSmsTableName();
        TmsResponse result = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(InfobankColumn.REQ_DATE.getColumn(), InfobankColumn.REQ_DATE.getValue());
            map.put(InfobankColumn.CONTENT.getColumn(), targetJson.get(InfobankColumn.CONTENT.getKey()));
            if (targetJson.has(InfobankColumn.FROM_NUMBER.getKey())) {
                if (!StringUtils.isNull((String)((String)targetJson.get(InfobankColumn.FROM_NUMBER.getKey())))) {
                    map.put(InfobankColumn.FROM_NUMBER.getColumn(), targetJson.get(InfobankColumn.FROM_NUMBER.getKey()));
                } else {
                    map.put(InfobankColumn.FROM_NUMBER.getColumn(), pinfo.getFromNumber());
                }
            } else {
                map.put(InfobankColumn.FROM_NUMBER.getColumn(), pinfo.getFromNumber());
            }
            map.put(InfobankColumn.BROADCAST_YN.getColumn(), InfobankColumn.BROADCAST_YN.getValue());
            map.put(InfobankColumn.MSG_STATUS.getColumn(), InfobankColumn.MSG_STATUS.getValue());
            map.put(InfobankColumn.SERVICE_TYPE.getColumn(), InfobankColumn.SERVICE_TYPE.getValue());
            map.put(InfobankColumn.TMS_M_TARGET.getColumn(), targetJson.get(InfobankColumn.TMS_M_TARGET.getKey()));
            map.put(InfobankColumn.SCHD_ID.getColumn(), targetJson.get(InfobankColumn.SCHD_ID.getKey()));
            map.put(InfobankColumn.DOMAIN.getColumn(), targetJson.get(InfobankColumn.DOMAIN.getKey()));
            map.put(InfobankColumn.TMS_M_ID.getColumn(), targetJson.get(InfobankColumn.TMS_M_ID.getKey()));
            map.put(InfobankColumn.WORKDAY.getColumn(), pinfo.getWorkday());
            map.put(InfobankColumn.SMS_YN.getColumn(), InfobankColumn.SMS_YN.getValue());
            result = new TmsResponse("SUCCESS", "", "TMS0", null, targetJson.get("TMS_M_ID").toString(), targetJson.getString("UNIQUE_SEQ"));
        }
        catch (JSONException e) {
            log.info("setting target Data error : {}", (Throwable)e);
        }
        this.batchValues.add(map);
        try {
            log.info("start time {}", (Object)System.currentTimeMillis());
            SimpleJdbcInsert smsTableInsert = new SimpleJdbcInsert(smsConnection).withTableName(smsTable).usingColumns(InfobankColumn.getColumnList());
            smsTableInsert.executeBatch(this.batchValues.toArray(new Map[this.batchValues.size()]));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("end time {}", (Object)System.currentTimeMillis());
        return result;
    }

    @Override
    public void createTargetData(String targetData) {
    }

    public void insertMmsFileData(List<JSONObject> targetList, TMSCommonPInfo pinfo) {
        JdbcTemplate smsConnection = this.tmsCommonConfig.getTmsSmsConfig().getSmsJdbcTemplate();
        String attachTable = this.tmsCommonConfig.getTmsSmsConfig().getMmsAttachTable();
    }

    @Override
    public List<TmsResponse> targetDataListSendToServer(List<JSONObject> targetList, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        JdbcTemplate smsConnection = this.tmsCommonConfig.getTmsSmsConfig().getSmsJdbcTemplate();
        String smsTable = this.tmsCommonConfig.getTmsSmsConfig().getSmsTableName();
        for (JSONObject targetJson : targetList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            try {
                map.put(InfobankLmsColumn.CONTENT.getColumn(), targetJson.get(InfobankLmsColumn.CONTENT.getKey()));
                if (targetJson.has(InfobankLmsColumn.FROM_NUMBER.getKey())) {
                    if (!StringUtils.isNull((String)((String)targetJson.get(InfobankLmsColumn.FROM_NUMBER.getKey())))) {
                        map.put(InfobankLmsColumn.FROM_NUMBER.getColumn(), targetJson.get(InfobankLmsColumn.FROM_NUMBER.getKey()));
                    } else {
                        map.put(InfobankLmsColumn.FROM_NUMBER.getColumn(), pinfo.getFromNumber());
                    }
                } else {
                    map.put(InfobankLmsColumn.FROM_NUMBER.getColumn(), pinfo.getFromNumber());
                }
                map.put(InfobankLmsColumn.BROADCAST_YN.getColumn(), InfobankLmsColumn.BROADCAST_YN.getValue());
                map.put(InfobankLmsColumn.ATTACH_FILE_GROUP_KEY.getColumn(), InfobankLmsColumn.ATTACH_FILE_GROUP_KEY.getValue());
                map.put(InfobankLmsColumn.SUBJECT.getColumn(), targetJson.get(InfobankLmsColumn.SUBJECT.getKey()));
                map.put(InfobankLmsColumn.BROADCAST_YN.getColumn(), InfobankLmsColumn.BROADCAST_YN.getValue());
                map.put(InfobankLmsColumn.REQ_DATE.getColumn(), InfobankLmsColumn.REQ_DATE.getValue());
                map.put(InfobankLmsColumn.MSG_STATUS.getColumn(), InfobankLmsColumn.MSG_STATUS.getValue());
                map.put(InfobankLmsColumn.SERVICE_TYPE.getColumn(), InfobankLmsColumn.SERVICE_TYPE.getValue());
                map.put(InfobankLmsColumn.TMS_M_TARGET.getColumn(), targetJson.get(InfobankLmsColumn.TMS_M_TARGET.getKey()));
                map.put(InfobankLmsColumn.SCHD_ID.getColumn(), targetJson.get(InfobankLmsColumn.SCHD_ID.getKey()));
                map.put(InfobankLmsColumn.DOMAIN.getColumn(), targetJson.get(InfobankLmsColumn.DOMAIN.getKey()));
                map.put(InfobankLmsColumn.TMS_M_ID.getColumn(), targetJson.get(InfobankLmsColumn.TMS_M_ID.getKey()));
                map.put(InfobankLmsColumn.WORKDAY.getColumn(), targetJson.get(InfobankLmsColumn.CONTENT.getKey()));
                map.put(InfobankLmsColumn.SMS_YN.getColumn(), InfobankLmsColumn.SMS_YN.getValue());
                this.resultList.add(new TmsResponse("SUCCESS", "", "TMS0", null, targetJson.get("TMS_M_ID").toString(), targetJson.getString("UNIQUE_SEQ")));
            }
            catch (JSONException e) {
                log.info("setting target Data error : {}", (Throwable)e);
            }
            this.batchValues.add(map);
        }
        try {
            log.info("start time {}", (Object)System.currentTimeMillis());
            SimpleJdbcInsert smsTableInsert = new SimpleJdbcInsert(smsConnection).withTableName(smsTable).usingColumns(InfobankLmsColumn.getColumnList());
            smsTableInsert.executeBatch(this.batchValues.toArray(new Map[this.batchValues.size()]));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("end time {}", (Object)System.currentTimeMillis());
        return this.resultList;
    }
}

