/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.sms.actor;

import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.mail.actor.SenderActor;
import com.humuson.tms.sender.sms.model.InfobankLmsColumn;
import com.humuson.tms.sender.sms.util.SmsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;

public class TmsInfoBankLmsSender
implements SenderActor {
    private static final Logger log = LoggerFactory.getLogger(TmsInfoBankLmsSender.class);
    private TmsSenderCommonConfig tmsCommonConfig;
    private List<Map<String, Object>> batchValues;
    private List<TmsResponse> resultList;

    public TmsInfoBankLmsSender(TmsSenderCommonConfig tmsCommonConfig) {
        this.tmsCommonConfig = tmsCommonConfig;
        this.batchValues = new ArrayList<Map<String, Object>>();
        this.resultList = new ArrayList<TmsResponse>();
    }

    @Override
    public TmsResponse targetDataSendToServer(JSONObject targetJson, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        JdbcTemplate smsConnection = this.tmsCommonConfig.getTmsSmsConfig().getSmsJdbcTemplate();
        String lmsTable = this.tmsCommonConfig.getTmsSmsConfig().getLmsTableName();
        String errorCode = "TMS0";
        String errorDetail = "SUCCESS";
        String memberId = "";
        String memberSeq = "";
        Map<String, Object> map = null;
        try {
            errorCode = "TMS0";
            errorDetail = "SUCCESS";
            memberId = targetJson.getString("TMS_M_ID");
            memberSeq = targetJson.getString("UNIQUE_SEQ");
            map = SmsUtil.createInfoBankTargetLmsData(targetJson, pinfo);
            this.batchValues.add(map);
            SimpleJdbcInsert smsTableInsert = new SimpleJdbcInsert(smsConnection).withTableName(lmsTable).usingColumns(InfobankLmsColumn.getColumnList());
            smsTableInsert.executeBatch(this.batchValues.toArray(new Map[this.batchValues.size()]));
        }
        catch (Exception e) {
            log.error("target Data error : {}", (Throwable)e);
            errorCode = "TMS9";
            errorDetail = e.toString();
        }
        this.batchValues.clear();
        return new TmsResponse(errorCode, "", errorDetail, null, memberId, memberSeq);
    }

    @Override
    public void createTargetData(String targetData) {
    }

    @Override
    public List<TmsResponse> targetDataListSendToServer(List<JSONObject> targetList, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        JdbcTemplate smsConnection = this.tmsCommonConfig.getTmsSmsConfig().getSmsJdbcTemplate();
        String lmsTable = this.tmsCommonConfig.getTmsSmsConfig().getLmsTableName();
        String errorCode = "TMS0";
        String errorDetail = "SUCCESS";
        String memberId = "";
        String memberSeq = "";
        try {
            for (JSONObject targetJson : targetList) {
                try {
                    memberId = targetJson.getString("TMS_M_ID");
                    memberSeq = targetJson.getString("UNIQUE_SEQ");
                    Map<String, Object> map = SmsUtil.createInfoBankTargetLmsData(targetJson, pinfo);
                    this.batchValues.add(map);
                }
                catch (Exception e) {
                    log.error("parse target data error {}", (Object)e.toString());
                    errorCode = "TMS9";
                    errorDetail = e.toString();
                }
                this.resultList.add(new TmsResponse(errorCode, "", errorDetail, null, memberId, memberSeq));
            }
            SimpleJdbcInsert smsTableInsert = new SimpleJdbcInsert(smsConnection).withTableName(lmsTable).usingColumns(InfobankLmsColumn.getColumnList());
            smsTableInsert.executeBatch(this.batchValues.toArray(new Map[this.batchValues.size()]));
        }
        catch (Exception e) {
            log.info("insert target Data Error {}", (Throwable)e);
            this.resultList.clear();
            this.batchValues.clear();
            for (JSONObject targetJson : targetList) {
                this.resultList.add(this.targetDataSendToServer(targetJson, pinfo, chinfo));
            }
        }
        this.batchValues.clear();
        log.info("end time {}", (Object)System.currentTimeMillis());
        return this.resultList;
    }
}

