/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.sms.actor;

import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.common.util.SenderUtil;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.mail.actor.SenderActor;
import com.humuson.tms.sender.sms.model.IMCColumn;
import com.humuson.tms.sender.sms.model.InfobankColumn;
import com.humuson.tms.util.StringUtils;
import com.humuson.tms.util.date.DateUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;

public class TmsImcSmsSender
implements SenderActor {
    private static final Logger log = LoggerFactory.getLogger(TmsImcSmsSender.class);
    private static final String MT_TYPE_SMS = "SM";
    private static final String MT_TYPE_LMS = "LM";
    private static final String MT_TYPE_MMS = "MM";
    private TmsSenderCommonConfig tmsCommonConfig;
    private List<Map<String, Object>> batchValues;
    private List<TmsResponse> resultList;

    public TmsImcSmsSender(TmsSenderCommonConfig tmsCommonConfig) {
        this.tmsCommonConfig = tmsCommonConfig;
        this.batchValues = new ArrayList<Map<String, Object>>();
        this.resultList = new ArrayList<TmsResponse>();
    }

    @Override
    public TmsResponse targetDataSendToServer(JSONObject targetJson, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        JdbcTemplate smsConnection = this.tmsCommonConfig.getTmsSmsConfig().getSmsJdbcTemplate();
        String smsTable = this.tmsCommonConfig.getTmsSmsConfig().getSmsTableName();
        String errorCode = "TMS0";
        String errorDetail = "SUCCESS";
        String memberId = null;
        String memberSeq = null;
        String insertSMSSql = null;
        try {
            memberId = targetJson.get("TMS_M_ID").toString();
            memberSeq = targetJson.getString("UNIQUE_SEQ");
            Map<String, Object> map = TmsImcSmsSender.createTargetSmsData(targetJson, pinfo);
            this.batchValues.add(map);
            if (this.tmsCommonConfig.getTmsBizTalkConfig().getDbType().equals("oracle")) {
                insertSMSSql = SenderUtil.createInsertString(IMCColumn.getColumnList(), null, smsTable, this.tmsCommonConfig.getTmsSmsConfig().getAtGeneratedKey(), this.tmsCommonConfig.getTmsSmsConfig().getAtSequnce());
                smsConnection.batchUpdate(insertSMSSql, new BatchPreparedStatementSetter(){

                    public void setValues(PreparedStatement ps, int i) throws SQLException {
                        Map batchVal = (Map)TmsImcSmsSender.this.batchValues.get(i);
                        ps.setString(1, batchVal.get(IMCColumn.REG_DATE.getColumn()).toString());
                        ps.setString(2, batchVal.get(IMCColumn.MT_TYPE.getColumn()).toString());
                        ps.setString(3, batchVal.get(IMCColumn.STATUS.getColumn()).toString());
                        ps.setString(4, batchVal.get(IMCColumn.PRIORITY.getColumn()).toString());
                        ps.setString(5, batchVal.get(IMCColumn.CONTENT.getColumn()).toString());
                        ps.setString(6, batchVal.get(IMCColumn.FROM_NUMBER.getColumn()).toString());
                        ps.setString(7, batchVal.get(IMCColumn.TMS_M_TARGET.getColumn()).toString());
                        ps.setString(8, batchVal.get(IMCColumn.SCHD_ID.getColumn()).toString());
                        ps.setString(9, batchVal.get(IMCColumn.DOMAIN.getColumn()).toString());
                        ps.setString(10, batchVal.get(IMCColumn.MEMBER_ID.getColumn()).toString());
                        ps.setString(11, batchVal.get(IMCColumn.WORKDAY.getColumn()).toString());
                        ps.setString(12, batchVal.get(IMCColumn.SMS_YN.getColumn()).toString());
                        ps.setString(13, SenderUtil.nullCheck(batchVal.get(IMCColumn.SUBJECT.getColumn())));
                        ps.setString(14, SenderUtil.nullCheck(batchVal.get(IMCColumn.ATTACH_1.getColumn())));
                        ps.setString(15, SenderUtil.nullCheck(batchVal.get(IMCColumn.ATTACH_2.getColumn())));
                        ps.setString(16, SenderUtil.nullCheck(batchVal.get(IMCColumn.ATTACH_3.getColumn())));
                        ps.setString(17, SenderUtil.nullCheck(batchVal.get(IMCColumn.MKT_YN.getColumn())));
                    }

                    public int getBatchSize() {
                        return TmsImcSmsSender.this.batchValues.size();
                    }
                });
            } else {
                SimpleJdbcInsert smsTableInsert = new SimpleJdbcInsert(smsConnection).withTableName(smsTable).usingColumns(IMCColumn.getColumnList());
                smsTableInsert.executeBatch(this.batchValues.toArray(new Map[this.batchValues.size()]));
            }
            log.debug("start time {}", (Object)System.currentTimeMillis());
        }
        catch (Exception e) {
            log.error("target Data error : {}", (Throwable)e);
            errorCode = "TMS9";
            errorDetail = e.toString();
        }
        log.debug("end time {}", (Object)System.currentTimeMillis());
        this.batchValues.clear();
        return new TmsResponse(errorCode, "", errorDetail, null, memberId, memberSeq);
    }

    @Override
    public void createTargetData(String targetData) {
    }

    @Override
    public List<TmsResponse> targetDataListSendToServer(List<JSONObject> targetList, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        JdbcTemplate smsConnection = this.tmsCommonConfig.getTmsSmsConfig().getSmsJdbcTemplate();
        String smsTable = this.tmsCommonConfig.getTmsSmsConfig().getSmsTableName();
        String errorCode = "TMS0";
        String errorDetail = "SUCCESS";
        String memberId = null;
        String memberSeq = null;
        String insertSMSSql = null;
        for (JSONObject targetJson : targetList) {
            try {
                errorCode = "TMS0";
                errorDetail = "SUCCESS";
                memberId = targetJson.get("TMS_M_ID").toString();
                memberSeq = targetJson.getString("UNIQUE_SEQ");
                Map<String, Object> map = TmsImcSmsSender.createTargetSmsData(targetJson, pinfo);
                this.batchValues.add(map);
            }
            catch (JSONException e) {
                log.error("parse target data error {}", (Object)e.toString());
                errorCode = "TMS9";
                errorDetail = e.toString();
            }
            this.resultList.add(new TmsResponse(errorCode, "", errorDetail, null, memberId, memberSeq));
        }
        try {
            log.debug("start time {}", (Object)System.currentTimeMillis());
            if (this.tmsCommonConfig.getTmsBizTalkConfig().getDbType().equals("oracle")) {
                insertSMSSql = SenderUtil.createInsertString(IMCColumn.getColumnList(), null, smsTable, this.tmsCommonConfig.getTmsSmsConfig().getAtGeneratedKey(), this.tmsCommonConfig.getTmsSmsConfig().getAtSequnce());
                smsConnection.batchUpdate(insertSMSSql, new BatchPreparedStatementSetter(){

                    public void setValues(PreparedStatement ps, int i) throws SQLException {
                        Map batchVal = (Map)TmsImcSmsSender.this.batchValues.get(i);
                        ps.setString(1, batchVal.get(IMCColumn.REG_DATE.getColumn()).toString());
                        ps.setString(2, batchVal.get(IMCColumn.MT_TYPE.getColumn()).toString());
                        ps.setString(3, batchVal.get(IMCColumn.STATUS.getColumn()).toString());
                        ps.setString(4, batchVal.get(IMCColumn.PRIORITY.getColumn()).toString());
                        ps.setString(5, batchVal.get(IMCColumn.CONTENT.getColumn()).toString());
                        ps.setString(6, batchVal.get(IMCColumn.FROM_NUMBER.getColumn()).toString());
                        ps.setString(7, batchVal.get(IMCColumn.TMS_M_TARGET.getColumn()).toString());
                        ps.setString(8, batchVal.get(IMCColumn.SCHD_ID.getColumn()).toString());
                        ps.setString(9, batchVal.get(IMCColumn.DOMAIN.getColumn()).toString());
                        ps.setString(10, batchVal.get(IMCColumn.MEMBER_ID.getColumn()).toString());
                        ps.setString(11, batchVal.get(IMCColumn.WORKDAY.getColumn()).toString());
                        ps.setString(12, batchVal.get(IMCColumn.SMS_YN.getColumn()).toString());
                        ps.setString(13, SenderUtil.nullCheck(batchVal.get(IMCColumn.SUBJECT.getColumn())));
                        ps.setString(14, SenderUtil.nullCheck(batchVal.get(IMCColumn.ATTACH_1.getColumn())));
                        ps.setString(15, SenderUtil.nullCheck(batchVal.get(IMCColumn.ATTACH_2.getColumn())));
                        ps.setString(16, SenderUtil.nullCheck(batchVal.get(IMCColumn.ATTACH_3.getColumn())));
                        ps.setString(17, SenderUtil.nullCheck(batchVal.get(IMCColumn.MKT_YN.getColumn())));
                    }

                    public int getBatchSize() {
                        return TmsImcSmsSender.this.batchValues.size();
                    }
                });
            } else {
                SimpleJdbcInsert smsTableInsert = new SimpleJdbcInsert(smsConnection).withTableName(smsTable).usingColumns(IMCColumn.getColumnList());
                smsTableInsert.executeBatch(this.batchValues.toArray(new Map[this.batchValues.size()]));
            }
        }
        catch (Exception e) {
            log.info("insert target Data Error {}", (Throwable)e);
            this.resultList.clear();
            this.batchValues.clear();
            for (JSONObject targetJson : targetList) {
                this.resultList.add(this.targetDataSendToServer(targetJson, pinfo, chinfo));
            }
        }
        log.debug("end time {}", (Object)System.currentTimeMillis());
        return this.resultList;
    }

    public static Map<String, Object> createTargetSmsData(JSONObject targetJson, TMSCommonPInfo pinfo) throws JSONException {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        try {
            map.put(IMCColumn.REG_DATE.getColumn(), DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
            map.put(IMCColumn.STATUS.getColumn(), IMCColumn.STATUS.getValue());
            map.put(IMCColumn.PRIORITY.getColumn(), IMCColumn.PRIORITY.getValue());
            if (targetJson.has(IMCColumn.FROM_NUMBER.getKey())) {
                if (!StringUtils.isNull((String)((String)targetJson.get(IMCColumn.FROM_NUMBER.getKey())))) {
                    map.put(IMCColumn.FROM_NUMBER.getColumn(), targetJson.get(IMCColumn.FROM_NUMBER.getKey()));
                } else {
                    map.put(IMCColumn.FROM_NUMBER.getColumn(), pinfo.getFromNumber());
                }
            } else {
                map.put(IMCColumn.FROM_NUMBER.getColumn(), pinfo.getFromNumber());
            }
            map.put(IMCColumn.CONTENT.getColumn(), targetJson.get(IMCColumn.CONTENT.getKey()));
            map.put(IMCColumn.TMS_M_TARGET.getColumn(), targetJson.get(IMCColumn.TMS_M_TARGET.getKey()));
            map.put(IMCColumn.DOMAIN.getColumn(), targetJson.get(IMCColumn.DOMAIN.getKey()));
            map.put(IMCColumn.WORKDAY.getColumn(), pinfo.getWorkday());
            map.put(IMCColumn.SMS_YN.getColumn(), IMCColumn.SMS_YN.getValue());
            map.put(IMCColumn.SCHD_ID.getColumn(), pinfo.getSchdId().concat("|").concat(pinfo.getSendId()));
            map.put(IMCColumn.MEMBER_ID.getColumn(), targetJson.get(InfobankColumn.TMS_M_ID.getKey()).toString().concat("|").concat(targetJson.get("UNIQUE_SEQ").toString()));
            if (targetJson.get(IMCColumn.DOMAIN.getKey()) != null && "SMS".equals(targetJson.get(IMCColumn.DOMAIN.getKey()))) {
                map.put(IMCColumn.MT_TYPE.getColumn(), MT_TYPE_SMS);
            } else if (targetJson.get(IMCColumn.DOMAIN.getKey()) != null && "LMS".equals(targetJson.get(IMCColumn.DOMAIN.getKey()))) {
                map.put(IMCColumn.MT_TYPE.getColumn(), MT_TYPE_LMS);
                if (targetJson.has(IMCColumn.SUBJECT.getKey())) {
                    map.put(IMCColumn.SUBJECT.getColumn(), targetJson.get(IMCColumn.SUBJECT.getKey()));
                } else {
                    map.put(IMCColumn.SUBJECT.getColumn(), pinfo.getSubject());
                }
            } else if (targetJson.get(IMCColumn.DOMAIN.getKey()) != null && "MMS".equals(targetJson.get(IMCColumn.DOMAIN.getKey()))) {
                map.put(IMCColumn.MT_TYPE.getColumn(), MT_TYPE_MMS);
                if (targetJson.has(IMCColumn.SUBJECT.getKey())) {
                    map.put(IMCColumn.SUBJECT.getColumn(), targetJson.get(IMCColumn.SUBJECT.getKey()));
                } else {
                    map.put(IMCColumn.SUBJECT.getColumn(), pinfo.getSubject());
                }
                if (targetJson.has(IMCColumn.ATTACH_1.getKey())) {
                    map.put(IMCColumn.ATTACH_1.getColumn(), targetJson.get(IMCColumn.ATTACH_1.getKey()));
                }
                if (targetJson.has(IMCColumn.ATTACH_2.getKey())) {
                    map.put(IMCColumn.ATTACH_2.getColumn(), targetJson.get(IMCColumn.ATTACH_2.getKey()));
                }
                if (targetJson.has(IMCColumn.ATTACH_3.getKey())) {
                    map.put(IMCColumn.ATTACH_3.getColumn(), targetJson.get(IMCColumn.ATTACH_3.getKey()));
                }
            }
            map.put(IMCColumn.MKT_YN.getColumn(), pinfo.getMktYn());
        }
        catch (JSONException e) {
            log.error("setting target Data error : {}", (Throwable)e);
            throw new JSONException("setting target Data error : " + e.toString());
        }
        return map;
    }
}

