/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.result;

import com.humuson.tms.sender.common.util.SenderUtil;
import com.humuson.tms.sender.result.TmsSendResult;
import com.humuson.tms.util.JsonUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultBuilder {
    private static final Logger log = LoggerFactory.getLogger(ResultBuilder.class);
    private static final String CHANNEL_RESULT = "CRSLT";
    private String redisKey = "";
    private String redisField = "";
    private Map<String, Object> resultJsonObj = new HashMap<String, Object>();
    private String resultType;
    private int intervalMin = 0;
    private String schdId;
    private String sendId;
    private String targetSeq;
    private String memberId;
    private String memberIdSeq;
    private String channelType;
    private String campType;

    public ResultBuilder(String resultType) {
        this.resultType = resultType;
    }

    public ResultBuilder memberId(String memberId) {
        this.memberId = memberId;
        this.resultJsonObj.put("MEMBER_ID", memberId);
        return this;
    }

    public ResultBuilder memberIdSeq(String memberIdSeq) {
        this.memberIdSeq = memberIdSeq;
        this.resultJsonObj.put("UNIQUE_SEQ", memberIdSeq);
        return this;
    }

    public ResultBuilder campType(String campType) {
        this.campType = campType;
        this.resultJsonObj.put("CAMP_TYPE", campType);
        return this;
    }

    public ResultBuilder targetSeq(String targetSeq) {
        this.targetSeq = targetSeq;
        this.resultJsonObj.put("TARGET_SEQ", targetSeq);
        return this;
    }

    public ResultBuilder sendId(String sendId) {
        this.sendId = sendId;
        return this;
    }

    public ResultBuilder intervalMin(int intervalMin) {
        this.intervalMin = intervalMin;
        return this;
    }

    public ResultBuilder schdId(String schdId) {
        this.schdId = schdId;
        this.resultJsonObj.put("SCHD_ID", schdId);
        return this;
    }

    public ResultBuilder workday(String workday) {
        this.resultJsonObj.put("WORKDAY", workday);
        return this;
    }

    public ResultBuilder siteId(String siteId) {
        this.resultJsonObj.put("SITE_ID", siteId);
        return this;
    }

    public ResultBuilder domain(String domain) {
        this.resultJsonObj.put("DOMAIN", domain);
        return this;
    }

    public ResultBuilder etc(String etcName, String etcValue) {
        this.resultJsonObj.put(etcName, etcValue);
        return this;
    }

    public ResultBuilder createRedisKey() {
        this.redisKey = CHANNEL_RESULT.concat(":").concat(this.channelType).concat(":").concat(SenderUtil.createCrlstTime(this.intervalMin));
        return this;
    }

    public ResultBuilder createRedisField() {
        this.redisField = this.sendId.concat(":").concat(this.schdId).concat(":").concat(this.targetSeq).concat(":").concat(this.memberId).concat(":").concat(this.memberIdSeq);
        return this;
    }

    public ResultBuilder channelType(String channelType) {
        this.channelType = channelType;
        return this;
    }

    public ResultBuilder errorCode(String errorCode) {
        this.resultJsonObj.put("ERROR_CODE", errorCode);
        return this;
    }

    public ResultBuilder resultType(String resultType) {
        this.resultJsonObj.put("RESULT_TYPE", resultType);
        return this;
    }

    public ResultBuilder errorDetail(String errorDetail) {
        this.resultJsonObj.put("ERROR_DETAIL", errorDetail);
        return this;
    }

    public ResultBuilder serverId(String serverId) {
        this.resultJsonObj.put("SERVER_ID", serverId);
        return this;
    }

    public ResultBuilder startDate(String startDate) {
        this.resultJsonObj.put("START_TIME", startDate);
        return this;
    }

    public ResultBuilder endDate(String endDate) {
        this.resultJsonObj.put("END_TIME", endDate);
        return this;
    }

    public TmsSendResult build() {
        this.createRedisKey();
        this.createRedisField();
        TmsSendResult tmsresult = new TmsSendResult();
        tmsresult.setRedisField(this.redisField);
        tmsresult.setRedisKey(this.redisKey);
        try {
            tmsresult.setRedisValue(JsonUtil.convertMapToJsonString(this.resultJsonObj));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return tmsresult;
    }
}

