/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.push.google;

import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.mail.actor.SenderActor;
import com.humuson.tms.sender.push.google.PushActor;
import com.humuson.tms.sender.push.google.PushContent;
import com.humuson.tms.sender.push.google.TmsEmojiParser;
import com.humuson.tms.sender.push.google.model.PushXmppVo;
import com.humuson.tms.util.date.DateUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;

public class TmsXmppSender
implements SenderActor {
    private static final Logger log = LoggerFactory.getLogger(TmsXmppSender.class);
    private TmsSenderCommonConfig tmsCommonConfig;
    private String senderId;
    private String password;
    private PushActor pushActor;

    public TmsXmppSender(TmsSenderCommonConfig tmsCommonConfig) {
        this.tmsCommonConfig = tmsCommonConfig;
    }

    public void setAppData(String senderId, String password) {
        this.senderId = senderId;
        this.password = password;
        this.pushActor = new PushActor(this.tmsCommonConfig);
    }

    public void connect() {
        try {
            this.pushActor.connect(this.senderId, this.password);
        }
        catch (IOException | InterruptedException | SmackException | XMPPException e) {
            log.error("Connect Error : {}", e);
        }
    }

    public void reconnect() {
        this.pushActor.getConnection();
    }

    public boolean checkConnection() {
        if (this.pushActor.getConnection().isConnected()) {
            return true;
        }
        return this.pushActor.getConnection().isAuthenticated();
    }

    @Async
    public void send(PushXmppVo pushXmppVo) throws Exception {
        HashMap<String, String> payload = new HashMap<String, String>();
        String messageId = null;
        messageId = pushXmppVo.getMessageId().equals("") ? this.pushActor.nextMessageId() : pushXmppVo.getMessageId();
        payload.put("notiImg", pushXmppVo.getPushImg());
        payload.put("notiTitle", pushXmppVo.getNotiTitle());
        payload.put("message", pushXmppVo.getMessage());
        payload.put("i", pushXmppVo.getMessageId());
        payload.put("t", pushXmppVo.getMessageType());
        payload.put("d", "{l:" + pushXmppVo.getPushValue() + "}");
        payload.put("notiMsg", pushXmppVo.getPushMsg());
        payload.put("sound", pushXmppVo.getSound());
        payload.put("send", pushXmppVo.getSendId());
        payload.put("schd", pushXmppVo.getSchdId());
        payload.put("wc", pushXmppVo.getWorkday());
        payload.put("mem", pushXmppVo.getMemberId().concat("|").concat(pushXmppVo.getMemberIdSeq()));
        payload.put("tc", pushXmppVo.getTrackingClose());
        String jsonMessage = PushContent.createJsonMessage(pushXmppVo.getRegistrationId(), messageId, payload, null, null, true);
        log.info("Android message : {}", (Object)jsonMessage.toString());
        if (!this.pushActor.isStartFlag()) {
            Thread pushActorStart = new Thread(this.pushActor);
            pushActorStart.start();
        }
        this.pushActor.registTargetData(messageId, jsonMessage);
    }

    @Override
    public TmsResponse targetDataSendToServer(JSONObject targetData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        TmsResponse tmsResponse = new TmsResponse();
        tmsResponse.setStartDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
        tmsResponse.setCode("TMS0");
        tmsResponse.setDetail("SUCCESS");
        try {
            PushXmppVo pushXmppVo = new PushXmppVo();
            pushXmppVo.setMemberId(targetData.getString("TMS_M_ID"));
            pushXmppVo.setMemberIdSeq(targetData.getString("UNIQUE_SEQ"));
            tmsResponse.setMemberId(pushXmppVo.getMemberId());
            tmsResponse.setMemberIdSeq(pushXmppVo.getMemberIdSeq());
            if (!targetData.has("PUSH_IMG")) {
                pushXmppVo.setPushImg(pinfo.getPushImg());
            } else if (targetData.getString("PUSH_IMG") != null) {
                pushXmppVo.setPushImg(targetData.getString("PUSH_IMG"));
            }
            if (!targetData.has("PUSH_VALUE")) {
                pushXmppVo.setPushValue(pinfo.getPushValue());
            } else if (targetData.getString("PUSH_VALUE") != null) {
                pushXmppVo.setPushValue(targetData.getString("PUSH_VALUE"));
            }
            if (!targetData.has("PUSH_MSG")) {
                pushXmppVo.setPushMsg(TmsEmojiParser.parseToUnicode(this.tmsCommonConfig.isUsingEmoji(), pinfo.getPushMsg()));
            } else {
                pushXmppVo.setPushMsg(TmsEmojiParser.parseToUnicode(this.tmsCommonConfig.isUsingEmoji(), targetData.getString("PUSH_MSG")));
            }
            if (!targetData.has("SUBJECT")) {
                pushXmppVo.setNotiTitle(TmsEmojiParser.parseToUnicode(this.tmsCommonConfig.isUsingEmoji(), pinfo.getSubject()));
            } else {
                pushXmppVo.setNotiTitle(TmsEmojiParser.parseToUnicode(this.tmsCommonConfig.isUsingEmoji(), targetData.getString("SUBJECT")));
            }
            pushXmppVo.setSendId(pinfo.getSendId());
            pushXmppVo.setSchdId(pinfo.getSchdId());
            pushXmppVo.setTrackingClose(pinfo.getTrackingClose());
            pushXmppVo.setMessageId(pinfo.getSiteId().concat("-").concat(pinfo.getSchdId().concat("-").concat(pinfo.getSendId().concat("-").concat(chinfo.getTargetSeq().concat("-").concat(pinfo.getWorkday().concat("-").concat(pushXmppVo.getMemberId().concat("-").concat(pushXmppVo.getMemberIdSeq())))))));
            pushXmppVo.setSound(pinfo.getSound());
            pushXmppVo.setRegistrationId(targetData.getString("TMS_M_TARGET"));
            this.send(pushXmppVo);
        }
        catch (JSONException e) {
            log.error("JSONException {}", (Object)e.toString());
            tmsResponse.setCode("TMS9");
            tmsResponse.setDetail(e.toString());
        }
        catch (Exception e) {
            log.error("Exception {}", (Throwable)e);
            tmsResponse.setCode("TMS9");
            tmsResponse.setDetail(e.toString());
        }
        return tmsResponse;
    }

    @Override
    public List<TmsResponse> targetDataListSendToServer(List<JSONObject> targetList, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        ArrayList<TmsResponse> resultList = new ArrayList<TmsResponse>();
        for (JSONObject targetData : targetList) {
            resultList.add(this.targetDataSendToServer(targetData, pinfo, chinfo));
        }
        return resultList;
    }

    @Override
    public void createTargetData(String targetData) {
    }
}

