/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.push.google;

import com.humuson.tms.sender.common.TmsMessageListener;
import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.push.google.TmsXmppSender;
import com.humuson.tms.util.date.DateUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmsPushMessageListener
extends TmsMessageListener {
    private static final Logger log = LoggerFactory.getLogger(TmsPushMessageListener.class);
    ConcurrentHashMap<String, TmsXmppSender> gcmXmppSenderConcurrentMap = new ConcurrentHashMap();
    private TmsSenderCommonConfig commonConfig;

    public TmsPushMessageListener(TmsSenderCommonConfig commonConfig) {
        super(commonConfig);
        this.commonConfig = commonConfig;
    }

    @Override
    public boolean validationCheck(JSONObject targetData, TMSCommonPInfo pinfo) throws Exception {
        boolean isExistAinfoKey = this.commonConfig.getTmsPushConfig().hasAppInfoKey(pinfo.getAppGrpId());
        if (!isExistAinfoKey) {
            throw new Exception("Redis AINFO is not Exist. key = AINFO:" + pinfo.getAppGrpId());
        }
        return true;
    }

    @Override
    public TmsResponse sendProcess(JSONObject targetData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        Map<Object, Object> appinfos = this.commonConfig.getTmsPushConfig().readAppInfos(pinfo.getAppGrpId());
        pinfo.setGcmApiKey(appinfos.get("A_API_KEY").toString());
        pinfo.setGcmProjectNum(appinfos.get("A_PROJECT_NUM").toString());
        pinfo.setSound("default");
        Object errorMsg = null;
        TmsXmppSender tmsPushActor = null;
        String xmppSenderName = pinfo.getAppGrpId();
        try {
            tmsPushActor = this.getPushSender(xmppSenderName, appinfos.get("A_PROJECT_NUM").toString(), appinfos.get("A_API_KEY").toString());
            TmsResponse result = tmsPushActor.targetDataSendToServer(targetData, pinfo, chinfo);
            return result;
        }
        catch (IllegalArgumentException e) {
            TmsResponse tmsResponse = new TmsResponse();
            tmsResponse.setStartDate(DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
            tmsResponse.setCode("TMS9");
            tmsResponse.setDetail(e.toString());
            return tmsResponse;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized TmsXmppSender getPushSender(String xmppSenderName, String senderId, String password) throws IllegalArgumentException {
        TmsXmppSender tmsPushActor = null;
        if (this.gcmXmppSenderConcurrentMap.get(xmppSenderName) == null) {
            tmsPushActor = new TmsXmppSender(this.commonConfig);
            tmsPushActor.setAppData(senderId, password);
            tmsPushActor.connect();
            if (!tmsPushActor.checkConnection()) throw new IllegalArgumentException("Server Connection Fail");
            this.gcmXmppSenderConcurrentMap.put(xmppSenderName, tmsPushActor);
            return tmsPushActor;
        } else {
            tmsPushActor = this.gcmXmppSenderConcurrentMap.get(xmppSenderName);
            if (tmsPushActor.checkConnection()) return tmsPushActor;
            this.gcmXmppSenderConcurrentMap.remove(xmppSenderName);
            tmsPushActor = new TmsXmppSender(this.commonConfig);
            tmsPushActor.setAppData(senderId, password);
            tmsPushActor.connect();
            if (!tmsPushActor.checkConnection()) throw new IllegalArgumentException("Server ReConnection Fail");
            this.gcmXmppSenderConcurrentMap.put(xmppSenderName, tmsPushActor);
        }
        return tmsPushActor;
    }

    @Override
    public List<TmsResponse> sendBulkProcess(List<JSONObject> targetListData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        List<TmsResponse> resultList = null;
        Map<Object, Object> appinfos = this.commonConfig.getTmsPushConfig().readAppInfos(pinfo.getAppGrpId());
        pinfo.setGcmApiKey(appinfos.get("A_API_KEY").toString());
        pinfo.setGcmProjectNum(appinfos.get("A_PROJECT_NUM").toString());
        pinfo.setSound("default");
        TmsXmppSender tmsPushActor = null;
        Thread t = Thread.currentThread();
        String threadName = t.getName();
        String xmppSenderName = threadName.concat("@").concat(pinfo.getAppGrpId());
        if (this.gcmXmppSenderConcurrentMap.get(xmppSenderName) == null) {
            tmsPushActor = new TmsXmppSender(this.commonConfig);
            String senderId = pinfo.getGcmProjectNum();
            String password = pinfo.getGcmApiKey();
            tmsPushActor.setAppData(senderId, password);
            tmsPushActor.connect();
            this.gcmXmppSenderConcurrentMap.put(xmppSenderName, tmsPushActor);
        } else {
            tmsPushActor = this.gcmXmppSenderConcurrentMap.get(xmppSenderName);
            if (!tmsPushActor.checkConnection()) {
                this.gcmXmppSenderConcurrentMap.remove(xmppSenderName);
                tmsPushActor = new TmsXmppSender(this.commonConfig);
                String senderId = pinfo.getGcmProjectNum();
                String password = pinfo.getGcmApiKey();
                tmsPushActor.setAppData(senderId, password);
                tmsPushActor.connect();
                this.gcmXmppSenderConcurrentMap.put(xmppSenderName, tmsPushActor);
            }
        }
        resultList = tmsPushActor.targetDataListSendToServer(targetListData, pinfo, chinfo);
        return resultList;
    }

    @Override
    public boolean checkTargetData(JSONObject targetJson) {
        String domain = "";
        String status = "";
        try {
            if (targetJson.has("DOMAIN")) {
                domain = targetJson.getString("DOMAIN");
            }
            if (targetJson.has("STATUS")) {
                status = targetJson.getString("STATUS");
            }
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (!domain.equals("") && status.equals("") && domain.toUpperCase().equals("XMPP")) {
            return true;
        }
        log.debug("fail domain {} , status {}", (Object)domain, (Object)status);
        return false;
    }
}

