/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.push.google;

import com.humuson.tms.google.Sender;
import com.humuson.tms.sender.common.TmsMessageListener;
import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.push.google.TmsHttpSender;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmsPushHttpMessageListener
extends TmsMessageListener {
    private static final Logger log = LoggerFactory.getLogger(TmsPushHttpMessageListener.class);
    private TmsSenderCommonConfig commonConfig;
    ConcurrentHashMap<String, Sender> gcmSenderConcurrentMap = new ConcurrentHashMap();

    public TmsPushHttpMessageListener(TmsSenderCommonConfig commonConfig) {
        super(commonConfig);
        this.commonConfig = commonConfig;
    }

    @Override
    public boolean validationCheck(JSONObject targetData, TMSCommonPInfo pinfo) {
        return true;
    }

    @Override
    public TmsResponse sendProcess(JSONObject targetData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        Sender sender = null;
        Map<Object, Object> appinfos = this.commonConfig.getTmsPushConfig().readAppInfos(pinfo.getAppGrpId());
        pinfo.setGcmApiKey(appinfos.get("A_API_KEY").toString());
        pinfo.setGcmProjectNum(appinfos.get("A_PROJECT_NUM").toString());
        pinfo.setSound("default");
        if (this.gcmSenderConcurrentMap.get(pinfo.getGcmApiKey()) == null) {
            sender = new Sender(pinfo.getGcmApiKey());
            this.gcmSenderConcurrentMap.put(pinfo.getGcmApiKey(), sender);
        } else {
            sender = this.gcmSenderConcurrentMap.get(pinfo.getGcmApiKey());
        }
        TmsHttpSender tmsPushActor = new TmsHttpSender(this.commonConfig, sender);
        TmsResponse result = tmsPushActor.targetDataSendToServer(targetData, pinfo, chinfo);
        return result;
    }

    @Override
    public List<TmsResponse> sendBulkProcess(List<JSONObject> targetListData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        Sender sender = null;
        Map<Object, Object> appinfos = this.commonConfig.getTmsPushConfig().readAppInfos(pinfo.getAppGrpId());
        pinfo.setGcmApiKey(appinfos.get("A_API_KEY").toString());
        pinfo.setGcmProjectNum(appinfos.get("A_PROJECT_NUM").toString());
        pinfo.setSound("default");
        if (this.gcmSenderConcurrentMap.get(pinfo.getGcmApiKey()) == null) {
            sender = new Sender(pinfo.getGcmApiKey());
            this.gcmSenderConcurrentMap.put(pinfo.getGcmApiKey(), sender);
        } else {
            sender = this.gcmSenderConcurrentMap.get(pinfo.getGcmApiKey());
        }
        TmsHttpSender tmsPushActor = new TmsHttpSender(this.commonConfig, sender);
        ArrayList<TmsResponse> resultList = new ArrayList<TmsResponse>();
        for (JSONObject targetData : targetListData) {
            resultList.add(tmsPushActor.targetDataSendToServer(targetData, pinfo, chinfo));
        }
        return resultList;
    }

    @Override
    public boolean checkTargetData(JSONObject targetJson) {
        String domain = "";
        String status = "";
        try {
            if (targetJson.has("DOMAIN")) {
                domain = targetJson.getString("DOMAIN");
            }
            if (targetJson.has("STATUS")) {
                status = targetJson.getString("STATUS");
            }
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return !domain.equals("") && status.equals("") && domain.toUpperCase().equals("HTTP");
    }
}

