/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.sender.push.google;

import com.humuson.tms.google.Message;
import com.humuson.tms.google.MulticastResult;
import com.humuson.tms.google.Result;
import com.humuson.tms.google.Sender;
import com.humuson.tms.sender.common.model.TMSCommonPInfo;
import com.humuson.tms.sender.common.model.TmsChannelInfo;
import com.humuson.tms.sender.common.model.TmsResponse;
import com.humuson.tms.sender.common.util.SenderUtil;
import com.humuson.tms.sender.config.TmsHttpConfig;
import com.humuson.tms.sender.config.TmsSenderCommonConfig;
import com.humuson.tms.sender.mail.actor.SenderActor;
import com.humuson.tms.sender.push.google.TmsEmojiParser;
import com.humuson.tms.util.StringUtils;
import com.humuson.tms.util.date.DateUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmsHttpSender
implements SenderActor {
    private static final Logger log = LoggerFactory.getLogger(TmsHttpSender.class);
    private TmsSenderCommonConfig commonConfig;
    private Sender sender;

    public TmsHttpSender(TmsSenderCommonConfig commonConfig, Sender sender) {
        this.commonConfig = commonConfig;
        this.sender = sender;
    }

    @Override
    public TmsResponse targetDataSendToServer(JSONObject targetData, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        Message gcmMessage = this.makeGcmMessage(targetData, pinfo);
        Result result = null;
        String memberId = null;
        String memberIdSeq = null;
        String changedToken = null;
        String token = null;
        String error = "SUCCESS";
        String resultCode = "1000";
        try {
            memberId = targetData.getString("TMS_M_ID");
            memberIdSeq = targetData.getString("UNIQUE_SEQ");
            token = this.commonConfig.isTestRunYn() ? this.commonConfig.getTestGcmToken() : targetData.getString("TMS_M_TARGET");
            log.info("Android message : {}", (Object)gcmMessage.toString());
            result = this.sender.sendNoRetry(gcmMessage, token);
        }
        catch (Exception e) {
            log.error("exception in realtime send gcm : {}", (Throwable)e);
            error = e.getMessage();
        }
        if (result != null) {
            String messageId = result.getMessageId();
            if (messageId != null) {
                if (result.getCanonicalRegistrationId() != null) {
                    changedToken = result.getCanonicalRegistrationId();
                    resultCode = "0000";
                }
            } else {
                resultCode = "2009";
                error = result.getErrorCodeName();
                if (TmsHttpConfig.GCM_ERROR_CODE_MAP.containsKey(resultCode)) {
                    resultCode = TmsHttpConfig.GCM_ERROR_CODE_MAP.get(resultCode);
                }
                log.error("gcm response is unavaliable : {} , {}", (Object)result.toString(), (Object)error);
            }
        } else {
            resultCode = "2009";
        }
        TmsResponse tmsResponse = new TmsResponse(resultCode, "", error, null, memberId, memberIdSeq);
        log.info("response: {}", (Object)tmsResponse.toString());
        return tmsResponse;
    }

    public String createRedisFValue(String memberId, String memberIdSeq) {
        return memberId.concat(":").concat(memberIdSeq);
    }

    @Override
    public List<TmsResponse> targetDataListSendToServer(List<JSONObject> targetList, TMSCommonPInfo pinfo, TmsChannelInfo chinfo) {
        MulticastResult multicastResult = null;
        Message gcmMessage = this.makeGcmMessage(targetList.get(0), pinfo);
        ArrayList<TmsResponse> tmsResultList = new ArrayList<TmsResponse>();
        ArrayList<String> partialDevices = new ArrayList<String>();
        for (JSONObject jsonObject : targetList) {
            try {
                partialDevices.add(jsonObject.getString("TMS_M_TARGET"));
            }
            catch (JSONException e) {
                log.error("GCM empty token is {}", (Object)jsonObject);
            }
        }
        try {
            log.info("Android message : {}", (Object)gcmMessage.toString());
            multicastResult = this.sender.send(gcmMessage, partialDevices, 0);
        }
        catch (IOException e) {
            log.error("multicate send gcm error {}", (Object)e.toString());
            log.debug("multicate send gcm error Deatail {}", (Object)e.toString());
            multicastResult = null;
        }
        if (multicastResult != null) {
            List<Result> results = multicastResult.getResults();
            int size = results.size();
            for (int i = 0; i < size; ++i) {
                String messageId = results.get(i).getMessageId();
                String changedToken = null;
                String error = "SUCCESS";
                String resultCode = "1000";
                if (messageId != null) {
                    if (results.get(i).getCanonicalRegistrationId() != null) {
                        changedToken = results.get(i).getCanonicalRegistrationId();
                        resultCode = "0000";
                    }
                } else {
                    resultCode = "2009";
                    error = results.get(i).getErrorCodeName();
                    if (TmsHttpConfig.GCM_ERROR_CODE_MAP.containsKey(resultCode)) {
                        resultCode = TmsHttpConfig.GCM_ERROR_CODE_MAP.get(resultCode);
                    }
                    log.error("gcm response is unavaliable : {} , {}", (Object)results.get(i).toString(), (Object)error);
                }
                try {
                    tmsResultList.add(new TmsResponse(resultCode, "", error, null, targetList.get(i).getString("TMS_M_ID"), targetList.get(i).getString("UNIQUE_SEQ")));
                    continue;
                }
                catch (JSONException e) {
                    log.error("result Data Error {}", (Object)e.toString());
                }
            }
        } else {
            String errorCode = "TMS9";
            String errorDetail = "multicast Send Error";
            for (JSONObject targetData : targetList) {
                String memberId = null;
                String memberIdSeq = null;
                TmsResponse tmsResult = null;
                try {
                    memberId = targetData.getString("TMS_M_ID");
                    memberIdSeq = targetData.getString("UNIQUE_SEQ");
                    tmsResult = new TmsResponse(errorCode, "", errorDetail, null, memberId, memberIdSeq);
                    tmsResultList.add(tmsResult);
                }
                catch (JSONException e) {
                    log.error("SD0210|Http Send Result Data Error : memberId : {} memberIdSeq : {}", (Object)memberId, memberIdSeq);
                }
            }
        }
        return tmsResultList;
    }

    @Override
    public void createTargetData(String targetData) {
    }

    public Message makeGcmMessage(JSONObject targetData, TMSCommonPInfo pinfo) {
        Message.Builder builder = new Message.Builder();
        builder.priority(Message.Priority.HIGH);
        try {
            if (targetData.has("PUSH_MSG")) {
                builder.addData("notiMsg", TmsEmojiParser.parseToUnicode(this.commonConfig.isUsingEmoji(), targetData.getString("PUSH_MSG")));
            } else {
                builder.addData("notiMsg", TmsEmojiParser.parseToUnicode(this.commonConfig.isUsingEmoji(), pinfo.getPushMsg()));
            }
            if (targetData.has("SUBJECT")) {
                builder.addData("notiTitle", TmsEmojiParser.parseToUnicode(this.commonConfig.isUsingEmoji(), targetData.getString("SUBJECT")));
            } else {
                builder.addData("notiTitle", TmsEmojiParser.parseToUnicode(this.commonConfig.isUsingEmoji(), pinfo.getSubject()));
            }
            if (targetData.has("PUSH_IMG")) {
                builder.addData("notiImg", targetData.getString("PUSH_IMG"));
            } else {
                builder.addData("notiImg", pinfo.getPushImg());
            }
            if (targetData.has("CONTENT_TYPE")) {
                builder.addData("t", targetData.getString("CONTENT_TYPE"));
            } else {
                builder.addData("t", pinfo.getContentType());
            }
            builder.addData("send-time", DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
            String messageId = SenderUtil.createMessageId(pinfo, targetData.getString("TMS_M_ID"), targetData.getString("UNIQUE_SEQ"));
            builder.addData("i", messageId);
            if (pinfo.getSendId() != null) {
                builder.addData("send", pinfo.getSendId());
            }
            if (pinfo.getSendId() != null) {
                builder.addData("schd", pinfo.getSchdId());
            }
            if (pinfo.getTrackingClose() != null) {
                builder.addData("tc", pinfo.getTrackingClose());
            }
            if (pinfo.getWorkday() != null) {
                builder.addData("wc", pinfo.getWorkday());
            }
            if (targetData.getString("TMS_M_ID") != null && targetData.getString("UNIQUE_SEQ") != null) {
                builder.addData("mem", targetData.getString("TMS_M_ID").concat("|").concat(targetData.getString("UNIQUE_SEQ")));
            }
            JSONObject json = new JSONObject();
            if (targetData.has("PUSH_VALUE")) {
                json.put("l", (Object)StringUtils.validString((String)targetData.getString("PUSH_VALUE")));
            } else {
                builder.addData("t", pinfo.getContentType());
                json.put("l", (Object)StringUtils.validString((String)pinfo.getPushValue()));
            }
            builder.addData("d", json.toString());
            builder.delayWhileIdle(false);
        }
        catch (JSONException e) {
            log.error("gcm message json error", (Throwable)e);
        }
        return builder.build();
    }

    public Message testMake() {
        Message.Builder builder = new Message.Builder();
        builder.addData("title", "\uc81c\ubaa9\uc785\ub2c8\ub2e4");
        builder.addData("MSG", "test");
        builder.addData("TYPE_CODE", "test");
        return builder.build();
    }
}

